/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.jpa.parsing.DotNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.IdentificationVariableDeclNode;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SelectNode;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class VariableNode
extends Node {
    private String variableName;
    private String canonicalName;

    public VariableNode() {
    }

    public VariableNode(String string) {
        this.setVariableName(string);
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String string) {
        this.variableName = string;
        this.canonicalName = IdentificationVariableDeclNode.calculateCanonicalName(string);
    }

    public String getCanonicalVariableName() {
        return this.canonicalName;
    }

    public boolean isVariableNode() {
        return true;
    }

    public void applyToQuery(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        String string = this.getCanonicalVariableName();
        ParseTreeContext parseTreeContext = generationContext.getParseTreeContext();
        if (objectLevelReadQuery instanceof ReportQuery) {
            ReportQuery reportQuery = (ReportQuery)objectLevelReadQuery;
            Expression expression = generationContext.expressionFor(string);
            if (expression == null) {
                expression = this.generateExpression(generationContext);
            }
            this.addAttributeWithFetchJoins(reportQuery, expression, generationContext);
        } else {
            this.addFetchJoins(objectLevelReadQuery, generationContext);
        }
    }

    private void addAttributeWithFetchJoins(ReportQuery reportQuery, Expression expression, GenerationContext generationContext) {
        String string = this.getCanonicalVariableName();
        List list = generationContext.getParseTreeContext().getFetchJoins(string);
        if (list == null) {
            reportQuery.addAttribute(string, expression);
        } else {
            ArrayList<Expression> arrayList = new ArrayList<Expression>(list.size());
            for (Node node : list) {
                arrayList.add(node.generateExpression(generationContext));
            }
            reportQuery.addItem(string, expression, arrayList);
        }
    }

    private void addFetchJoins(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        String string = this.getCanonicalVariableName();
        List list = generationContext.getParseTreeContext().getFetchJoins(string);
        if (list != null) {
            for (Node node : list) {
                objectLevelReadQuery.addJoinedAttribute(node.generateExpression(generationContext));
            }
        }
    }

    public Node qualifyAttributeAccess(ParseTreeContext parseTreeContext) {
        return parseTreeContext.isVariable(this.variableName) ? this : (Node)parseTreeContext.getNodeFactory().newQualifiedAttribute(this.getLine(), this.getColumn(), parseTreeContext.getBaseVariable(), this.variableName);
    }

    public void validate(ParseTreeContext parseTreeContext) {
        TypeHelper typeHelper = parseTreeContext.getTypeHelper();
        String string = this.getCanonicalVariableName();
        if (parseTreeContext.isRangeVariable(string)) {
            String string2 = parseTreeContext.schemaForVariable(string);
            this.setType(typeHelper.resolveSchema(string2));
        } else {
            Node node = parseTreeContext.pathForVariable(string);
            if (node == null) {
                throw JPQLException.aliasResolutionException(parseTreeContext.getQueryInfo(), this.getLine(), this.getColumn(), string);
            }
            this.setType(node.getType());
        }
        parseTreeContext.usedVariable(string);
        if (parseTreeContext.isDeclaredInOuterScope(string)) {
            parseTreeContext.registerOuterScopeVariable(string);
        }
    }

    public Expression generateBaseBuilderExpression(GenerationContext generationContext) {
        if (generationContext.useParallelExpressions()) {
            return new ExpressionBuilder(this.resolveClass(generationContext));
        }
        return new ExpressionBuilder();
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Expression expression = null;
        String string = this.getCanonicalVariableName();
        expression = generationContext.expressionFor(string);
        if (expression != null) {
            return expression;
        }
        expression = generationContext.getParseTreeContext().isRangeVariable(string) ? this.generateBaseBuilderExpression(generationContext) : this.generateExpressionForAlias(generationContext);
        generationContext.addExpression(expression, string);
        return expression;
    }

    public Expression generateExpressionForAlias(GenerationContext generationContext) {
        if (generationContext.getParseTree().getQueryNode().isSelectNode() && generationContext.shouldCheckSelectNodeBeforeResolving() && ((SelectNode)generationContext.getParseTree().getQueryNode()).isSelected(this.getCanonicalVariableName())) {
            return new ExpressionBuilder();
        }
        Node node = this.getNodeForAlias(generationContext);
        if (node == null) {
            throw JPQLException.aliasResolutionException(generationContext.getParseTreeContext().getQueryInfo(), this.getLine(), this.getColumn(), this.getVariableName());
        }
        return node.generateExpression(generationContext);
    }

    public Node getNodeForAlias(GenerationContext generationContext) {
        return generationContext.getParseTreeContext().pathForVariable(this.getCanonicalVariableName());
    }

    public boolean isAlias(GenerationContext generationContext) {
        return this.isAlias(generationContext.getParseTreeContext());
    }

    public boolean isAlias(ParseTreeContext parseTreeContext) {
        String string = parseTreeContext.schemaForVariable(this.getCanonicalVariableName());
        return string != null;
    }

    public Class resolveClass(GenerationContext generationContext) {
        Class clazz = null;
        String string = this.getCanonicalVariableName();
        ParseTreeContext parseTreeContext = generationContext.getParseTreeContext();
        if (parseTreeContext.isRangeVariable(string)) {
            String string2 = parseTreeContext.schemaForVariable(string);
            clazz = parseTreeContext.classForSchemaName(string2, generationContext);
        } else {
            DotNode dotNode = (DotNode)parseTreeContext.pathForVariable(string);
            if (dotNode == null) {
                throw JPQLException.aliasResolutionException(parseTreeContext.getQueryInfo(), this.getLine(), this.getColumn(), string);
            }
            clazz = dotNode.resolveClass(generationContext);
        }
        return clazz;
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringIndent(n, stringBuffer);
        stringBuffer.append(this.toStringDisplayName() + "[" + this.getVariableName() + "]");
        return stringBuffer.toString();
    }

    public String getAsString() {
        return this.getVariableName();
    }
}

