/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLRelationshipMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.deferred.AnyMappingContentHandler;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLAnyObjectMapping;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.sessions.Session;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLAnyObjectMappingNodeValue
extends XMLRelationshipMappingNodeValue
implements NullCapableValue {
    private XMLAnyObjectMapping xmlAnyObjectMapping;
    private XMLDescriptor workingDescriptor;

    public XMLAnyObjectMappingNodeValue(XMLAnyObjectMapping xMLAnyObjectMapping) {
        this.xmlAnyObjectMapping = xMLAnyObjectMapping;
    }

    public boolean isOwningNode(XPathFragment xPathFragment) {
        return null == xPathFragment;
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession abstractSession, NamespaceResolver namespaceResolver) {
        return this.marshal(xPathFragment, marshalRecord, object, abstractSession, namespaceResolver, ObjectMarshalContext.getInstance());
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession abstractSession, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        XPathFragment xPathFragment2 = null;
        if (this.xmlAnyObjectMapping.isReadOnly()) {
            return false;
        }
        XMLMarshaller xMLMarshaller = marshalRecord.getMarshaller();
        Object object2 = marshalContext.getAttributeValue(object, this.xmlAnyObjectMapping);
        if (this.xmlAnyObjectMapping.getConverter() != null) {
            object2 = this.xmlAnyObjectMapping.getConverter().convertObjectValueToDataValue(object2, abstractSession, marshalRecord.getMarshaller());
        }
        if (null == object2) {
            return false;
        }
        XPathFragment xPathFragment3 = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(xPathFragment3);
        boolean bl = false;
        XPathFragment xPathFragment4 = null;
        Object object3 = object2;
        if (this.xmlAnyObjectMapping.usesXMLRoot() && object2 instanceof XMLRoot) {
            xPathFragment4 = new XPathFragment();
            bl = true;
            object2 = ((XMLRoot)object2).getObject();
        }
        if (object2 instanceof String) {
            this.marshalSimpleValue(xPathFragment4, marshalRecord, object3, object, object2, abstractSession, namespaceResolver);
        } else {
            Object object4;
            AbstractSession abstractSession2 = null;
            try {
                abstractSession2 = xMLMarshaller.getXMLContext().getSession(object2);
            }
            catch (XMLMarshalException xMLMarshalException) {
                this.marshalSimpleValue(xPathFragment4, marshalRecord, object3, object, object2, abstractSession, namespaceResolver);
                return true;
            }
            XMLDescriptor xMLDescriptor = (XMLDescriptor)abstractSession2.getDescriptor(object2);
            TreeObjectBuilder treeObjectBuilder = (TreeObjectBuilder)xMLDescriptor.getObjectBuilder();
            List list = treeObjectBuilder.addExtraNamespacesToNamespaceResolver(xMLDescriptor, marshalRecord, abstractSession);
            if (bl && (object4 = this.setupFragment((XMLRoot)object3, xPathFragment4, marshalRecord)) != null) {
                list.add(object4);
            }
            object4 = xMLDescriptor.getDefaultRootElement();
            if (!bl && object4 == null) {
                AbstractSessionLog.getLog().log(6, "marshal_warning_null_document_root_element", new Object[]{Helper.getShortClassName(this.getClass()), xMLDescriptor});
            } else {
                String string;
                if (xMLMarshaller != null && xMLMarshaller.getMarshalListener() != null) {
                    xMLMarshaller.getMarshalListener().beforeMarshal(object2);
                }
                if (xPathFragment4 != null) {
                    xPathFragment2 = xPathFragment4;
                } else {
                    xPathFragment2 = new XPathFragment((String)object4);
                    if (xPathFragment2.getNamespaceURI() == null && xPathFragment2.getPrefix() != null) {
                        string = xMLDescriptor.getNonNullNamespaceResolver().resolveNamespacePrefix(xPathFragment2.getPrefix());
                        xPathFragment2.setNamespaceURI(string);
                    }
                }
                if (!bl) {
                    marshalRecord.setLeafElementType(xMLDescriptor.getDefaultRootElementType());
                }
                this.getXPathNode().startElement(marshalRecord, xPathFragment2, object, abstractSession, xMLDescriptor.getNonNullNamespaceResolver(), treeObjectBuilder, object2);
                if (this.xmlAnyObjectMapping.shouldAddXsiType(xMLMarshaller, xMLDescriptor, object3, bl)) {
                    string = xMLDescriptor.getSchemaReference().getSchemaContext();
                    this.addTypeAttribute(xMLDescriptor, marshalRecord, string);
                }
                this.writeExtraNamespaces(list, marshalRecord, abstractSession);
                treeObjectBuilder.buildRow((AbstractRecord)marshalRecord, object2, abstractSession2, xMLMarshaller);
                marshalRecord.endElement(xPathFragment2, namespaceResolver);
                treeObjectBuilder.removeExtraNamespacesFromNamespaceResolver(marshalRecord, list, abstractSession);
                if (xMLMarshaller != null && xMLMarshaller.getMarshalListener() != null) {
                    xMLMarshaller.getMarshalListener().afterMarshal(object2);
                }
            }
        }
        return true;
    }

    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes attributes) {
        block7: {
            try {
                Object object;
                XMLContext xMLContext = unmarshalRecord.getUnmarshaller().getXMLContext();
                this.workingDescriptor = this.findReferenceDescriptor(xPathFragment, unmarshalRecord, attributes, this.xmlAnyObjectMapping, this.xmlAnyObjectMapping.getKeepAsElementPolicy());
                if (this.workingDescriptor == null) {
                    object = new QName(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName());
                    this.workingDescriptor = xMLContext.getDescriptor((QName)object);
                    if (this.workingDescriptor != null && this.workingDescriptor.isWrapper()) {
                        this.workingDescriptor = null;
                    }
                }
                object = this.xmlAnyObjectMapping.getKeepAsElementPolicy();
                if (this.workingDescriptor == null && object == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || object == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) {
                    this.setupHandlerForKeepAsElementPolicy(unmarshalRecord, xPathFragment, attributes);
                    break block7;
                }
                if (this.workingDescriptor != null) {
                    this.processChild(xPathFragment, unmarshalRecord, attributes, this.workingDescriptor, this.xmlAnyObjectMapping);
                    break block7;
                }
                AnyMappingContentHandler anyMappingContentHandler = new AnyMappingContentHandler(unmarshalRecord, this.xmlAnyObjectMapping.usesXMLRoot());
                String string = xPathFragment.getLocalName();
                if (xPathFragment.getPrefix() != null) {
                    string = xPathFragment.getPrefix() + ":" + string;
                }
                anyMappingContentHandler.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), string, attributes);
                unmarshalRecord.getXMLReader().setContentHandler(anyMappingContentHandler);
                return true;
            }
            catch (SAXException sAXException) {
                throw XMLMarshalException.unmarshalException(sAXException);
            }
        }
        return true;
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        unmarshalRecord.removeNullCapableValue(this);
        Object object = null;
        if (null != unmarshalRecord.getChildRecord()) {
            object = unmarshalRecord.getChildRecord().getCurrentObject();
            if (this.xmlAnyObjectMapping.getConverter() != null) {
                object = this.xmlAnyObjectMapping.getConverter().convertDataValueToObjectValue(object, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
            }
            if (!this.xmlAnyObjectMapping.usesXMLRoot()) {
                unmarshalRecord.setAttributeValue(object, this.xmlAnyObjectMapping);
            } else if (this.workingDescriptor != null) {
                String string = xPathFragment.getPrefix();
                if (string == null && xPathFragment.getNamespaceURI() != null) {
                    string = unmarshalRecord.resolveNamespaceUri(xPathFragment.getNamespaceURI());
                }
                object = this.workingDescriptor.wrapObjectInXMLRoot(object, xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), string, false);
                unmarshalRecord.setAttributeValue(object, this.xmlAnyObjectMapping);
                this.workingDescriptor = null;
            }
        } else {
            SAXFragmentBuilder sAXFragmentBuilder = unmarshalRecord.getFragmentBuilder();
            UnmarshalKeepAsElementPolicy unmarshalKeepAsElementPolicy = this.xmlAnyObjectMapping.getKeepAsElementPolicy();
            if ((unmarshalKeepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || unmarshalKeepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) && sAXFragmentBuilder.getNodes().size() != 0) {
                this.setOrAddAttributeValueForKeepAsElement(sAXFragmentBuilder, this.xmlAnyObjectMapping, this.xmlAnyObjectMapping.getConverter(), unmarshalRecord, false, null);
            } else {
                this.endElementProcessText(unmarshalRecord, this.xmlAnyObjectMapping.getConverter(), xPathFragment, null);
            }
        }
    }

    protected void setOrAddAttributeValue(UnmarshalRecord unmarshalRecord, Object object, XPathFragment xPathFragment, Object object2) {
        if (!this.xmlAnyObjectMapping.usesXMLRoot()) {
            unmarshalRecord.setAttributeValue(object, this.xmlAnyObjectMapping);
        } else {
            XMLRoot xMLRoot = new XMLRoot();
            xMLRoot.setNamespaceURI(xPathFragment.getNamespaceURI());
            xMLRoot.setSchemaType(unmarshalRecord.getTypeQName());
            xMLRoot.setLocalName(xPathFragment.getLocalName());
            xMLRoot.setObject(object);
            unmarshalRecord.setAttributeValue(xMLRoot, this.xmlAnyObjectMapping);
        }
    }

    public void setNullValue(Object object, Session session) {
        this.xmlAnyObjectMapping.setAttributeValueInObject(object, null);
    }

    public boolean isNullCapableValue() {
        return true;
    }

    private Namespace setupFragment(XMLRoot xMLRoot, XPathFragment xPathFragment, MarshalRecord marshalRecord) {
        Namespace namespace = null;
        String string = xMLRoot.getLocalName();
        if (xMLRoot.getNamespaceURI() != null) {
            xPathFragment.setNamespaceURI(xMLRoot.getNamespaceURI());
            String string2 = marshalRecord.getNamespaceResolver().resolveNamespaceURI(xMLRoot.getNamespaceURI());
            if (string2 == null || string2.equals("")) {
                string2 = marshalRecord.getNamespaceResolver().generatePrefix("ns0");
                namespace = new Namespace(string2, xPathFragment.getNamespaceURI());
            }
            string = string2 + ":" + string;
        }
        xPathFragment.setXPath(string);
        return namespace;
    }

    private void marshalSimpleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object object2, Object object3, AbstractSession abstractSession, NamespaceResolver namespaceResolver) {
        if (xPathFragment != null) {
            QName qName = ((XMLRoot)object).getSchemaType();
            object3 = this.getValueToWrite(qName, object3, (XMLConversionManager)abstractSession.getDatasourcePlatform().getConversionManager(), namespaceResolver);
            Namespace namespace = this.setupFragment((XMLRoot)object, xPathFragment, marshalRecord);
            this.getXPathNode().startElement(marshalRecord, xPathFragment, object2, abstractSession, namespaceResolver, null, null);
            if (namespace != null) {
                marshalRecord.attribute("http://www.w3.org/2000/xmlns/", "http://www.w3.org/2000/xmlns/", "xmlns:" + namespace.getPrefix(), namespace.getNamespaceURI());
            }
            this.updateNamespaces(qName, marshalRecord);
        }
        if (object3 instanceof String) {
            marshalRecord.characters((String)object3);
        } else {
            marshalRecord.node((Node)object3, marshalRecord.getNamespaceResolver());
        }
        if (xPathFragment != null) {
            marshalRecord.endElement(xPathFragment, namespaceResolver);
        }
    }

    public XMLAnyObjectMapping getMapping() {
        return this.xmlAnyObjectMapping;
    }
}

