/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;

public class DOMReader
extends XMLReader {
    ContentHandler contentHandler;
    LexicalHandler lexicalHandler;
    private Node currentNode;
    private DocumentPreservationPolicy docPresPolicy;

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/properties/lexical-handler")) {
            this.lexicalHandler = (LexicalHandler)object;
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void parse(InputSource inputSource) {
    }

    public void parse(String string) {
    }

    public void parse(Node node) throws SAXException {
        if (this.getContentHandler() == null) {
            return;
        }
        Element element = null;
        element = node.getNodeType() == 9 ? ((Document)node).getDocumentElement() : (Element)node;
        this.processParentNamespaces(element);
        this.startDocument();
        this.setupLocator(element.getOwnerDocument());
        this.reportElementEvents(element);
        this.endDocument();
    }

    protected void processParentNamespaces(Element element) throws SAXException {
        Node node = element.getParentNode();
        if (node != null && node.getNodeType() == 9) {
            return;
        }
        Stack<Node> stack = new Stack<Node>();
        while (node != null && node.getNodeType() != 9) {
            stack.push(node);
            node = node.getParentNode();
        }
        Iterator iterator = stack.iterator();
        while (iterator.hasNext()) {
            NamedNodeMap namedNodeMap = ((Node)stack.pop()).getAttributes();
            if (namedNodeMap == null) continue;
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String string = attr.getPrefix();
                if (string == null || !string.equals("xmlns")) continue;
                this.getContentHandler().startPrefixMapping(attr.getLocalName(), attr.getValue());
            }
        }
    }

    protected void reportElementEvents(Element element) throws SAXException {
        this.currentNode = element;
        IndexedAttributeList indexedAttributeList = this.buildAttributeList(element);
        String string = element.getLocalName();
        String string2 = string == null ? (string = element.getNodeName()) : this.getQName(element);
        this.getContentHandler().startElement(element.getNamespaceURI(), string, string2, indexedAttributeList);
        this.handleChildNodes(element.getChildNodes());
        this.endPrefixMappings(element);
        this.getContentHandler().endElement(element.getNamespaceURI(), string, string2);
    }

    protected IndexedAttributeList buildAttributeList(Element element) throws SAXException {
        IndexedAttributeList indexedAttributeList = new IndexedAttributeList();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getPrefix();
            if (string != null && string.equals("xmlns")) {
                this.getContentHandler().startPrefixMapping(attr.getLocalName(), attr.getValue());
                this.handleXMLNSPrefixedAttribute(element, attr);
            } else if (string == null) {
                String string2 = attr.getLocalName();
                if (string2 == null) {
                    string2 = attr.getNodeName();
                }
                if (string2 != null && string2.equals("xmlns")) {
                    this.getContentHandler().startPrefixMapping("", attr.getValue());
                }
            }
            indexedAttributeList.addAttribute(attr);
        }
        return indexedAttributeList;
    }

    protected void endPrefixMappings(Element element) throws SAXException {
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getPrefix();
            if (string != null && string.equals("xmlns")) {
                this.getContentHandler().endPrefixMapping(attr.getLocalName());
                continue;
            }
            if (string != null) continue;
            String string2 = attr.getLocalName();
            if (string2 == null) {
                string2 = attr.getNodeName();
            }
            if (string2 == null) continue;
            this.getContentHandler().endPrefixMapping("");
        }
    }

    protected String getQName(Element element) throws SAXException {
        if (element.getLocalName() == null) {
            return element.getNodeName();
        }
        String string = "";
        String string2 = element.getPrefix();
        if (string2 != null && !string2.equals("")) {
            string = string2 + ":" + element.getLocalName();
            this.handlePrefixedAttribute(element);
        } else {
            string = element.getLocalName();
        }
        return string;
    }

    protected void handleXMLNSPrefixedAttribute(Element element, Attr attr) {
    }

    protected void handlePrefixedAttribute(Element element) throws SAXException {
    }

    protected void handleChildNodes(NodeList nodeList) throws SAXException {
        Node node = null;
        if (nodeList.getLength() > 0) {
            node = nodeList.item(0);
        }
        while (node != null) {
            Object object;
            if (node.getNodeType() == 3) {
                object = ((Text)node).getNodeValue().toCharArray();
                this.getContentHandler().characters((char[])object, 0, ((char[])object).length);
            } else if (node.getNodeType() == 8) {
                object = ((Comment)node).getNodeValue().toCharArray();
                if (this.lexicalHandler != null) {
                    this.lexicalHandler.comment((char[])object, 0, ((char[])object).length);
                }
            } else if (node.getNodeType() == 1) {
                object = (Element)node;
                this.reportElementEvents((Element)object);
            } else if (node.getNodeType() == 4) {
                if (this.lexicalHandler != null) {
                    this.lexicalHandler.startCDATA();
                }
                object = ((CDATASection)node).getData().toCharArray();
                this.getContentHandler().characters((char[])object, 0, ((char[])object).length);
                if (this.lexicalHandler != null) {
                    this.lexicalHandler.endCDATA();
                }
            }
            node = node.getNextSibling();
        }
    }

    protected void endDocument() throws SAXException {
        this.getContentHandler().endDocument();
    }

    protected void startDocument() throws SAXException {
        this.getContentHandler().startDocument();
    }

    public void newObjectEvent(Object object, Object object2, XMLMapping xMLMapping) {
        this.docPresPolicy.addObjectToCache(object, this.currentNode, xMLMapping);
    }

    public Object getCurrentObject(AbstractSession abstractSession, XMLMapping xMLMapping) {
        if (abstractSession == null && this.docPresPolicy == null) {
            return null;
        }
        if (this.docPresPolicy == null) {
            XMLLogin xMLLogin = (XMLLogin)abstractSession.getDatasourceLogin();
            this.docPresPolicy = xMLLogin.getDocumentPreservationPolicy();
        }
        return this.docPresPolicy.getObjectForNode(this.currentNode, xMLMapping);
    }

    public DocumentPreservationPolicy getDocPresPolicy() {
        return this.docPresPolicy;
    }

    public void setDocPresPolicy(DocumentPreservationPolicy documentPreservationPolicy) {
        this.docPresPolicy = documentPreservationPolicy;
    }

    protected void setupLocator(Document document) {
        LocatorImpl locatorImpl = new LocatorImpl();
        try {
            Method method = PrivilegedAccessHelper.getMethod(document.getClass(), "getXmlEncoding", new Class[0], true);
            Method method2 = PrivilegedAccessHelper.getMethod(document.getClass(), "getXmlVersion", new Class[0], true);
            String string = (String)PrivilegedAccessHelper.invokeMethod(method, document, new Object[0]);
            String string2 = (String)PrivilegedAccessHelper.invokeMethod(method2, document, new Object[0]);
            locatorImpl.setEncoding(string);
            locatorImpl.setXMLVersion(string2);
        }
        catch (Exception exception) {
            return;
        }
        this.contentHandler.setDocumentLocator(locatorImpl);
    }

    protected class IndexedAttributeList
    implements Attributes {
        private ArrayList<Attr> attrs = new ArrayList();

        public void addAttribute(Attr attr) {
            this.attrs.add(attr);
        }

        public String getQName(int n) {
            try {
                Attr attr = this.attrs.get(n);
                if (attr.getName() != null) {
                    return attr.getName();
                }
                return "";
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }

        public String getType(String string, String string2) {
            return "CDATA";
        }

        public String getType(int n) {
            return "CDATA";
        }

        public String getType(String string) {
            return "CDATA";
        }

        public int getIndex(String string) {
            int n = this.attrs.size();
            for (int i = 0; i < n; ++i) {
                Attr attr = this.attrs.get(i);
                if (!attr.getName().equals(string)) continue;
                return i;
            }
            return -1;
        }

        public int getIndex(String string, String string2) {
            int n = this.attrs.size();
            for (int i = 0; i < n; ++i) {
                Attr attr = this.attrs.get(i);
                try {
                    if (!attr.getNamespaceURI().equals(string) || !attr.getLocalName().equals(string2)) continue;
                    return i;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return -1;
        }

        public int getLength() {
            return this.attrs.size();
        }

        public String getLocalName(int n) {
            try {
                Attr attr = this.attrs.get(n);
                if (attr.getLocalName() != null) {
                    return attr.getLocalName();
                }
                return "";
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }

        public String getURI(int n) {
            return this.attrs.get(n).getNamespaceURI();
        }

        public String getValue(int n) {
            return this.attrs.get(n).getValue();
        }

        public String getValue(String string) {
            int n = this.attrs.size();
            for (int i = 0; i < n; ++i) {
                Attr attr = this.attrs.get(i);
                if (!attr.getName().equals(string)) continue;
                return attr.getValue();
            }
            return null;
        }

        public String getValue(String string, String string2) {
            int n = this.attrs.size();
            for (int i = 0; i < n; ++i) {
                Attr attr = this.attrs.get(i);
                if (attr == null) continue;
                String string3 = attr.getNamespaceURI();
                if (attr.getNamespaceURI() == null) {
                    string3 = "";
                }
                if (!string3.equals(string) || attr.getLocalName() == null || !attr.getLocalName().equals(string2)) continue;
                return attr.getValue();
            }
            return null;
        }
    }

    protected class LocatorImpl
    implements Locator2 {
        private String encoding = "UTF-8";
        private String version = "1.0";

        public String getEncoding() {
            return this.encoding;
        }

        public int getColumnNumber() {
            return 0;
        }

        public String getSystemId() {
            return "";
        }

        public String getPublicId() {
            return "";
        }

        public String getXMLVersion() {
            return this.version;
        }

        public int getLineNumber() {
            return 0;
        }

        protected void setEncoding(String string) {
            this.encoding = string;
        }

        protected void setXMLVersion(String string) {
            this.version = string;
        }
    }
}

