/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public abstract class InterfaceContainerPolicy
extends ContainerPolicy {
    protected Class containerClass;
    protected String containerClassName;
    protected transient Method cloneMethod;

    public InterfaceContainerPolicy() {
    }

    public InterfaceContainerPolicy(Class clazz) {
        this.setContainerClass(clazz);
    }

    public InterfaceContainerPolicy(String string) {
        this.setContainerClassName(string);
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.getContainerClass().equals(((InterfaceContainerPolicy)object).getContainerClass());
    }

    public Object cloneFor(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return this.invokeCloneMethodOn(this.getCloneMethod(), object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.invokeCloneMethodOn(this.getCloneMethod(object.getClass()), object);
        }
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class clazz;
        block6: {
            super.convertClassNamesToClasses(classLoader);
            if (this.getContainerClassName() == null) {
                return;
            }
            clazz = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getContainerClassName(), true, classLoader));
                        break block6;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getContainerClassName(), privilegedActionException.getException());
                    }
                }
                clazz = PrivilegedAccessHelper.getClassForName(this.getContainerClassName(), true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.getContainerClassName(), classNotFoundException);
            }
        }
        this.setContainerClass(clazz);
    }

    public Method getCloneMethod() {
        if (this.cloneMethod == null) {
            this.setCloneMethod(this.getCloneMethod(this.getContainerClass()));
        }
        return this.cloneMethod;
    }

    protected Method getCloneMethod(Class clazz) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedGetMethod(clazz, "clone", null, false));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw QueryException.methodDoesNotExistInContainerClass("clone", clazz);
                }
            }
            return PrivilegedAccessHelper.getMethod(clazz, "clone", null, false);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw QueryException.methodDoesNotExistInContainerClass("clone", clazz);
        }
    }

    public Class getContainerClass() {
        return this.containerClass;
    }

    public String getContainerClassName() {
        if (this.containerClassName == null && this.containerClass != null) {
            this.containerClassName = this.containerClass.getName();
        }
        return this.containerClassName;
    }

    public abstract Class getInterfaceType();

    public boolean hasNext(Object object) {
        return ((Iterator)object).hasNext();
    }

    protected Object invokeCloneMethodOn(Method method, Object object) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedMethodInvoker(method, object, null));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    if (exception instanceof IllegalAccessException) {
                        throw QueryException.cannotAccessMethodOnObject(method, object);
                    }
                    throw QueryException.methodInvocationFailed(method, object, exception);
                }
            }
            return PrivilegedAccessHelper.invokeMethod(method, object, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw QueryException.cannotAccessMethodOnObject(method, object);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw QueryException.methodInvocationFailed(method, object, invocationTargetException);
        }
    }

    public boolean isValidContainerType(Class clazz) {
        return Helper.classImplementsInterface(clazz, this.getInterfaceType());
    }

    protected Object next(Object object) {
        return ((Iterator)object).next();
    }

    public void setCloneMethod(Method method) {
        this.cloneMethod = method;
    }

    public void setContainerClass(Class clazz) {
        this.containerClass = clazz;
        this.initializeConstructor();
    }

    public void setContainerClassName(String string) {
        this.containerClassName = string;
    }

    public Object buildContainerFromVector(Vector vector, AbstractSession abstractSession) {
        if (this.containerClass == ClassConstants.Vector_class) {
            return vector;
        }
        return super.buildContainerFromVector(vector, abstractSession);
    }

    protected Object toStringInfo() {
        return this.getContainerClass();
    }
}

