/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.InterfaceContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetValueFromField;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;

public class MapContainerPolicy
extends InterfaceContainerPolicy {
    protected String keyName;
    protected String elementClassName;
    protected Class elementClass;
    protected transient Field keyField;
    protected transient Method keyMethod;

    public MapContainerPolicy() {
    }

    public MapContainerPolicy(Class clazz) {
        super(clazz);
    }

    public MapContainerPolicy(String string) {
        super(string);
    }

    public void prepare(DatabaseQuery databaseQuery, AbstractSession abstractSession) throws QueryException {
        if (this.getElementClass() == null && databaseQuery.getDescriptor() != null) {
            this.setElementClass(databaseQuery.getDescriptor().getJavaClass());
        }
        super.prepare(databaseQuery, abstractSession);
    }

    public boolean addInto(Object object, Object object2, AbstractSession abstractSession, AbstractRecord abstractRecord, ObjectBuildingQuery objectBuildingQuery) {
        return this.addInto(null, object, object2, abstractSession);
    }

    public boolean addInto(Object object, Object object2, AbstractSession abstractSession) {
        if (object instanceof Map.Entry) {
            return this.addInto(((Map.Entry)object).getKey(), ((Map.Entry)object).getValue(), object2, abstractSession);
        }
        return super.addInto(object, object2, abstractSession);
    }

    public boolean addInto(Object object, Object object2, Object object3, AbstractSession abstractSession) {
        Object object4 = object2;
        if (this.hasElementDescriptor()) {
            object4 = this.getElementDescriptor().getObjectBuilder().wrapObject(object2, abstractSession);
        }
        try {
            if (object != null) {
                return ((Map)object3).put(object, object4) != null;
            }
            if (this.isKeyAvailableFromElement()) {
                Object object5 = this.keyFrom(object2, abstractSession);
                try {
                    Object object6 = ((Map)object3).put(object5, object4);
                    return null != object6;
                }
                catch (NullPointerException nullPointerException) {
                    if (object5 == null) {
                        throw QueryException.mapKeyIsNull(object2, object3);
                    }
                    throw nullPointerException;
                }
            }
            throw QueryException.cannotAddElementWithoutKeyToMap(object2);
        }
        catch (ClassCastException classCastException) {
            throw QueryException.mapKeyNotComparable(object, object3);
        }
    }

    public void addNextValueFromIteratorInto(Object object, Object object2, Object object3, CollectionMapping collectionMapping, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        Map.Entry entry = ((MapContainerPolicyIterator)object).next();
        Object object4 = this.buildCloneForKey(entry.getKey(), object2, unitOfWorkImpl, bl);
        Object object5 = this.buildCloneForValue(entry.getValue(), object2, collectionMapping, unitOfWorkImpl, bl);
        if (collectionMapping.isCandidateForPrivateOwnedRemoval() && unitOfWorkImpl.shouldDiscoverNewObjects()) {
            if (object5 != null && unitOfWorkImpl.isObjectNew(object5)) {
                unitOfWorkImpl.addPrivateOwnedObject(collectionMapping, object5);
            }
            if (object4 != null && unitOfWorkImpl.isObjectNew(object4)) {
                unitOfWorkImpl.addPrivateOwnedObject(collectionMapping, object4);
            }
        }
        this.addInto(object4, object5, object3, unitOfWorkImpl);
    }

    public Object buildCollectionEntry(Object object, ObjectChangeSet objectChangeSet) {
        return new Association(objectChangeSet.getNewKey(), object);
    }

    public void buildChangeSetForNewObjectInCollection(Object object, ClassDescriptor classDescriptor, UnitOfWorkChangeSet unitOfWorkChangeSet, AbstractSession abstractSession) {
        ObjectChangeSet objectChangeSet = classDescriptor.getObjectBuilder().createObjectChangeSet(((Map.Entry)object).getValue(), unitOfWorkChangeSet, abstractSession);
        Object k = ((Map.Entry)object).getKey();
        objectChangeSet.setNewKey(k);
    }

    protected Object buildCloneForValue(Object object, Object object2, CollectionMapping collectionMapping, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        return collectionMapping.buildElementClone(object, object2, unitOfWorkImpl, bl);
    }

    public void clear(Object object) {
        try {
            ((Map)object).clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(object, "clear()");
        }
    }

    public boolean compareKeys(Object object, AbstractSession abstractSession) {
        if (((UnitOfWorkImpl)abstractSession).isClassReadOnly(object.getClass())) {
            return true;
        }
        Object object2 = ((UnitOfWorkImpl)abstractSession).getBackupClone(object, this.getElementDescriptor());
        return this.keyFrom(object2, abstractSession).equals(this.keyFrom(object, abstractSession));
    }

    protected boolean contains(Object object, Object object2) {
        return ((Map)object2).containsValue(object);
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.elementClassName == null) {
            return;
        }
        try {
            Class clazz = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.elementClassName, true, classLoader));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.containerClassName, privilegedActionException.getException());
                }
            } else {
                clazz = PrivilegedAccessHelper.getClassForName(this.elementClassName, true, classLoader);
            }
            this.setElementClass(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.containerClassName, classNotFoundException);
        }
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public String getElementClassName() {
        return this.elementClassName;
    }

    public Class getInterfaceType() {
        return ClassConstants.Map_Class;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public boolean isMapPolicy() {
        return true;
    }

    protected boolean isKeyAvailableFromElement() {
        return true;
    }

    public boolean hasNext(Object object) {
        return ((MapContainerPolicyIterator)object).hasNext();
    }

    public Object iteratorFor(Object object) {
        return new MapContainerPolicyIterator((Map)object);
    }

    public Object keyFrom(Object object, AbstractSession abstractSession) {
        if (this.keyName != null && this.keyMethod == null && this.keyField == null) {
            try {
                this.keyMethod = Helper.getDeclaredMethod(this.elementClass, this.keyName, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    this.keyField = Helper.getField(this.elementClass, this.keyName);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw ValidationException.mapKeyNotDeclaredInItemClass(this.keyName, this.elementClass);
                }
            }
        }
        Object object2 = object;
        if (this.hasElementDescriptor()) {
            object2 = this.getElementDescriptor().getObjectBuilder().unwrapObject(object, abstractSession);
        }
        if (this.keyMethod != null) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.keyMethod, object2, null));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof IllegalAccessException) {
                            throw QueryException.cannotAccessMethodOnObject(this.keyMethod, object2);
                        }
                        throw QueryException.calledMethodThrewException(this.keyMethod, object2, exception);
                    }
                }
                return PrivilegedAccessHelper.invokeMethod(this.keyMethod, object2, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw QueryException.cannotAccessMethodOnObject(this.keyMethod, object2);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw QueryException.calledMethodThrewException(this.keyMethod, object2, invocationTargetException);
            }
        }
        if (this.keyField != null) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedGetValueFromField(this.keyField, object2));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw QueryException.cannotAccessFieldOnObject(this.keyField, object2);
                    }
                }
                return PrivilegedAccessHelper.getValueFromField(this.keyField, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw QueryException.cannotAccessFieldOnObject(this.keyField, object2);
            }
        }
        return this.getElementDescriptor().getCMPPolicy().createPrimaryKeyInstance(object2, abstractSession);
    }

    public Object keyFromEntry(Object object) {
        if (object instanceof Map.Entry) {
            return ((Map.Entry)object).getKey();
        }
        return null;
    }

    public Object keyFromIterator(Object object) {
        return ((MapContainerPolicyIterator)object).getCurrentKey();
    }

    protected Object next(Object object) {
        return ((MapContainerPolicyIterator)object).next().getValue();
    }

    public Object nextEntry(Object object) {
        return ((MapContainerPolicyIterator)object).next();
    }

    public Object nextEntry(Object object, AbstractSession abstractSession) {
        Map.Entry entry = (Map.Entry)this.nextEntry(object);
        Object object2 = entry.getValue();
        if (this.hasElementDescriptor()) {
            object2 = this.getElementDescriptor().getObjectBuilder().unwrapObject(object2, abstractSession);
        }
        Object object3 = entry.getKey();
        object3 = this.unwrapKey(object3, abstractSession);
        entry = new Association(entry.getKey(), object2);
        return entry;
    }

    public Object unwrapElement(Object object) {
        if (object instanceof Association) {
            return ((Association)object).getValue();
        }
        return object;
    }

    public Object unwrapIteratorResult(Object object) {
        if (object instanceof Map.Entry) {
            return ((Map.Entry)object).getValue();
        }
        return object;
    }

    public Object unwrapKey(Object object, AbstractSession abstractSession) {
        return object;
    }

    public void recordUpdateToCollectionInChangeRecord(CollectionChangeEvent collectionChangeEvent, ObjectChangeSet objectChangeSet, CollectionChangeRecord collectionChangeRecord) {
        Object object = null;
        if (collectionChangeEvent.getClass().equals(ClassConstants.MapChangeEvent_Class)) {
            object = ((MapChangeEvent)collectionChangeEvent).getKey();
        }
        if (collectionChangeEvent.getChangeType() == CollectionChangeEvent.ADD) {
            this.recordAddToCollectionInChangeRecord(objectChangeSet, collectionChangeRecord);
            objectChangeSet.setNewKey(object);
        } else if (collectionChangeEvent.getChangeType() == MapChangeEvent.REMOVE) {
            this.recordRemoveFromCollectionInChangeRecord(objectChangeSet, collectionChangeRecord);
            objectChangeSet.setOldKey(object);
        } else {
            throw ValidationException.wrongCollectionChangeEventType(collectionChangeEvent.getChangeType());
        }
    }

    public boolean removeFrom(Object object, Object object2, Object object3, AbstractSession abstractSession) {
        try {
            Object var5_5 = null;
            var5_5 = object != null ? ((Map)object3).remove(object) : ((Map)object3).remove(this.keyFrom(object2, abstractSession));
            return var5_5 != null;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(object3, "remove(Object element)");
        }
    }

    public boolean removeFromWithIdentity(Object object, Object object2, AbstractSession abstractSession) {
        boolean bl = false;
        Vector vector = new Vector(1);
        try {
            for (Object k : ((Map)object2).keySet()) {
                if (((Map)object2).get(k) != object) continue;
                vector.addElement(k);
                bl = true;
            }
            if (bl) {
                for (int i = 0; i < vector.size(); ++i) {
                    ((Map)object2).remove(vector.elementAt(i));
                }
            }
            return bl;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(object2, "remove(Object element)");
        }
    }

    public void setElementClass(Class clazz) {
        if (clazz != null) {
            this.elementClassName = clazz.getName();
        }
        this.elementClass = clazz;
    }

    public boolean isValidContainer(Object object) {
        return object instanceof Map;
    }

    public void setKeyName(String string, String string2) {
        this.keyName = string;
        this.elementClassName = string2;
    }

    public void setKeyName(String string, Class clazz) {
        this.keyName = string;
        this.elementClass = clazz;
    }

    public void setKeyName(String string) {
        this.keyName = string;
    }

    public void setKeyMethod(String string, Class clazz) {
        this.setKeyName(string, clazz);
    }

    public void setKeyMethod(String string, String string2) {
        this.setKeyName(string, string2);
    }

    public void setKeyMethodName(String string) {
        this.setKeyName(string);
    }

    public int sizeFor(Object object) {
        return ((Map)object).size();
    }

    public void validateElementAndRehashIfRequired(Object object, Object object2, AbstractSession abstractSession, Object object3) {
        Object object4;
        if (abstractSession.isUnitOfWork() && !this.keyFrom(object4 = ((UnitOfWorkImpl)abstractSession).getBackupClone(object, this.getElementDescriptor()), abstractSession).equals(this.keyFrom(object, abstractSession))) {
            this.removeFrom(object4, object2, abstractSession);
            this.addInto(object3, object2, abstractSession);
        }
    }

    public Object valueFromIterator(Object object) {
        return ((MapContainerPolicyIterator)object).getCurrentValue();
    }

    public static class MapContainerPolicyIterator
    implements Iterator {
        private Iterator iterator;
        private Map.Entry currentEntry;

        public MapContainerPolicyIterator(Map map) {
            this.iterator = map.entrySet().iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Map.Entry next() {
            this.currentEntry = (Map.Entry)this.iterator.next();
            return this.currentEntry;
        }

        public Object getCurrentKey() {
            if (this.currentEntry != null) {
                return this.currentEntry.getKey();
            }
            return null;
        }

        public Object getCurrentValue() {
            if (this.currentEntry != null) {
                return this.currentEntry.getValue();
            }
            return null;
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

