/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;

public class AggregateCollectionChangeRecord
extends CollectionChangeRecord
implements org.eclipse.persistence.sessions.changesets.AggregateCollectionChangeRecord {
    protected Vector changedValues;

    public AggregateCollectionChangeRecord() {
    }

    public AggregateCollectionChangeRecord(ObjectChangeSet objectChangeSet) {
        this.owner = objectChangeSet;
    }

    public Vector getChangedValues() {
        if (this.changedValues == null) {
            this.changedValues = new Vector(2);
        }
        return this.changedValues;
    }

    public void mergeRecord(ChangeRecord changeRecord, UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet2) {
        this.setChangedValues(((AggregateCollectionChangeRecord)changeRecord).getChangedValues());
        for (int i = 0; i < this.getChangedValues().size(); ++i) {
            ((ObjectChangeSet)this.getChangedValues().get(i)).updateReferences(unitOfWorkChangeSet, unitOfWorkChangeSet2);
        }
    }

    public void prepareForSynchronization(AbstractSession abstractSession) {
        this.getAddObjectList().clear();
        this.getRemoveObjectList().clear();
        Enumeration enumeration = this.getChangedValues().elements();
        while (enumeration.hasMoreElements()) {
            ObjectChangeSet objectChangeSet = (ObjectChangeSet)enumeration.nextElement();
            if (objectChangeSet.getSynchronizationType() != 0) continue;
            ClassDescriptor classDescriptor = abstractSession.getDescriptor(objectChangeSet.getClassType(abstractSession));
            int n = classDescriptor.getCacheSynchronizationType();
            objectChangeSet.setSynchronizationType(n);
            objectChangeSet.prepareChangeRecordsForSynchronization(abstractSession);
        }
    }

    public void setChangedValues(Vector vector) {
        this.changedValues = vector;
    }

    public void updateReferences(UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet2) {
        for (int i = 0; i < this.getChangedValues().size(); ++i) {
            ObjectChangeSet objectChangeSet = (ObjectChangeSet)this.getChangedValues().get(i);
            Object object = unitOfWorkChangeSet.getUOWCloneForObjectChangeSet(objectChangeSet);
            if (object != null) continue;
            unitOfWorkChangeSet.addObjectChangeSetForIdentity(objectChangeSet, unitOfWorkChangeSet2.getUOWCloneForObjectChangeSet(objectChangeSet));
        }
    }
}

