/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.persistence.FlushModeType;
import org.eclipse.persistence.config.PersistenceUnitProperties;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.factories.ReferenceMode;

public class PropertiesHandler {
    public static String getPropertyValue(String string, Map map) {
        return PropertiesHandler.getPropertyValue(string, map, true);
    }

    public static String getPropertyValueLogDebug(String string, Map map, AbstractSession abstractSession) {
        return PropertiesHandler.getPropertyValueLogDebug(string, map, abstractSession, true);
    }

    public static String getPropertyValue(String string, Map map, boolean bl) {
        return Prop.getPropertyValueToApply(string, map, null, bl);
    }

    public static String getPropertyValueLogDebug(String string, Map map, AbstractSession abstractSession, boolean bl) {
        return Prop.getPropertyValueToApply(string, map, abstractSession, bl);
    }

    public static String getPrefixedPropertyValue(String string, String string2, Map map) {
        return (String)PropertiesHandler.getPrefixValues(string, map).get(string2);
    }

    public static Map getPrefixValues(String string, Map map) {
        return Prop.getPrefixValuesToApply(string, map, null, true);
    }

    public static Map getPrefixValuesLogDebug(String string, Map map, AbstractSession abstractSession) {
        return Prop.getPrefixValuesToApply(string, map, abstractSession, true);
    }

    public static String getDefaultPropertyValue(String string) {
        return Prop.getDefaultPropertyValueToApply(string, null);
    }

    public static String getDefaultPropertyValueLogDebug(String string, AbstractSession abstractSession) {
        return Prop.getDefaultPropertyValueToApply(string, abstractSession);
    }

    protected static boolean shouldUseDefault(String string) {
        return string != null && string.length() == 0;
    }

    protected static class BatchWritingProp
    extends Prop {
        BatchWritingProp() {
            super("eclipselink.jdbc.batch-writing", "None");
            this.valueArray = new Object[]{"None", "JDBC", "Buffered", "Oracle-JDBC"};
        }
    }

    protected static class BooleanProp
    extends Prop {
        BooleanProp(String string, String string2) {
            super(string, string2);
            this.valueArray = new Object[]{"true", "false"};
        }
    }

    protected static class CacheSizeProp
    extends Prop {
        CacheSizeProp() {
            super("eclipselink.cache.size.", Integer.toString(1000));
        }
    }

    protected static class CacheTypeProp
    extends Prop {
        CacheTypeProp() {
            super("eclipselink.cache.type.", "SoftWeak");
            String string = "org.eclipse.persistence.internal.identitymaps.";
            this.valueArray = new Object[][]{{"Weak", string + "WeakIdentityMap"}, {"Soft", string + "SoftIdentityMap"}, {"SoftWeak", string + "SoftCacheWeakIdentityMap"}, {"HardWeak", string + "HardCacheWeakIdentityMap"}, {"Full", string + "FullIdentityMap"}, {"NONE", string + "NoIdentityMap"}};
        }
    }

    protected static class DescriptorCustomizerProp
    extends Prop {
        DescriptorCustomizerProp() {
            super("eclipselink.descriptor.customizer.");
        }
    }

    protected static class ExclusiveConnectionModeProp
    extends Prop {
        ExclusiveConnectionModeProp() {
            super("eclipselink.jdbc.exclusive-connection.mode", "Transactional");
            this.valueArray = new Object[]{"Transactional", "Isolated", "Always"};
        }
    }

    protected static class FlushClearCacheProp
    extends Prop {
        FlushClearCacheProp() {
            super("eclipselink.flush-clear.cache", "DropInvalidate");
            this.valueArray = new Object[]{"Merge", "Drop", "DropInvalidate"};
        }
    }

    protected static class FlushModeProp
    extends Prop {
        FlushModeProp() {
            super("eclipselink.persistence-context.flush-mode", FlushModeType.AUTO.toString());
            this.valueArray = new Object[]{FlushModeType.AUTO.toString(), FlushModeType.COMMIT.toString()};
        }
    }

    protected static class LoggerTypeProp
    extends Prop {
        LoggerTypeProp() {
            super("eclipselink.logging.logger", "DefaultLogger");
            this.shouldReturnOriginalValueIfValueToApplyNotFound = true;
            String string = "org.eclipse.persistence.logging.";
            this.valueArray = new Object[][]{{"DefaultLogger", string + "DefaultSessionLog"}, {"JavaLogger", string + "JavaLog"}};
        }
    }

    protected static class LoggingLevelProp
    extends Prop {
        LoggingLevelProp(String string, String string2) {
            super(string, string2);
            this.valueArray = new Object[]{Level.OFF.getName(), Level.SEVERE.getName(), Level.OFF.getName(), Level.WARNING.getName(), Level.INFO.getName(), Level.CONFIG.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName(), Level.ALL.getName()};
        }
    }

    protected static abstract class Prop {
        static HashMap mainMap = new HashMap();
        Object[] valueArray;
        HashMap valueMap;
        String name;
        String defaultValue;
        String defaultValueToApply;
        boolean valueToApplyMayBeNull;
        boolean shouldReturnOriginalValueIfValueToApplyNotFound;

        Prop(String string) {
            this.name = string;
        }

        Prop(String string, String string2) {
            this(string);
            this.defaultValue = string2;
        }

        static String getPropertyValueFromMap(String string, Map map, boolean bl) {
            String string2 = (String)map.get(string);
            return string2 == null && bl ? System.getProperty(string) : string2;
        }

        static Map getPrefixValuesFromMap(String string, Map map, boolean bl) {
            String string2;
            String string3;
            HashMap hashMap = new HashMap();
            if (bl) {
                Iterator iterator = (Iterator)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperties().entrySet().iterator();
                    }
                });
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    string3 = (String)entry.getKey();
                    if (!string3.startsWith(string)) continue;
                    string2 = string3.substring(string.length(), string3.length());
                    hashMap.put(string2, entry.getValue());
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                string3 = (String)entry.getKey();
                if (!string3.startsWith(string)) continue;
                string2 = string3.substring(string.length(), string3.length());
                hashMap.put(string2, entry.getValue());
            }
            return hashMap;
        }

        static String getPropertyValue(String string, boolean bl, Map map, AbstractSession abstractSession, boolean bl2) {
            Prop prop = (Prop)mainMap.get(string);
            if (prop == null) {
                return null;
            }
            String string2 = Prop.getPropertyValueFromMap(string, map, bl2);
            if (string2 == null) {
                return null;
            }
            return prop.getValueToApply(string2, bl, abstractSession);
        }

        static String getPropertyValueToApply(String string, Map map, AbstractSession abstractSession, boolean bl) {
            Prop prop = (Prop)mainMap.get(string);
            if (prop == null) {
                throw new IllegalArgumentException(string);
            }
            String string2 = Prop.getPropertyValueFromMap(string, map, bl);
            if (string2 == null) {
                return null;
            }
            return prop.getValueToApply(string2, PropertiesHandler.shouldUseDefault(string2), abstractSession);
        }

        static Map getPrefixValuesToApply(String string, Map map, AbstractSession abstractSession, boolean bl) {
            Prop prop = (Prop)mainMap.get(string);
            if (prop == null) {
                return new HashMap(0);
            }
            Map map2 = Prop.getPrefixValuesFromMap(string, map, bl);
            if (map2.isEmpty()) {
                return map2;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(map2.size());
            for (Map.Entry entry : map2.entrySet()) {
                String string2 = (String)entry.getKey();
                String string3 = (String)entry.getValue();
                hashMap.put(string2, prop.getValueToApply(string3, PropertiesHandler.shouldUseDefault(string3), string2, abstractSession));
            }
            return hashMap;
        }

        static String getDefaultPropertyValueToApply(String string, AbstractSession abstractSession) {
            Prop prop = (Prop)mainMap.get(string);
            if (prop == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-default-for-unknown-property", new Object[]{string}));
            }
            prop.logDefault(abstractSession);
            return prop.defaultValueToApply;
        }

        String getValueToApply(String string, boolean bl, AbstractSession abstractSession) {
            return this.getValueToApply(string, bl, null, abstractSession);
        }

        String getValueToApply(String string, boolean bl, String string2, AbstractSession abstractSession) {
            String string3;
            if (bl) {
                this.logDefault(abstractSession, string2);
                return this.defaultValueToApply;
            }
            String string4 = string;
            if (this.valueMap != null && (string4 = (String)this.valueMap.get(string3 = Prop.getUpperCaseString(string))) == null) {
                boolean bl2 = true;
                if (this.valueToApplyMayBeNull) {
                    boolean bl3 = bl2 = !this.valueMap.containsKey(string3);
                }
                if (bl2) {
                    if (this.shouldReturnOriginalValueIfValueToApplyNotFound) {
                        string4 = string;
                    } else {
                        String string5 = this.name;
                        if (string2 != null) {
                            string5 = string5 + string2;
                        }
                        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-illegal-property-value", new Object[]{string5, Prop.getPrintValue(string)}));
                    }
                }
            }
            if ((string3 = PersistenceUnitProperties.getOverriddenLogStringForProperty(this.name)) != null) {
                this.log(abstractSession, string3, string3, string2);
            } else {
                this.log(abstractSession, string, string4, string2);
            }
            return string4;
        }

        static String getUpperCaseString(String string) {
            if (string != null) {
                return string.toUpperCase();
            }
            return null;
        }

        static String getPrintValue(String string) {
            if (string != null) {
                return string;
            }
            return "null";
        }

        void initialize() {
            if (this.valueArray != null) {
                this.valueMap = new HashMap(this.valueArray.length);
                if (this.valueArray instanceof Object[][]) {
                    Object[][] objectArray = (Object[][])this.valueArray;
                    for (int i = 0; i < objectArray.length; ++i) {
                        this.valueMap.put(Prop.getUpperCaseString((String)objectArray[i][0]), objectArray[i][1]);
                        if (objectArray[i][1] != null) continue;
                        this.valueToApplyMayBeNull = true;
                    }
                } else {
                    for (int i = 0; i < this.valueArray.length; ++i) {
                        this.valueMap.put(Prop.getUpperCaseString((String)this.valueArray[i]), this.valueArray[i]);
                        if (this.valueArray[i] != null) continue;
                        this.valueToApplyMayBeNull = true;
                    }
                }
                this.defaultValueToApply = (String)this.valueMap.get(Prop.getUpperCaseString(this.defaultValue));
            } else {
                this.defaultValueToApply = this.defaultValue;
            }
        }

        void logDefault(AbstractSession abstractSession) {
            this.logDefault(abstractSession, null);
        }

        void logDefault(AbstractSession abstractSession, String string) {
            if (abstractSession != null && abstractSession.shouldLog(1, "properties")) {
                String string2 = this.name;
                if (string != null) {
                    string2 = string2 + string;
                }
                if (this.defaultValue != this.defaultValueToApply) {
                    abstractSession.log(1, "properties", "handler_property_value_default", new Object[]{string2, this.defaultValue, this.defaultValueToApply});
                } else {
                    abstractSession.log(1, "properties", "property_value_default", new Object[]{string2, this.defaultValue});
                }
            }
        }

        void log(AbstractSession abstractSession, String string, String string2, String string3) {
            if (abstractSession != null && abstractSession.shouldLog(1, "properties")) {
                String string4 = this.name;
                if (string3 != null) {
                    string4 = string4 + string3;
                }
                if (string != string2) {
                    abstractSession.log(1, "properties", "handler_property_value_specified", new Object[]{string4, string, string2});
                } else {
                    abstractSession.log(1, "properties", "property_value_specified", new Object[]{string4, string});
                }
            }
        }

        static void addProp(Prop prop) {
            prop.initialize();
            mainMap.put(prop.name, prop);
        }

        static {
            Prop.addProp(new LoggerTypeProp());
            Prop.addProp(new LoggingLevelProp("eclipselink.logging.level", Level.INFO.getName()));
            Prop.addProp(new LoggingLevelProp("eclipselink.logging.level.", Level.INFO.getName()));
            Prop.addProp(new TargetDatabaseProp());
            Prop.addProp(new TargetServerProp());
            Prop.addProp(new CacheSizeProp());
            Prop.addProp(new CacheTypeProp());
            Prop.addProp(new BooleanProp("eclipselink.cache.shared.", "false"));
            Prop.addProp(new DescriptorCustomizerProp());
            Prop.addProp(new BatchWritingProp());
            Prop.addProp(new FlushClearCacheProp());
            Prop.addProp(new ReferenceModeProp());
            Prop.addProp(new FlushModeProp());
            Prop.addProp(new BooleanProp("eclipselink.persistence-context.close-on-commit", "false"));
            Prop.addProp(new BooleanProp("eclipselink.persistence-context.persist-on-commit", "true"));
            Prop.addProp(new BooleanProp("eclipselink.validate-existence", "false"));
            Prop.addProp(new BooleanProp("eclipselink.transaction.join-existing", "false"));
            Prop.addProp(new ExclusiveConnectionModeProp());
            Prop.addProp(new BooleanProp("eclipselink.jdbc.exclusive-connection.is-lazy", "true"));
        }
    }

    protected static class ReferenceModeProp
    extends Prop {
        ReferenceModeProp() {
            super("eclipselink.persistence-context.reference-mode", ReferenceMode.HARD.toString());
            this.valueArray = new Object[]{ReferenceMode.HARD.toString(), ReferenceMode.WEAK.toString(), ReferenceMode.FORCE_WEAK.toString()};
        }
    }

    protected static class TargetDatabaseProp
    extends Prop {
        TargetDatabaseProp() {
            super("eclipselink.target-database", "Auto");
            this.shouldReturnOriginalValueIfValueToApplyNotFound = true;
            String string = "org.eclipse.persistence.platform.database.";
            this.valueArray = new Object[][]{{"Auto", string + "DatabasePlatform"}, {"Oracle", string + "OraclePlatform"}, {"Oracle8i", string + "oracle.Oracle8Platform"}, {"Oracle9i", string + "oracle.Oracle9Platform"}, {"Oracle10g", string + "oracle.Oracle10Platform"}, {"Oracle11", string + "oracle.Oracle11Platform"}, {"Attunity", string + "AttunityPlatform"}, {"Cloudscape", string + "CloudscapePlatform"}, {"Database", string + "DatabasePlatform"}, {"DB2Mainframe", string + "DB2MainframePlatform"}, {"DB2", string + "DB2Platform"}, {"DBase", string + "DBasePlatform"}, {"Derby", string + "DerbyPlatform"}, {"HSQL", string + "HSQLPlatform"}, {"Informix", string + "InformixPlatform"}, {"JavaDB", string + "JavaDBPlatform"}, {"MySQL", string + "MySQLPlatform"}, {"MySQL4", string + "MySQLPlatform"}, {"PointBase", string + "PointBasePlatform"}, {"PostgreSQL", string + "PostgreSQLPlatform"}, {"SQLAnywhere", string + "SQLAnywherePlatform"}, {"SQLServer", string + "SQLServerPlatform"}, {"Sybase", string + "SybasePlatform"}, {"TimesTen", string + "TimesTenPlatform"}};
        }
    }

    protected static class TargetServerProp
    extends Prop {
        TargetServerProp() {
            super("eclipselink.target-server", "None");
            this.shouldReturnOriginalValueIfValueToApplyNotFound = true;
            String string = "org.eclipse.persistence.platform.server.";
            this.valueArray = new Object[][]{{"None", string + "NoServerPlatform"}, {"OC4J", string + "oc4j.Oc4jPlatform"}, {"SunAS9", string + "sunas.SunAS9ServerPlatform"}, {"WebSphere", string + "was.WebSpherePlatform"}, {"WebSphere_6_1", string + "was.WebSphere_6_1_Platform"}, {"WebLogic", string + "wls.WebLogicPlatform"}, {"WebLogic_9", string + "wls.WebLogic_9_Platform"}, {"WebLogic_10", string + "wls.WebLogic_10_Platform"}, {"JBoss", string + "jboss.JBossPlatform"}};
        }
    }
}

