/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.IdentityMapAccessor;
import org.eclipse.persistence.internal.sessions.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.Record;

public class UnitOfWorkIdentityMapAccessor
extends IdentityMapAccessor {
    public UnitOfWorkIdentityMapAccessor(AbstractSession abstractSession, IdentityMapManager identityMapManager) {
        super(abstractSession, identityMapManager);
    }

    public void clearQueryCache() {
        ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessor().clearQueryCache();
    }

    public void clearQueryCache(ReadQuery readQuery) {
        ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessor().clearQueryCache(readQuery);
    }

    public void clearQueryCache(String string) {
        ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessor().clearQueryCache((ReadQuery)this.session.getQuery(string));
    }

    public void clearQueryCache(String string, Class clazz) {
        ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessor().clearQueryCache((ReadQuery)this.session.getDescriptor(clazz).getQueryManager().getQuery(string));
    }

    public boolean containsObjectInIdentityMap(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        if (this.getIdentityMapManager().containsKey(vector, clazz, classDescriptor)) {
            return true;
        }
        return ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessorInstance().containsObjectInIdentityMap(vector, clazz, classDescriptor);
    }

    public Vector getAllFromIdentityMap(Expression expression, Class clazz, AbstractRecord abstractRecord, int n, boolean bl) throws QueryException {
        return super.getAllFromIdentityMap(expression, clazz, (Record)abstractRecord, n, true);
    }

    public Object getFromIdentityMapWithDeferredLock(Vector vector, Class clazz, boolean bl, ClassDescriptor classDescriptor) {
        return super.getFromIdentityMapWithDeferredLock(vector, clazz, true, classDescriptor);
    }

    public Object getFromIdentityMap(Vector vector, Class clazz, boolean bl, ClassDescriptor classDescriptor) {
        Object object = super.getFromIdentityMap(vector, clazz, true, classDescriptor);
        if (object != null) {
            return object;
        }
        return this.getAndCloneCacheKeyFromParent(vector, clazz, bl, classDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getAndCloneCacheKeyFromParent(Vector vector, Class clazz, boolean bl, ClassDescriptor classDescriptor) {
        Object object;
        UnitOfWorkImpl unitOfWorkImpl = (UnitOfWorkImpl)this.getSession();
        IdentityMapAccessor identityMapAccessor = unitOfWorkImpl.getParent().getIdentityMapAccessorInstance();
        CacheKey cacheKey = identityMapAccessor.getCacheKeyForObject(vector, clazz, classDescriptor);
        if (cacheKey == null && unitOfWorkImpl.getParent().isUnitOfWork()) {
            ((UnitOfWorkIdentityMapAccessor)identityMapAccessor).getAndCloneCacheKeyFromParent(vector, clazz, bl, classDescriptor);
            cacheKey = identityMapAccessor.getCacheKeyForObject(vector, clazz, classDescriptor);
        }
        Object object2 = null;
        if (cacheKey != null && (bl || !classDescriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey))) {
            object = cacheKey.getMutex();
            synchronized (object) {
                object2 = cacheKey.getObject();
                try {
                    while (cacheKey.isAcquired() && object2 == null) {
                        cacheKey.getMutex().wait(5L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (object2 == null) {
                    return null;
                }
            }
        }
        return null;
        if (this.getSession().isClassReadOnly(clazz, classDescriptor)) {
            return object2;
        }
        if (this.getSession() instanceof RepeatableWriteUnitOfWork && (object = ((RepeatableWriteUnitOfWork)this.getSession()).getUnregisteredDeletedCloneForOriginal(object2)) != null) {
            return object;
        }
        return unitOfWorkImpl.cloneAndRegisterObject(object2, cacheKey, classDescriptor);
    }

    public Object getQueryResult(ReadQuery readQuery, Vector vector, boolean bl) {
        return ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessorInstance().getQueryResult(readQuery, vector, bl);
    }

    public void putQueryResult(ReadQuery readQuery, Vector vector, Object object) {
        ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessorInstance().putQueryResult(readQuery, vector, object);
    }

    public void initializeAllIdentityMaps() {
        super.initializeAllIdentityMaps();
        ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

