/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.XMLFormatter;
import org.eclipse.persistence.logging.EclipseLinkLogRecord;

public class XMLLogFormatter
extends XMLFormatter {
    private void a2(StringBuffer stringBuffer, int n) {
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
    }

    private void appendISO8601(StringBuffer stringBuffer, long l) {
        Date date = new Date(l);
        stringBuffer.append(date.getYear() + 1900);
        stringBuffer.append('-');
        this.a2(stringBuffer, date.getMonth() + 1);
        stringBuffer.append('-');
        this.a2(stringBuffer, date.getDate());
        stringBuffer.append('T');
        this.a2(stringBuffer, date.getHours());
        stringBuffer.append(':');
        this.a2(stringBuffer, date.getMinutes());
        stringBuffer.append(':');
        this.a2(stringBuffer, date.getSeconds());
    }

    private void escape(StringBuffer stringBuffer, String string) {
        if (string == null) {
            string = "<null>";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            stringBuffer.append(c);
        }
    }

    public String format(LogRecord logRecord) {
        Object[] objectArray;
        StringBuffer stringBuffer;
        EclipseLinkLogRecord eclipseLinkLogRecord;
        block18: {
            Object object;
            if (!(logRecord instanceof EclipseLinkLogRecord)) {
                return super.format(logRecord);
            }
            eclipseLinkLogRecord = (EclipseLinkLogRecord)logRecord;
            stringBuffer = new StringBuffer(500);
            stringBuffer.append("<record>\n");
            if (eclipseLinkLogRecord.shouldPrintDate()) {
                stringBuffer.append("  <date>");
                this.appendISO8601(stringBuffer, eclipseLinkLogRecord.getMillis());
                stringBuffer.append("</date>\n");
                stringBuffer.append("  <millis>");
                stringBuffer.append(eclipseLinkLogRecord.getMillis());
                stringBuffer.append("</millis>\n");
            }
            stringBuffer.append("  <sequence>");
            stringBuffer.append(eclipseLinkLogRecord.getSequenceNumber());
            stringBuffer.append("</sequence>\n");
            String string = eclipseLinkLogRecord.getLoggerName();
            if (string != null) {
                stringBuffer.append("  <logger>");
                this.escape(stringBuffer, string);
                stringBuffer.append("</logger>\n");
            }
            stringBuffer.append("  <level>");
            this.escape(stringBuffer, eclipseLinkLogRecord.getLevel().toString());
            stringBuffer.append("</level>\n");
            if (eclipseLinkLogRecord.getSourceClassName() != null) {
                stringBuffer.append("  <class>");
                this.escape(stringBuffer, eclipseLinkLogRecord.getSourceClassName());
                stringBuffer.append("</class>\n");
            }
            if (eclipseLinkLogRecord.getSourceMethodName() != null) {
                stringBuffer.append("  <method>");
                this.escape(stringBuffer, eclipseLinkLogRecord.getSourceMethodName());
                stringBuffer.append("</method>\n");
            }
            if (eclipseLinkLogRecord.getSessionString() != null) {
                stringBuffer.append("  <session>");
                stringBuffer.append(eclipseLinkLogRecord.getSessionString());
                stringBuffer.append("</session>\n");
            }
            if (eclipseLinkLogRecord.getConnection() != null) {
                stringBuffer.append("  <connection>");
                stringBuffer.append(String.valueOf(System.identityHashCode(eclipseLinkLogRecord.getConnection())));
                stringBuffer.append("</connection>\n");
            }
            if (eclipseLinkLogRecord.shouldPrintThread()) {
                stringBuffer.append("  <thread>");
                stringBuffer.append(eclipseLinkLogRecord.getThreadID());
                stringBuffer.append("</thread>\n");
            }
            if (eclipseLinkLogRecord.getMessage() != null) {
                object = this.formatMessage(eclipseLinkLogRecord);
                stringBuffer.append("  <message>");
                this.escape(stringBuffer, (String)object);
                stringBuffer.append("</message>");
                stringBuffer.append("\n");
            }
            object = eclipseLinkLogRecord.getResourceBundle();
            try {
                if (object == null || ((ResourceBundle)object).getString(eclipseLinkLogRecord.getMessage()) == null) break block18;
                stringBuffer.append("  <key>");
                this.escape(stringBuffer, eclipseLinkLogRecord.getMessage());
                stringBuffer.append("</key>\n");
                stringBuffer.append("  <catalog>");
                this.escape(stringBuffer, eclipseLinkLogRecord.getResourceBundleName());
                stringBuffer.append("</catalog>\n");
                objectArray = eclipseLinkLogRecord.getParameters();
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuffer.append("  <param>");
                    try {
                        this.escape(stringBuffer, objectArray[i].toString());
                    }
                    catch (Exception exception) {
                        stringBuffer.append("???");
                    }
                    stringBuffer.append("</param>\n");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (eclipseLinkLogRecord.getThrown() != null) {
            objectArray = eclipseLinkLogRecord.getThrown();
            stringBuffer.append("  <exception>\n");
            stringBuffer.append("    <message>");
            this.escape(stringBuffer, objectArray.toString());
            stringBuffer.append("</message>\n");
            if (eclipseLinkLogRecord.getLevel().intValue() == Level.SEVERE.intValue() || eclipseLinkLogRecord.getLevel().intValue() <= Level.WARNING.intValue() && eclipseLinkLogRecord.shouldLogExceptionStackTrace()) {
                StackTraceElement[] stackTraceElementArray = objectArray.getStackTrace();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[i];
                    stringBuffer.append("    <frame>\n");
                    stringBuffer.append("      <class>");
                    this.escape(stringBuffer, stackTraceElement.getClassName());
                    stringBuffer.append("</class>\n");
                    stringBuffer.append("      <method>");
                    this.escape(stringBuffer, stackTraceElement.getMethodName());
                    stringBuffer.append("</method>\n");
                    if (stackTraceElement.getLineNumber() >= 0) {
                        stringBuffer.append("      <line>");
                        stringBuffer.append(stackTraceElement.getLineNumber());
                        stringBuffer.append("</line>\n");
                    }
                    stringBuffer.append("    </frame>\n");
                }
            }
            stringBuffer.append("  </exception>\n");
        }
        stringBuffer.append("</record>\n");
        return stringBuffer.toString();
    }
}

