/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.structures;

import java.sql.Array;
import java.sql.Connection;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class ObjectRelationalDataTypeDescriptor
extends RelationalDescriptor {
    protected String structureName;
    protected Vector orderedFields = NonSynchronizedVector.newInstance();

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        if (this.orderedFields == null || this.orderedFields.size() == 0) {
            this.orderedFields = this.getAllFields();
        }
    }

    public void addFieldOrdering(String string) {
        this.getOrderedFields().addElement(new DatabaseField(string));
    }

    public Vector buildDirectValuesFromFieldValue(Object object) throws DatabaseException {
        if (object == null) {
            return null;
        }
        return Helper.vectorFromArray((Object[])object);
    }

    public Object buildFieldValueFromDirectValues(Vector vector, String string, AbstractSession abstractSession) throws DatabaseException {
        Object[] objectArray = Helper.arrayFromVector(vector);
        try {
            ((DatabaseAccessor)abstractSession.getAccessor()).incrementCallCount(abstractSession);
            Connection connection = ((DatabaseAccessor)abstractSession.getAccessor()).getConnection();
            Array array = abstractSession.getPlatform().createArray(string, objectArray, abstractSession, connection);
            return array;
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, abstractSession, false);
        }
        finally {
            ((DatabaseAccessor)abstractSession.getAccessor()).decrementCallCount();
        }
    }

    public Object buildFieldValueFromNestedRow(AbstractRecord abstractRecord, AbstractSession abstractSession) throws DatabaseException {
        Connection connection = ((DatabaseAccessor)abstractSession.getAccessor()).getConnection();
        return this.buildStructureFromRow(abstractRecord, abstractSession, connection);
    }

    public Object buildFieldValueFromNestedRows(Vector vector, String string, AbstractSession abstractSession) throws DatabaseException {
        Object[] objectArray = new Object[vector.size()];
        Connection connection = ((DatabaseAccessor)abstractSession.getAccessor()).getConnection();
        boolean bl = false;
        try {
            if (connection == null) {
                ((DatabaseAccessor)abstractSession.getAccessor()).incrementCallCount(abstractSession);
                bl = true;
                connection = ((DatabaseAccessor)abstractSession.getAccessor()).getConnection();
            }
            int n = 0;
            Object object = vector.elements();
            while (object.hasMoreElements()) {
                AbstractRecord abstractRecord = (AbstractRecord)object.nextElement();
                objectArray[n++] = this.buildStructureFromRow(abstractRecord, abstractSession, connection);
            }
            object = abstractSession.getPlatform().createArray(string, objectArray, abstractSession, connection);
            return object;
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, abstractSession, false);
        }
        finally {
            if (bl) {
                ((DatabaseAccessor)abstractSession.getAccessor()).decrementCallCount();
            }
        }
    }

    public static Object buildContainerFromArray(Array array, ObjectRelationalDatabaseField objectRelationalDatabaseField, AbstractSession abstractSession) throws DatabaseException {
        Cloneable cloneable;
        if (objectRelationalDatabaseField.getType() == null) {
            return array;
        }
        Object[] objectArray = null;
        try {
            objectArray = (Object[])array.getArray();
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, abstractSession, false);
        }
        if (objectArray == null) {
            return null;
        }
        boolean bl = false;
        ObjectRelationalDataTypeDescriptor objectRelationalDataTypeDescriptor = null;
        DatabaseField databaseField = null;
        if (objectRelationalDatabaseField != null) {
            databaseField = objectRelationalDatabaseField.getNestedTypeField();
            if (databaseField != null && databaseField.getSqlType() == 2002) {
                cloneable = abstractSession.getDescriptor(databaseField.getType());
                if (cloneable != null && ((ClassDescriptor)cloneable).isObjectRelationalDataTypeDescriptor()) {
                    objectRelationalDataTypeDescriptor = (ObjectRelationalDataTypeDescriptor)cloneable;
                }
            } else if (databaseField != null && databaseField instanceof ObjectRelationalDatabaseField) {
                bl = true;
            }
        }
        cloneable = new ReadObjectQuery();
        ((DatabaseQuery)cloneable).setSession(abstractSession);
        ContainerPolicy containerPolicy = ContainerPolicy.buildPolicyFor(objectRelationalDatabaseField.getType());
        Object object = containerPolicy.containerInstance(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            if (object2 == null) {
                return null;
            }
            if (objectRelationalDataTypeDescriptor != null) {
                AbstractRecord abstractRecord = objectRelationalDataTypeDescriptor.buildRowFromStructure((Struct)object2);
                ClassDescriptor classDescriptor = objectRelationalDataTypeDescriptor;
                if (classDescriptor.hasInheritance()) {
                    Class clazz = classDescriptor.getInheritancePolicy().classFromRow(abstractRecord, abstractSession);
                    if (!classDescriptor.getJavaClass().equals(clazz) && (classDescriptor = abstractSession.getDescriptor(clazz)) == null) {
                        classDescriptor = objectRelationalDataTypeDescriptor;
                    }
                }
                object2 = classDescriptor.getObjectBuilder().buildNewInstance();
                classDescriptor.getObjectBuilder().buildAttributesIntoObject(object2, abstractRecord, (ObjectBuildingQuery)cloneable, null, false);
            } else if (bl && object2 instanceof Array) {
                object2 = ObjectRelationalDataTypeDescriptor.buildContainerFromArray((Array)object2, (ObjectRelationalDatabaseField)databaseField, abstractSession);
            }
            containerPolicy.addInto(object2, object, abstractSession);
        }
        return object;
    }

    public AbstractRecord buildNestedRowFromFieldValue(Object object) throws DatabaseException {
        DatabaseRecord databaseRecord = new DatabaseRecord();
        Object[] objectArray = (Object[])object;
        for (int i = 0; i < this.getOrderedFields().size(); ++i) {
            DatabaseField databaseField = (DatabaseField)this.getOrderedFields().elementAt(i);
            databaseRecord.put(databaseField, objectArray[i]);
        }
        return databaseRecord;
    }

    public Vector buildNestedRowsFromFieldValue(Object object, AbstractSession abstractSession) throws DatabaseException {
        if (object == null) {
            return null;
        }
        Object[] objectArray = (Object[])object;
        Vector<AbstractRecord> vector = new Vector<AbstractRecord>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = (Object[])objectArray[i];
            if (objectArray2 == null) {
                return null;
            }
            vector.addElement(this.buildNestedRowFromFieldValue(objectArray2));
        }
        return vector;
    }

    public AbstractRecord buildRowFromStructure(Struct struct) throws DatabaseException {
        Object[] objectArray;
        try {
            objectArray = struct.getAttributes();
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof Array) {
                    objectArray[i] = ObjectRelationalDataTypeDescriptor.buildArrayObjectFromArray(objectArray[i]);
                    continue;
                }
                if (!(objectArray[i] instanceof Struct)) continue;
                objectArray[i] = ObjectRelationalDataTypeDescriptor.buildArrayObjectFromStruct(objectArray[i]);
            }
        }
        return this.buildNestedRowFromFieldValue(objectArray);
    }

    public Struct buildStructureFromRow(AbstractRecord abstractRecord, AbstractSession abstractSession, Connection connection) throws DatabaseException {
        Struct struct;
        boolean bl = false;
        try {
            if (connection == null) {
                ((DatabaseAccessor)abstractSession.getAccessor()).incrementCallCount(abstractSession);
                bl = true;
                connection = ((DatabaseAccessor)abstractSession.getAccessor()).getConnection();
            }
            Object[] objectArray = new Object[this.getOrderedFields().size()];
            for (int i = 0; i < this.getOrderedFields().size(); ++i) {
                DatabaseField databaseField = (DatabaseField)this.getOrderedFields().elementAt(i);
                objectArray[i] = abstractRecord.get(databaseField);
            }
            struct = abstractSession.getPlatform().createStruct(this.getStructureName(), objectArray, abstractSession, connection);
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, abstractSession, false);
        }
        finally {
            if (bl) {
                ((DatabaseAccessor)abstractSession.getAccessor()).decrementCallCount();
            }
        }
        return struct;
    }

    public static Object buildArrayObjectFromArray(Object object) throws DatabaseException {
        Object[] objectArray = null;
        if (object == null) {
            return object;
        }
        try {
            objectArray = (Object[])((Array)object).getArray();
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
        if (objectArray == null) {
            return null;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Array) {
                objectArray[i] = ObjectRelationalDataTypeDescriptor.buildArrayObjectFromArray(objectArray[i]);
            }
            if (!(objectArray[i] instanceof Struct)) continue;
            objectArray[i] = ObjectRelationalDataTypeDescriptor.buildArrayObjectFromStruct(objectArray[i]);
        }
        return objectArray;
    }

    public static Object buildArrayObjectFromStruct(Object object) throws DatabaseException {
        Object[] objectArray = null;
        if (object == null) {
            return object;
        }
        try {
            objectArray = ((Struct)object).getAttributes();
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
        if (objectArray == null) {
            return null;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Array) {
                objectArray[i] = ObjectRelationalDataTypeDescriptor.buildArrayObjectFromArray(objectArray[i]);
            }
            if (!(objectArray[i] instanceof Struct)) continue;
            objectArray[i] = ObjectRelationalDataTypeDescriptor.buildArrayObjectFromStruct(objectArray[i]);
        }
        return objectArray;
    }

    protected DatabaseTable extractDefaultTable() {
        if (this.isAggregateDescriptor()) {
            return new DatabaseTable();
        }
        return super.extractDefaultTable();
    }

    public Vector getOrderedFields() {
        return this.orderedFields;
    }

    public Ref getRef(Object object, AbstractSession abstractSession) {
        SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
        sQLSelectStatement.addTable(this.getTables().firstElement());
        sQLSelectStatement.getFields().addElement(new ExpressionBuilder().ref());
        sQLSelectStatement.setWhereClause(this.getObjectBuilder().buildPrimaryKeyExpressionFromObject(object, abstractSession));
        sQLSelectStatement.setRequiresAliases(true);
        sQLSelectStatement.normalize(abstractSession, this);
        ValueReadQuery valueReadQuery = new ValueReadQuery();
        valueReadQuery.setSQLStatement(sQLSelectStatement);
        valueReadQuery.prepareCall(abstractSession, new DatabaseRecord());
        valueReadQuery.getCall().setIsNativeConnectionRequired(true);
        Ref ref = (Ref)abstractSession.executeQuery(valueReadQuery);
        return ref;
    }

    public String getStructureName() {
        return this.structureName;
    }

    public boolean isObjectRelationalDataTypeDescriptor() {
        return true;
    }

    public boolean requiresInitialization() {
        return true;
    }

    protected void validateMappingType(DatabaseMapping databaseMapping) {
    }

    public void setOrderedFields(Vector vector) {
        this.orderedFields = vector;
    }

    public void setStructureName(String string) {
        this.structureName = string;
    }
}

