/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.was;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.platform.server.ServerPlatformBase;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.transaction.was.WebSphereTransactionController;

public class WebSpherePlatform
extends ServerPlatformBase {
    protected Class websphereConnectionClass;
    protected Class websphereUtilClass;
    protected Method vendorConnectionMethod;

    public WebSpherePlatform(DatabaseSession databaseSession) {
        super(databaseSession);
        this.disableRuntimeServices();
    }

    public Class getExternalTransactionControllerClass() {
        if (this.externalTransactionControllerClass == null) {
            this.externalTransactionControllerClass = WebSphereTransactionController.class;
        }
        return this.externalTransactionControllerClass;
    }

    protected Class getWebsphereUtilClass() {
        if (this.websphereUtilClass == null) {
            try {
                this.websphereUtilClass = (Class)this.getDatabaseSession().getPlatform().convertObject("com.ibm.ws.rsadapter.jdbc.WSJdbcUtil", Class.class);
            }
            catch (Throwable throwable) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, throwable);
                this.websphereUtilClass = Void.TYPE;
            }
        }
        return this.websphereUtilClass;
    }

    protected Class getWebsphereConnectionClass() {
        if (this.websphereConnectionClass == null) {
            try {
                this.websphereConnectionClass = (Class)this.getDatabaseSession().getPlatform().convertObject("com.ibm.ws.rsadapter.jdbc.WSJdbcConnection", Class.class);
            }
            catch (Throwable throwable) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, throwable);
                this.websphereConnectionClass = Void.TYPE;
            }
        }
        return this.websphereConnectionClass;
    }

    protected Method getVendorConnectionMethod() {
        if (this.vendorConnectionMethod == null && !this.getWebsphereUtilClass().equals(Void.TYPE)) {
            try {
                Class[] classArray = new Class[]{this.getWebsphereConnectionClass()};
                this.vendorConnectionMethod = PrivilegedAccessHelper.getDeclaredMethod(this.getWebsphereUtilClass(), "getNativeConnection", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, noSuchMethodException);
            }
        }
        return this.vendorConnectionMethod;
    }

    public Connection unwrapConnection(Connection connection) {
        if (this.getWebsphereConnectionClass().isInstance(connection) && this.getVendorConnectionMethod() != null) {
            try {
                return (Connection)PrivilegedAccessHelper.invokeMethod(this.getVendorConnectionMethod(), null, new Object[]{connection});
            }
            catch (IllegalAccessException illegalAccessException) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, invocationTargetException);
            }
        }
        return super.unwrapConnection(connection);
    }
}

