/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.Enumeration;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;

public abstract class CursorPolicy
extends ContainerPolicy {
    protected int pageSize;
    protected ReadQuery query;

    public CursorPolicy() {
        this.setPageSize(10);
    }

    public CursorPolicy(ReadQuery readQuery, int n) {
        this.setQuery(readQuery);
        this.setPageSize(n);
    }

    public ContainerPolicy clone(ReadQuery readQuery) {
        CursorPolicy cursorPolicy = (CursorPolicy)super.clone(readQuery);
        cursorPolicy.setQuery(readQuery);
        return cursorPolicy;
    }

    public abstract Object execute();

    public int getPageSize() {
        return this.pageSize;
    }

    public ReadQuery getQuery() {
        return this.query;
    }

    public boolean hasNext(Object object) {
        return ((Enumeration)object).hasMoreElements();
    }

    public boolean isCursorPolicy() {
        return true;
    }

    public Object iteratorFor(Object object) {
        return object;
    }

    protected Object next(Object object) {
        return ((Enumeration)object).nextElement();
    }

    public boolean overridesRead() {
        return true;
    }

    public void prepare(DatabaseQuery databaseQuery, AbstractSession abstractSession) throws QueryException {
        super.prepare(databaseQuery, abstractSession);
        this.setQuery((ReadQuery)databaseQuery);
        ClassDescriptor classDescriptor = databaseQuery.getDescriptor();
        if (classDescriptor != null) {
            if (classDescriptor.isDescriptorForInterface()) {
                throw QueryException.noCursorSupport(databaseQuery);
            }
            if (databaseQuery.isObjectLevelReadQuery() && classDescriptor.hasInheritance()) {
                ((ObjectLevelReadQuery)databaseQuery).setShouldOuterJoinSubclasses(true);
            }
        }
        databaseQuery.getQueryMechanism().prepareCursorSelectAllRows();
    }

    public abstract Object remoteExecute();

    public void setPageSize(int n) {
        this.pageSize = n;
    }

    public void setQuery(ReadQuery readQuery) {
        this.query = readQuery;
    }

    public int sizeFor(Object object) {
        return ((Cursor)object).size();
    }

    protected Object toStringInfo() {
        return "page size = " + this.getPageSize();
    }
}

