/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.CursorPolicy;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public class CursoredStreamPolicy
extends CursorPolicy {
    protected int initialReadSize;
    protected ValueReadQuery sizeQuery;

    public CursoredStreamPolicy() {
    }

    public CursoredStreamPolicy(ReadQuery readQuery, int n) {
        super(readQuery, n);
        this.setInitialReadSize(n);
    }

    public CursoredStreamPolicy(ReadQuery readQuery, int n, int n2) {
        this(readQuery, n2);
        this.setInitialReadSize(n);
    }

    public CursoredStreamPolicy(ReadQuery readQuery, int n, int n2, ValueReadQuery valueReadQuery) {
        this(readQuery, n, n2);
        this.setSizeQuery(valueReadQuery);
    }

    public Object execute() {
        DatabaseCall databaseCall = this.getQuery().getQueryMechanism().cursorSelectAllRows();
        CursoredStream cursoredStream = new CursoredStream(databaseCall, this);
        return cursoredStream;
    }

    public int getInitialReadSize() {
        return this.initialReadSize;
    }

    public ValueReadQuery getSizeQuery() {
        return this.sizeQuery;
    }

    public boolean hasSizeQuery() {
        return this.sizeQuery != null;
    }

    public boolean isCursoredStreamPolicy() {
        return true;
    }

    public void prepare(DatabaseQuery databaseQuery, AbstractSession abstractSession) throws QueryException {
        super.prepare(databaseQuery, abstractSession);
    }

    public Object remoteExecute() {
        return ((DistributedSession)this.getQuery().getSession()).cursorSelectObjects(this);
    }

    public void setInitialReadSize(int n) {
        this.initialReadSize = n;
    }

    public void setSizeQuery(ValueReadQuery valueReadQuery) {
        this.sizeQuery = valueReadQuery;
    }
}

