/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.queries.ExpressionQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.sessions.IdentityMapAccessor;
import org.eclipse.persistence.sessions.Record;

public abstract class ModifyAllQuery
extends ModifyQuery {
    public static final int NO_CACHE = 0;
    public static final int INVALIDATE_CACHE = 1;
    private int m_cacheUsage = 1;
    protected Class referenceClass;
    protected String referenceClassName;
    protected transient Integer result;
    private boolean shouldDeferExecutionInUOW = true;
    protected ExpressionBuilder defaultBuilder;
    protected boolean isPreparedUsingTempStorage;

    public ModifyAllQuery() {
    }

    public ModifyAllQuery(Class clazz) {
        this();
        this.setReferenceClass(clazz);
    }

    public ModifyAllQuery(Class clazz, Expression expression) {
        this();
        this.setReferenceClass(clazz);
        this.setSelectionCriteria(expression);
    }

    public boolean isModifyQuery() {
        return true;
    }

    public void setIsPreparedUsingTempStorage(boolean bl) {
        this.isPreparedUsingTempStorage = bl;
    }

    public boolean isPreparedUsingTempStorage() {
        return this.isPreparedUsingTempStorage;
    }

    protected void clonedQueryExecutionComplete(DatabaseQuery databaseQuery, AbstractSession abstractSession) {
        super.clonedQueryExecutionComplete(databaseQuery, abstractSession);
        if (abstractSession.isUnitOfWork()) {
            ((UnitOfWorkImpl)abstractSession).storeModifyAllQuery(databaseQuery);
        }
    }

    public Object executeInUnitOfWork(UnitOfWorkImpl unitOfWorkImpl, AbstractRecord abstractRecord) throws DatabaseException, OptimisticLockException {
        if (unitOfWorkImpl.isNestedUnitOfWork()) {
            throw ValidationException.nestedUOWNotSupportedForModifyAllQuery();
        }
        if (this.shouldDeferExecutionInUOW()) {
            unitOfWorkImpl.storeDeferredModifyAllQuery(this, abstractRecord);
            this.result = null;
        } else {
            if (!unitOfWorkImpl.isInTransaction()) {
                unitOfWorkImpl.beginEarlyTransaction();
            }
            unitOfWorkImpl.setWasNonObjectLevelModifyQueryExecuted(true);
            this.result = (Integer)super.executeInUnitOfWork(unitOfWorkImpl, abstractRecord);
        }
        return this.result;
    }

    public int getCacheUsage() {
        return this.m_cacheUsage;
    }

    public ExpressionBuilder getExpressionBuilder() {
        if (this.defaultBuilder == null) {
            this.initializeDefaultBuilder();
        }
        return this.defaultBuilder;
    }

    public void setExpressionBuilder(ExpressionBuilder expressionBuilder) {
        this.defaultBuilder = expressionBuilder;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    protected void invalidateCache() {
        IdentityMapAccessor identityMapAccessor = this.getSession().getIdentityMapAccessor();
        if (this.getSelectionCriteria() == null) {
            if (this.getDescriptor().isChildDescriptor()) {
                Vector vector = identityMapAccessor.getAllFromIdentityMap(null, this.getReferenceClass(), (Record)this.getTranslationRow(), null);
                identityMapAccessor.invalidateObjects(vector);
            } else {
                identityMapAccessor.invalidateClass(this.getReferenceClass());
            }
        } else {
            boolean bl = this.result != null && this.result == 0;
            try {
                int n = 2;
                if (bl) {
                    n = 3;
                }
                Vector vector = identityMapAccessor.getAllFromIdentityMap(this.getSelectionCriteria(), this.getReferenceClass(), (Record)this.getTranslationRow(), n);
                identityMapAccessor.invalidateObjects(vector);
            }
            catch (QueryException queryException) {
                if (queryException.getErrorCode() == 6074) {
                    if (!bl) {
                        identityMapAccessor.invalidateClass(this.getReferenceClass());
                    }
                }
                throw queryException;
            }
        }
    }

    public void mergeChangesIntoSharedCache() {
        if (this.shouldInvalidateCache()) {
            this.invalidateCache();
        }
    }

    public void setCacheUsage(int n) {
        this.m_cacheUsage = n;
    }

    public void setReferenceClass(Class clazz) {
        if (this.referenceClass != clazz) {
            this.setIsPrepared(false);
        }
        this.referenceClass = clazz;
    }

    public void setReferenceClassName(String string) {
        this.referenceClassName = string;
    }

    public void setShouldDeferExecutionInUOW(boolean bl) {
        this.shouldDeferExecutionInUOW = bl;
    }

    public boolean shouldDeferExecutionInUOW() {
        return this.shouldDeferExecutionInUOW;
    }

    protected boolean shouldInvalidateCache() {
        return this.m_cacheUsage == 1;
    }

    protected void initializeDefaultBuilder() {
        this.initializeQuerySpecificDefaultBuilder();
        if (this.defaultBuilder == null) {
            this.defaultBuilder = new ExpressionBuilder();
        }
    }

    protected void initializeQuerySpecificDefaultBuilder() {
        DatabaseQueryMechanism databaseQueryMechanism = this.getQueryMechanism();
        if (databaseQueryMechanism.isExpressionQueryMechanism() && ((ExpressionQueryMechanism)databaseQueryMechanism).getExpressionBuilder() != null) {
            this.defaultBuilder = ((ExpressionQueryMechanism)databaseQueryMechanism).getExpressionBuilder();
        }
    }
}

