/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.ModifyQuery;

public abstract class ObjectLevelModifyQuery
extends ModifyQuery {
    protected Vector primaryKey;
    protected Object object;
    protected ObjectChangeSet objectChangeSet;
    protected Object backupClone;

    public ObjectLevelModifyQuery() {
        this.cascadePolicy = 2;
    }

    public void checkDescriptor(AbstractSession abstractSession) throws QueryException {
        if (this.getDescriptor() == null) {
            if (this.getObject() == null) {
                throw QueryException.objectToModifyNotSpecified(this);
            }
            ClassDescriptor classDescriptor = abstractSession.getDescriptor(this.getObject());
            if (classDescriptor == null) {
                throw QueryException.descriptorIsMissing(this.getObject().getClass(), this);
            }
            this.setDescriptor(classDescriptor);
        }
    }

    public Object executeInUnitOfWork(UnitOfWorkImpl unitOfWorkImpl, AbstractRecord abstractRecord) throws DatabaseException {
        if (unitOfWorkImpl.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(unitOfWorkImpl.getLifecycle(), "executeQuery(ObjectLevelModifyQuery)");
        }
        return this.executeInUnitOfWorkObjectLevelModifyQuery(unitOfWorkImpl, abstractRecord);
    }

    protected Object executeInUnitOfWorkObjectLevelModifyQuery(UnitOfWorkImpl unitOfWorkImpl, AbstractRecord abstractRecord) throws DatabaseException, OptimisticLockException {
        if (!unitOfWorkImpl.getCommitManager().isActive()) {
            throw QueryException.invalidQuery(this);
        }
        if (this.getObject() != null && unitOfWorkImpl.isClassReadOnly(this.getObject().getClass(), this.getDescriptor())) {
            return this.getObject();
        }
        if (unitOfWorkImpl.shouldPerformNoValidation() && unitOfWorkImpl.isUnregisteredExistingObject(this.getObject())) {
            return null;
        }
        return super.executeInUnitOfWork(unitOfWorkImpl, abstractRecord);
    }

    public Object getBackupClone() {
        if (this.backupClone == null && this.getSession().isUnitOfWork()) {
            this.setBackupClone(((UnitOfWorkImpl)this.getSession()).getBackupCloneForCommit(this.getObject(), this.getDescriptor()));
        }
        return this.backupClone;
    }

    public Object getObject() {
        return this.object;
    }

    public ObjectChangeSet getObjectChangeSet() {
        return this.objectChangeSet;
    }

    public Vector getPrimaryKey() {
        return this.primaryKey;
    }

    public Class getReferenceClass() {
        if (this.getObject() == null) {
            return null;
        }
        return this.getObject().getClass();
    }

    public String getReferenceClassName() {
        if (this.getReferenceClass() != null) {
            return this.getReferenceClass().getName();
        }
        return null;
    }

    public boolean isObjectLevelModifyQuery() {
        return true;
    }

    protected void prepare() throws QueryException {
        this.checkDescriptor(this.getSession());
        if (this.getObject() != null) {
            this.setObject(this.getDescriptor().getObjectBuilder().unwrapObject(this.getObject(), this.getSession()));
        }
        if (this.getDescriptor().isAggregateDescriptor()) {
            throw QueryException.aggregateObjectCannotBeDeletedOrWritten(this.getDescriptor(), this);
        }
        super.prepare();
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.object == null) {
            throw QueryException.objectToModifyNotSpecified(this);
        }
        this.object = this.descriptor.getObjectBuilder().unwrapObject(this.object, this.session);
        if (this.primaryKey == null) {
            this.primaryKey = this.objectChangeSet != null ? this.objectChangeSet.getPrimaryKeys() : this.descriptor.getObjectBuilder().extractPrimaryKeyFromObject(this.object, this.session);
        }
    }

    public void setBackupClone(Object object) {
        this.backupClone = object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setObjectChangeSet(ObjectChangeSet objectChangeSet) {
        this.objectChangeSet = objectChangeSet;
    }

    public void setPrimaryKey(Vector vector) {
        this.primaryKey = vector;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + String.valueOf(this.getObject()) + ")";
    }
}

