/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.ComplexQueryResult;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.tools.profiler.QueryMonitor;

public class ReadAllQuery
extends ObjectLevelReadQuery {
    protected Vector orderByExpressions;
    protected Vector batchReadAttributeExpressions;
    protected transient Map batchReadMappingQueries;
    protected List batchReadAttributes;
    protected ContainerPolicy containerPolicy;
    protected Expression startWithExpression;
    protected Expression connectByExpression;
    protected Vector orderSiblingsByExpressions;

    public ReadAllQuery() {
        this.setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
    }

    public ReadAllQuery(Class clazz) {
        this();
        this.referenceClass = clazz;
    }

    public ReadAllQuery(Class clazz, Expression expression) {
        this();
        this.referenceClass = clazz;
        this.setSelectionCriteria(expression);
    }

    public ReadAllQuery(Class clazz, ExpressionBuilder expressionBuilder) {
        this();
        this.defaultBuilder = expressionBuilder;
        this.referenceClass = clazz;
    }

    public ReadAllQuery(Class clazz, Call call) {
        this();
        this.referenceClass = clazz;
        this.setCall(call);
    }

    public ReadAllQuery(Object object, QueryByExamplePolicy queryByExamplePolicy) {
        this();
        this.setExampleObject(object);
        this.setQueryByExamplePolicy(queryByExamplePolicy);
    }

    public ReadAllQuery(ExpressionBuilder expressionBuilder) {
        this();
        this.defaultBuilder = expressionBuilder;
    }

    public ReadAllQuery(Call call) {
        this();
        this.setCall(call);
    }

    public void addAscendingOrdering(String string) {
        this.addOrdering(this.getExpressionBuilder().get(string).ascending());
    }

    public void addBatchReadAttribute(String string) {
        if (!this.getQueryMechanism().isExpressionQueryMechanism()) {
            throw QueryException.batchReadingNotSupported(this);
        }
        this.getBatchReadAttributeExpressions().add(this.getExpressionBuilder().get(string));
    }

    public void addBatchReadAttribute(Expression expression) {
        this.getBatchReadAttributeExpressions().add(expression);
    }

    public void addDescendingOrdering(String string) {
        this.addOrdering(this.getExpressionBuilder().get(string).descending());
    }

    public void addOrdering(Expression expression) {
        this.getOrderByExpressions().addElement(expression);
        this.setIsPrepared(false);
        this.setShouldOuterJoinSubclasses(true);
    }

    public void cacheResult(Object object) {
        Collection collection = (Collection)this.getTemporaryCachedQueryResults();
        if (collection == null) {
            collection = (Collection)this.getContainerPolicy().containerInstance();
            this.setTemporaryCachedQueryResults(collection);
        }
        this.getContainerPolicy().addInto(object, (Object)collection, this.getSession());
    }

    protected Object checkEarlyReturnImpl(AbstractSession abstractSession, AbstractRecord abstractRecord) {
        if (this.shouldCheckCacheOnly()) {
            if (this.shouldUseWrapperPolicy()) {
                this.getContainerPolicy().setElementDescriptor(this.getDescriptor());
            }
            AbstractSession abstractSession2 = abstractSession;
            while (abstractSession2.isUnitOfWork()) {
                abstractSession2 = ((UnitOfWorkImpl)abstractSession2).getParent();
            }
            Vector vector = abstractSession2.getIdentityMapAccessor().getAllFromIdentityMap(this.getSelectionCriteria(), this.getReferenceClass(), (Record)abstractRecord, this.getInMemoryQueryIndirectionPolicyState(), false);
            if (abstractSession.isUnitOfWork()) {
                vector = ((UnitOfWorkImpl)abstractSession).registerAllObjects(vector);
            }
            return this.getContainerPolicy().buildContainerFromVector(vector, abstractSession);
        }
        return null;
    }

    protected DatabaseQuery checkForCustomQuery(AbstractSession abstractSession, AbstractRecord abstractRecord) {
        this.checkDescriptor(abstractSession);
        if (this.isCustomQueryUsed() == null) {
            this.setIsCustomQueryUsed(!this.isUserDefined() && this.isExpressionQuery() && this.getSelectionCriteria() == null && !this.hasOrderByExpressions() && this.getDescriptor().getQueryManager().hasReadAllQuery());
        }
        if (this.isCustomQueryUsed().booleanValue()) {
            return this.getDescriptor().getQueryManager().getReadAllQuery();
        }
        return null;
    }

    public Object clone() {
        ReadAllQuery readAllQuery = (ReadAllQuery)super.clone();
        if (this.hasOrderByExpressions()) {
            readAllQuery.orderByExpressions = (Vector)this.getOrderByExpressions().clone();
        }
        readAllQuery.containerPolicy = this.getContainerPolicy().clone(readAllQuery);
        return readAllQuery;
    }

    protected Object conformResult(Object object, UnitOfWorkImpl unitOfWorkImpl, AbstractRecord abstractRecord, boolean bl) {
        Object object2;
        Object object3;
        Object object4;
        Cloneable cloneable;
        if (this.getSelectionCriteria() != null) {
            cloneable = this.getSelectionCriteria().getBuilder();
            ((ExpressionBuilder)cloneable).setSession(unitOfWorkImpl.getRootSession(null));
            ((ExpressionBuilder)cloneable).setQueryClass(this.getReferenceClass());
        }
        cloneable = this.getRedirector() != null ? ContainerPolicy.buildPolicyFor(object.getClass()) : this.getContainerPolicy();
        Map map = unitOfWorkImpl.scanForConformingInstances(this.getSelectionCriteria(), this.getReferenceClass(), abstractRecord, this);
        Cursor cursor = null;
        if (((ContainerPolicy)cloneable).isCursorPolicy()) {
            cursor = (Cursor)object;
            cloneable = ContainerPolicy.buildPolicyFor(ClassConstants.Vector_class);
            cursor.setSession(unitOfWorkImpl);
            object = cursor.getObjectCollection();
            cursor.setInitiallyConformingIndex(map);
            cursor.setSelectionCriteriaClone(this.getSelectionCriteria());
            cursor.setTranslationRow(abstractRecord);
        }
        Vector<Object> vector = null;
        if (bl) {
            object4 = (Vector)object;
            vector = new Vector(((Vector)object4).size());
            for (int i = 0; i < ((Vector)object4).size(); ++i) {
                object3 = ((Vector)object4).elementAt(i);
                if (object3 == null || (object2 = this.conformIndividualResult(object3, unitOfWorkImpl, abstractRecord, this.getSelectionCriteria(), map, bl)) == null) continue;
                vector.addElement(object2);
            }
        } else {
            vector = new Vector<Object>(((ContainerPolicy)cloneable).sizeFor(object));
            object4 = unitOfWorkImpl.getParent();
            Object object5 = ((ContainerPolicy)cloneable).iteratorFor(object);
            while (((ContainerPolicy)cloneable).hasNext(object5)) {
                object3 = ((ContainerPolicy)cloneable).next(object5, (AbstractSession)object4);
                object2 = this.conformIndividualResult(object3, unitOfWorkImpl, abstractRecord, this.getSelectionCriteria(), map, bl);
                if (object2 == null) continue;
                vector.addElement(object2);
            }
        }
        object4 = ((ContainerPolicy)cloneable).containerInstance(map.size() + vector.size());
        for (Object e : map.values()) {
            ((ContainerPolicy)cloneable).addInto(e, object4, unitOfWorkImpl);
        }
        object3 = vector.elements();
        while (object3.hasMoreElements()) {
            Object e = object3.nextElement();
            ((ContainerPolicy)cloneable).addInto(e, object4, unitOfWorkImpl);
        }
        if (cursor != null) {
            cursor.setObjectCollection((Vector)object4);
            if (unitOfWorkImpl.isNestedUnitOfWork()) {
                object3 = cursor.getObjectCollection().elements();
                while (object3.hasMoreElements()) {
                    object2 = object3.nextElement();
                    map.put(object2, object2);
                }
            }
            return cursor;
        }
        return object4;
    }

    public Object execute(AbstractSession abstractSession, AbstractRecord abstractRecord) throws DatabaseException {
        if (this.shouldCacheQueryResults()) {
            Object object;
            if (this.getContainerPolicy().overridesRead()) {
                throw QueryException.cannotCacheCursorResultsOnQuery(this);
            }
            if (this.shouldConformResultsInUnitOfWork()) {
                throw QueryException.cannotConformAndCacheQueryResults(this);
            }
            if (this.isPrepared() && (object = this.getQueryResults(abstractSession, abstractRecord, true)) != null) {
                if (QueryMonitor.shouldMonitor()) {
                    QueryMonitor.incrementReadAllHits(this);
                }
                if (object == InvalidObject.instance) {
                    return this.getContainerPolicy().containerInstance();
                }
                Collection collection = (Collection)object;
                if (abstractSession.isUnitOfWork()) {
                    ContainerPolicy containerPolicy = this.getContainerPolicy();
                    Object object2 = containerPolicy.containerInstance();
                    Object object3 = containerPolicy.iteratorFor(collection);
                    while (containerPolicy.hasNext(object3)) {
                        Object object4 = ((UnitOfWorkImpl)abstractSession).registerExistingObject(containerPolicy.next(object3, abstractSession), this.descriptor);
                        containerPolicy.addInto(object4, object2, abstractSession);
                    }
                    return object2;
                }
                return collection;
            }
        }
        if (QueryMonitor.shouldMonitor()) {
            QueryMonitor.incrementReadAllMisses(this);
        }
        return super.execute(abstractSession, abstractRecord);
    }

    protected Object executeObjectLevelReadQuery() throws DatabaseException {
        Object object = null;
        if (this.getContainerPolicy().overridesRead()) {
            return this.getContainerPolicy().execute();
        }
        if (this.getDescriptor().isDescriptorForInterface()) {
            Object object2 = this.getDescriptor().getInterfacePolicy().selectAllObjectsUsingMultipleTableSubclassRead(this);
            this.setExecutionTime(System.currentTimeMillis());
            return object2;
        }
        Vector vector = this.getQueryMechanism().selectAllRows();
        this.setExecutionTime(System.currentTimeMillis());
        if (this.hasJoining() && this.joinedAttributeManager.isToManyJoin()) {
            this.joinedAttributeManager.setDataResults(vector, this.session);
        }
        if (this.session.isUnitOfWork()) {
            object = this.registerResultInUnitOfWork(vector, (UnitOfWorkImpl)this.session, this.translationRow, true);
        } else {
            object = this.getContainerPolicy().containerInstance(vector.size());
            this.descriptor.getObjectBuilder().buildObjectsInto(this, vector, object);
        }
        if (this.shouldIncludeData) {
            ComplexQueryResult complexQueryResult = new ComplexQueryResult();
            complexQueryResult.setResult(object);
            complexQueryResult.setData(vector);
            return complexQueryResult;
        }
        if (this.getDescriptor().hasTablePerClassPolicy()) {
            object = this.containerPolicy.concatenateContainers(object, this.getDescriptor().getTablePerClassPolicy().selectAllObjectsUsingMultipleTableSubclassRead(this));
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object executeObjectLevelReadQueryFromResultSet() throws DatabaseException {
        Vector<Object> vector;
        UnitOfWorkImpl unitOfWorkImpl = (UnitOfWorkImpl)this.getSession();
        DatabaseAccessor databaseAccessor = (DatabaseAccessor)unitOfWorkImpl.getAccessor();
        DatabasePlatform databasePlatform = databaseAccessor.getPlatform();
        DatabaseCall databaseCall = (DatabaseCall)this.getCall().clone();
        databaseCall.setQuery(this);
        databaseCall.translate(this.translationRow, null, unitOfWorkImpl);
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            try {
                databaseAccessor.incrementCallCount(unitOfWorkImpl);
                statement = databaseCall.prepareStatement(databaseAccessor, this.translationRow, unitOfWorkImpl);
                resultSet = databaseAccessor.executeSelect(databaseCall, statement, unitOfWorkImpl);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                Vector<Object> vector2 = new Vector<Object>();
                ObjectBuilder objectBuilder = this.descriptor.getObjectBuilder();
                while (resultSet.next()) {
                    vector2.add(objectBuilder.buildWorkingCopyCloneFromResultSet(this, this.joinedAttributeManager, resultSet, unitOfWorkImpl, databaseAccessor, resultSetMetaData, databasePlatform));
                }
                vector = vector2;
                Object var13_14 = null;
            }
            catch (SQLException sQLException) {
                bl = true;
                DatabaseException databaseException = databaseAccessor.processExceptionForCommError(this.session, sQLException, databaseCall);
                if (databaseException == null) throw DatabaseException.sqlException(sQLException, databaseCall, databaseAccessor, unitOfWorkImpl, false);
                throw databaseException;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement == null) throw throwable;
                databaseAccessor.releaseStatement(statement, databaseCall.getSQLString(), databaseCall, unitOfWorkImpl);
                throw throwable;
            }
            catch (SQLException sQLException2) {
                if (bl) throw throwable;
                DatabaseException databaseException = databaseAccessor.processExceptionForCommError(this.session, sQLException2, databaseCall);
                if (databaseException == null) throw DatabaseException.sqlException(sQLException2, databaseCall, databaseAccessor, this.session, false);
                throw databaseException;
            }
        }
        try {}
        catch (SQLException sQLException) {
            if (bl) return vector;
            DatabaseException databaseException = databaseAccessor.processExceptionForCommError(this.session, sQLException, databaseCall);
            if (databaseException == null) throw DatabaseException.sqlException(sQLException, databaseCall, databaseAccessor, this.session, false);
            throw databaseException;
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (statement == null) return vector;
        databaseAccessor.releaseStatement(statement, databaseCall.getSQLString(), databaseCall, unitOfWorkImpl);
        return vector;
    }

    public Object extractRemoteResult(Transporter transporter) {
        return ((RemoteSession)this.getSession()).getObjectsCorrespondingToAll(transporter.getObject(), transporter.getObjectDescriptors(), new IdentityHashMap(), this, this.getContainerPolicy());
    }

    public Vector getBatchReadAttributeExpressions() {
        if (this.batchReadAttributeExpressions == null) {
            this.batchReadAttributeExpressions = NonSynchronizedVector.newInstance();
        }
        return this.batchReadAttributeExpressions;
    }

    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultReadAllQueryRedirector();
    }

    public Expression getStartWithExpression() {
        return this.startWithExpression;
    }

    public Expression getConnectByExpression() {
        return this.connectByExpression;
    }

    public Vector getOrderSiblingsByExpressions() {
        return this.orderSiblingsByExpressions;
    }

    public Vector getOrderByExpressions() {
        if (this.orderByExpressions == null) {
            this.orderByExpressions = NonSynchronizedVector.newInstance();
        }
        return this.orderByExpressions;
    }

    public boolean hasOrderByExpressions() {
        return this.orderByExpressions != null;
    }

    public boolean hasHierarchicalExpressions() {
        return this.startWithExpression != null || this.connectByExpression != null || this.orderSiblingsByExpressions != null;
    }

    public boolean hasBatchReadAttributes() {
        return this.batchReadAttributeExpressions != null && !this.batchReadAttributeExpressions.isEmpty();
    }

    public boolean isAttributeBatchRead(String string) {
        if (!this.hasBatchReadAttributes()) {
            return false;
        }
        Vector vector = this.getBatchReadAttributeExpressions();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            QueryKeyExpression queryKeyExpression = (QueryKeyExpression)vector.get(i);
            while (!queryKeyExpression.getBaseExpression().isExpressionBuilder()) {
                queryKeyExpression = (QueryKeyExpression)queryKeyExpression.getBaseExpression();
            }
            if (!queryKeyExpression.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isAttributeBatchRead(ClassDescriptor classDescriptor, String string) {
        if (!this.hasBatchReadAttributes()) {
            return false;
        }
        if (classDescriptor.isAggregateDescriptor() && classDescriptor != this.getDescriptor()) {
            return false;
        }
        if (this.batchReadAttributes != null) {
            return this.batchReadAttributes.contains(string);
        }
        return this.isAttributeBatchRead(string);
    }

    public Map getBatchReadMappingQueries() {
        return this.batchReadMappingQueries;
    }

    protected void setBatchReadMappingQueries(Map map) {
        this.batchReadMappingQueries = map;
    }

    public boolean isDefaultPropertiesQuery() {
        return super.isDefaultPropertiesQuery() && !this.hasBatchReadAttributes() && !this.hasHierarchicalExpressions() && !this.getContainerPolicy().isCursorPolicy();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ReadAllQuery readAllQuery = (ReadAllQuery)object;
        if (!this.getContainerPolicy().equals(readAllQuery.getContainerPolicy())) {
            return false;
        }
        if (this.hasOrderByExpressions()) {
            if (!readAllQuery.hasOrderByExpressions()) {
                return false;
            }
            Vector vector = this.getOrderByExpressions();
            Vector vector2 = readAllQuery.getOrderByExpressions();
            int n = vector.size();
            if (n != vector2.size()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (vector.get(i).equals(vector2.get(i))) continue;
                return false;
            }
        } else if (readAllQuery.hasOrderByExpressions()) {
            return false;
        }
        return true;
    }

    public boolean isReadAllQuery() {
        return true;
    }

    protected void prepare() throws QueryException {
        if (!this.isReportQuery() && this.prepareFromCachedQuery()) {
            return;
        }
        super.prepare();
        this.getContainerPolicy().prepare(this, this.getSession());
        if (this.getContainerPolicy().overridesRead()) {
            return;
        }
        if (this.getDescriptor().isDescriptorForInterface()) {
            return;
        }
        this.prepareSelectAllRows();
        this.computeBatchReadMappingQueries();
    }

    public void prepareFromQuery(DatabaseQuery databaseQuery) {
        super.prepareFromQuery(databaseQuery);
        if (databaseQuery.isReadAllQuery()) {
            ReadAllQuery readAllQuery = (ReadAllQuery)databaseQuery;
            if (readAllQuery.hasOrderByExpressions()) {
                this.orderByExpressions = readAllQuery.orderByExpressions;
            }
            this.containerPolicy = readAllQuery.containerPolicy;
            if (readAllQuery.hasHierarchicalExpressions()) {
                this.orderSiblingsByExpressions = readAllQuery.getOrderSiblingsByExpressions();
                this.connectByExpression = readAllQuery.getConnectByExpression();
                this.startWithExpression = readAllQuery.getStartWithExpression();
            }
            if (readAllQuery.hasBatchReadAttributes()) {
                this.batchReadAttributeExpressions = readAllQuery.batchReadAttributeExpressions;
                this.batchReadMappingQueries = readAllQuery.batchReadMappingQueries;
                this.batchReadAttributes = readAllQuery.batchReadAttributes;
            }
        }
    }

    protected void prepareCustomQuery(DatabaseQuery databaseQuery) {
        ReadAllQuery readAllQuery = (ReadAllQuery)databaseQuery;
        readAllQuery.setContainerPolicy(this.getContainerPolicy());
        readAllQuery.setCascadePolicy(this.getCascadePolicy());
        readAllQuery.setShouldRefreshIdentityMapResult(this.shouldRefreshIdentityMapResult());
        readAllQuery.setShouldMaintainCache(this.shouldMaintainCache());
        readAllQuery.setShouldUseWrapperPolicy(this.shouldUseWrapperPolicy());
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        this.getContainerPolicy().prepareForExecution();
    }

    protected void prepareSelectAllRows() {
        this.getQueryMechanism().prepareSelectAllRows();
    }

    public Object registerResultInUnitOfWork(Object object, UnitOfWorkImpl unitOfWorkImpl, AbstractRecord abstractRecord, boolean bl) {
        if (this.shouldConformResultsInUnitOfWork() || this.descriptor.shouldAlwaysConformResultsInUnitOfWork()) {
            return this.conformResult(object, unitOfWorkImpl, abstractRecord, bl);
        }
        if (bl) {
            List list = (List)object;
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            int n = list.size();
            Object object2 = containerPolicy.containerInstance(n);
            for (int i = 0; i < n; ++i) {
                AbstractRecord abstractRecord2 = (AbstractRecord)list.get(i);
                if (abstractRecord2 == null) continue;
                Object object3 = this.buildObject(abstractRecord2);
                containerPolicy.addInto(object3, object2, unitOfWorkImpl);
            }
            return object2;
        }
        Cursor cursor = null;
        ContainerPolicy containerPolicy = this.getRedirector() != null ? ContainerPolicy.buildPolicyFor(object.getClass()) : this.getContainerPolicy();
        if (containerPolicy.isCursorPolicy()) {
            cursor = (Cursor)object;
            cursor.setSession(unitOfWorkImpl);
            containerPolicy = ContainerPolicy.buildPolicyFor(ClassConstants.Vector_class);
            object = cursor.getObjectCollection();
        }
        Object object4 = containerPolicy.containerInstance(containerPolicy.sizeFor(object));
        AbstractSession abstractSession = unitOfWorkImpl.getParent();
        Object object5 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object5)) {
            Object object6 = containerPolicy.next(object5, abstractSession);
            Object object7 = this.registerIndividualResult(object6, unitOfWorkImpl, this.joinedAttributeManager);
            containerPolicy.addInto(object7, object4, unitOfWorkImpl);
        }
        if (cursor != null) {
            cursor.setObjectCollection((Vector)object4);
            return cursor;
        }
        return object4;
    }

    public Object remoteExecute() {
        if (this.getContainerPolicy().overridesRead()) {
            return this.getContainerPolicy().remoteExecute();
        }
        Object object = this.checkEarlyReturn(this.getSession(), this.getTranslationRow());
        if (object != null) {
            return object;
        }
        return super.remoteExecute();
    }

    public Map replaceValueHoldersIn(Object object, RemoteSessionController remoteSessionController) {
        return remoteSessionController.replaceValueHoldersInAll(object, this.getContainerPolicy());
    }

    public void setBatchReadAttributeExpressions(Vector vector) {
        this.batchReadAttributeExpressions = vector;
    }

    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        if (containerPolicy == null) {
            return;
        }
        this.containerPolicy = containerPolicy;
        this.setIsPrepared(false);
    }

    public void setHierarchicalQueryClause(Expression expression, Expression expression2, Vector vector) {
        this.startWithExpression = expression;
        this.connectByExpression = expression2;
        this.orderSiblingsByExpressions = vector;
        this.setIsPrepared(false);
    }

    public void setOrderByExpressions(Vector vector) {
        this.orderByExpressions = vector;
    }

    public void useCollectionClass(Class clazz) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(clazz));
    }

    public void useCursoredStream() {
        this.useCursoredStream(10, 5);
    }

    public void useCursoredStream(int n, int n2) {
        this.setContainerPolicy(new CursoredStreamPolicy(this, n, n2));
    }

    public void useCursoredStream(int n, int n2, ValueReadQuery valueReadQuery) {
        this.setContainerPolicy(new CursoredStreamPolicy(this, n, n2, valueReadQuery));
    }

    public void useMapClass(Class clazz, String string) {
        if (this.getReferenceClass() == null) {
            throw QueryException.referenceClassMissing(this);
        }
        ContainerPolicy containerPolicy = ContainerPolicy.buildPolicyFor(clazz);
        containerPolicy.setKeyName(string, this.getReferenceClass().getName());
        this.setContainerPolicy(containerPolicy);
    }

    public void useScrollableCursor() {
        this.useScrollableCursor(10);
    }

    public void useScrollableCursor(int n) {
        this.setContainerPolicy(new ScrollableCursorPolicy(this, n));
    }

    public void useScrollableCursor(ScrollableCursorPolicy scrollableCursorPolicy) {
        scrollableCursorPolicy.setQuery(this);
        this.setContainerPolicy(scrollableCursorPolicy);
    }

    public void computeBatchReadMappingQueries() {
        if (this.hasBatchReadAttributes() && !this.getDescriptor().hasInheritance()) {
            this.batchReadAttributes = new ArrayList(this.getBatchReadAttributeExpressions().size());
            this.setBatchReadMappingQueries(new HashMap(this.getBatchReadAttributeExpressions().size()));
            this.computeNestedQueriesForBatchReadExpressions(this.getBatchReadAttributeExpressions());
        }
    }

    protected void computeNestedQueriesForBatchReadExpressions(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping;
            ObjectExpression objectExpression = (ObjectExpression)vector.get(i);
            ExpressionBuilder expressionBuilder = objectExpression.getBuilder();
            expressionBuilder.setSession(this.getSession().getRootSession(null));
            expressionBuilder.setQueryClass(this.getReferenceClass());
            ObjectExpression objectExpression2 = objectExpression;
            while (!objectExpression2.getBaseExpression().isExpressionBuilder()) {
                objectExpression2 = (ObjectExpression)objectExpression2.getBaseExpression();
            }
            this.batchReadAttributes.add(objectExpression2.getName());
            if (!objectExpression.getBaseExpression().isExpressionBuilder() || (databaseMapping = objectExpression.getMapping()) == null || !databaseMapping.isForeignReferenceMapping()) continue;
            ReadQuery readQuery = ((ForeignReferenceMapping)databaseMapping).prepareNestedBatchQuery(this);
            this.getBatchReadMappingQueries().put(databaseMapping, readQuery);
        }
    }
}

