/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.coordination;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.eclipse.persistence.exceptions.DiscoveryException;
import org.eclipse.persistence.internal.sessions.coordination.ProfileDiscoveryStartedCommand;
import org.eclipse.persistence.internal.sessions.coordination.ProfileDiscoveryStoppedCommand;
import org.eclipse.persistence.internal.sessions.coordination.ServiceAnnouncement;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.ServiceId;

public class DiscoveryManager
implements Runnable {
    public static final String DEFAULT_MULTICAST_GROUP = "226.10.12.64";
    public static final int DEFAULT_MULTICAST_PORT = 3121;
    public static final int DEFAULT_PACKET_TIME_TO_LIVE = 2;
    public static final int DEFAULT_ANNOUNCEMENT_DELAY = 1000;
    protected String multicastGroupAddress = "226.10.12.64";
    protected int multicastPort = 3121;
    protected MulticastSocket communicationSocket;
    protected int packetTimeToLive = 2;
    protected boolean stopListening = false;
    protected int announcementDelay = 1000;
    protected RemoteCommandManager rcm;

    public DiscoveryManager(RemoteCommandManager remoteCommandManager) {
        this.rcm = remoteCommandManager;
    }

    public DiscoveryManager(String string, int n, RemoteCommandManager remoteCommandManager) {
        this(remoteCommandManager);
        this.multicastGroupAddress = string;
        this.multicastPort = n;
    }

    public DiscoveryManager(String string, int n, int n2, RemoteCommandManager remoteCommandManager) {
        this(string, n, remoteCommandManager);
        this.announcementDelay = n2;
    }

    public void announceSession() {
        this.rcm.logDebug("sending_announcement", null);
        ServiceAnnouncement serviceAnnouncement = new ServiceAnnouncement(this.rcm.getServiceId());
        byte[] byArray = serviceAnnouncement.toBytes();
        try {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getByName(this.multicastGroupAddress), this.multicastPort);
            this.getCommunicationSocket().send(datagramPacket);
            Object[] objectArray = null;
            this.rcm.logInfo("announcement_sent", objectArray);
        }
        catch (Exception exception) {
            DiscoveryException discoveryException = DiscoveryException.errorSendingAnnouncement(exception);
            this.rcm.handleException(discoveryException);
        }
    }

    public void startDiscovery() {
        if (this.rcm.isCommandProcessorASession()) {
            this.rcm.getCommandProcessor().processCommand(new ProfileDiscoveryStartedCommand());
        }
        if (this.isDiscoveryStopped()) {
            this.rcm.getServerPlatform().launchContainerRunnable(this);
        }
    }

    public void stopDiscovery() {
        if (this.rcm.isCommandProcessorASession()) {
            this.rcm.getCommandProcessor().processCommand(new ProfileDiscoveryStoppedCommand());
        }
        this.stopListening();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.communicationSocket = null;
    }

    public boolean isDiscoveryStopped() {
        return this.communicationSocket == null;
    }

    public void createCommunicationSocket() {
        Object[] objectArray = new Object[]{this.multicastGroupAddress, "" + this.multicastPort};
        this.rcm.logDebug("initializing_discovery_resources", objectArray);
        if (this.communicationSocket == null) {
            try {
                this.communicationSocket = new MulticastSocket(this.multicastPort);
                this.communicationSocket.setTimeToLive(this.getPacketTimeToLive());
                this.communicationSocket.joinGroup(InetAddress.getByName(this.multicastGroupAddress));
            }
            catch (IOException iOException) {
                DiscoveryException discoveryException = DiscoveryException.errorJoiningMulticastGroup(iOException);
                this.rcm.handleException(discoveryException);
            }
        }
    }

    public MulticastSocket getCommunicationSocket() {
        return this.communicationSocket;
    }

    public void run() {
        this.createCommunicationSocket();
        this.rcm.getTransportManager().createLocalConnection();
        try {
            Thread.sleep(this.announcementDelay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.announceSession();
        this.startListening();
    }

    public void startListening() {
        byte[] byArray = new byte[128];
        this.stopListening = false;
        this.rcm.logInfo("discovery_manager_active", null);
        while (!this.stopListening) {
            ServiceAnnouncement serviceAnnouncement;
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            try {
                this.getCommunicationSocket().receive(datagramPacket);
            }
            catch (IOException iOException) {
                if (this.stopListening) {
                    this.rcm.logInfo("discovery_manager_stopped", null);
                    return;
                }
                this.rcm.handleException(DiscoveryException.errorReceivingAnnouncement(iOException));
            }
            try {
                serviceAnnouncement = new ServiceAnnouncement(datagramPacket.getData());
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{exception};
                this.rcm.logWarning("received_corrupt_announcement", objectArray);
                continue;
            }
            if (this.rcm.getServiceId().getId().equals(serviceAnnouncement.getServiceId().getId()) || !this.rcm.getServiceId().getChannel().equalsIgnoreCase(serviceAnnouncement.getServiceId().getChannel())) continue;
            this.receivedAnnouncement(serviceAnnouncement.getServiceId());
        }
    }

    public void stopListening() {
        this.stopListening = true;
        if (this.getCommunicationSocket() != null) {
            this.getCommunicationSocket().close();
        }
    }

    public void receivedAnnouncement(ServiceId serviceId) {
        Object[] objectArray = new Object[]{serviceId};
        this.rcm.logInfo("announcement_received", objectArray);
        this.rcm.newServiceDiscovered(serviceId);
    }

    public void setAnnouncementDelay(int n) {
        this.announcementDelay = n;
    }

    public int getAnnouncementDelay() {
        return this.announcementDelay;
    }

    public String getMulticastGroupAddress() {
        return this.multicastGroupAddress;
    }

    public void setMulticastGroupAddress(String string) {
        this.multicastGroupAddress = string;
    }

    public void setMulticastPort(int n) {
        this.multicastPort = n;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    protected void shallowCopy(DiscoveryManager discoveryManager) {
        this.multicastGroupAddress = discoveryManager.multicastGroupAddress;
        this.multicastPort = discoveryManager.multicastPort;
        this.announcementDelay = discoveryManager.announcementDelay;
        this.rcm = discoveryManager.rcm;
    }

    public int getPacketTimeToLive() {
        return this.packetTimeToLive;
    }

    public void setPacketTimeToLive(int n) {
        this.packetTimeToLive = n;
    }
}

