/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.coordination;

import java.io.IOException;
import org.eclipse.persistence.exceptions.CommunicationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.sessions.coordination.Command;

public class MergeChangeSetCommand
extends Command {
    protected transient UnitOfWorkChangeSet changeSet;
    protected byte[] changeSetBytes;

    public UnitOfWorkChangeSet getChangeSet() {
        if (this.changeSet == null && this.changeSetBytes != null) {
            try {
                this.changeSet = new UnitOfWorkChangeSet(this.changeSetBytes);
            }
            catch (IOException iOException) {
                throw CommunicationException.unableToPropagateChanges(this.getServiceId().toString(), iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw CommunicationException.unableToPropagateChanges(this.getServiceId().toString(), classNotFoundException);
            }
        }
        return this.changeSet;
    }

    public void setChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) {
        this.changeSet = unitOfWorkChangeSet;
    }

    public boolean convertChangeSetToByteArray(AbstractSession abstractSession) throws IOException {
        this.changeSetBytes = this.changeSet.getByteArrayRepresentation(abstractSession);
        return this.changeSetBytes != null;
    }

    public void executeWithSession(AbstractSession abstractSession) {
        MergeManager mergeManager = new MergeManager(abstractSession);
        mergeManager.mergeIntoDistributedCache();
        mergeManager.setCascadePolicy(3);
        mergeManager.mergeChangesFromChangeSet(this.getChangeSet());
    }
}

