/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;

public class FileUtil {
    public static void copy(String string, String string2, String[] stringArray) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        File file2 = new File(string2);
        if (!file2.exists()) {
            if (file2.isDirectory()) {
                file2.mkdirs();
            } else {
                new File(file2.getParent()).mkdirs();
            }
        }
        Vector vector = FileUtil.findFiles(string, stringArray);
        for (int i = 0; i < vector.size(); ++i) {
            File file3 = (File)vector.elementAt(i);
            String string3 = file3.getAbsolutePath().substring(string.length());
            string3 = string2 + File.separator + string3;
            File file4 = new File(string3);
            File file5 = new File(file4.getParent());
            if (!file5.exists()) {
                file5.mkdirs();
            }
            FileUtil.copy(new FileInputStream(file3), new FileOutputStream(file4));
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[512];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.close();
    }

    public static void createJarFromDirectory(String string, String string2, String[] stringArray) throws IOException {
        File file = new File(string2);
        if (!file.exists()) {
            return;
        }
        File file2 = new File(string);
        if (!file2.exists()) {
            new File(file2.getParent()).mkdirs();
        }
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(file2), new Manifest());
        Vector vector = FileUtil.findFiles(string2, stringArray);
        for (int i = 0; i < vector.size(); ++i) {
            File file3 = (File)vector.elementAt(i);
            String string3 = file3.getAbsolutePath().substring(file.getAbsolutePath().length() + 1);
            String string4 = string3.replace('\\', '/');
            FileInputStream fileInputStream = new FileInputStream(file3);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            JarEntry jarEntry = new JarEntry(string4);
            jarOutputStream.putNextEntry(jarEntry);
            jarEntry.setSize(byArray2.length);
            jarEntry.setCompressedSize(byArray2.length);
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray2);
            jarEntry.setCrc(cRC32.getValue());
            jarEntry.setMethod(0);
            jarOutputStream.write(byArray2, 0, byArray2.length);
            jarOutputStream.closeEntry();
        }
        jarOutputStream.close();
    }

    public static Vector findFiles(String string, String[] stringArray) {
        Vector vector = new Vector();
        FileUtil.findFilesHelper(new File(string), stringArray, vector);
        return vector;
    }

    private static void findFilesHelper(File file, String[] stringArray, Vector vector) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] stringArray2 = file.list();
            for (int i = 0; i < stringArray2.length; ++i) {
                FileUtil.findFilesHelper(new File(file, stringArray2[i]), stringArray, vector);
            }
        } else {
            if (stringArray == null || stringArray.length == 0) {
                vector.addElement(file);
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!file.getName().endsWith(stringArray[i])) continue;
                vector.addElement(file);
                return;
            }
        }
    }

    public static void delete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            if (stringArray.length == 0) {
                file.delete();
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    FileUtil.delete(new File(file, stringArray[i]));
                }
                if (file.list().length == 0) {
                    file.delete();
                }
            }
        } else {
            file.delete();
        }
    }
}

