/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import java.io.IOException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.mbeanserver.Util;

final class JMXMPConnectorStarter {
    private final MBeanServer mMBeanServer;
    private volatile JMXConnectorServer mJMXMP = null;
    private volatile JMXServiceURL mJMXMPServiceURL = null;
    private volatile ObjectName mJMXMPObjectName = null;
    public static final int JMXMP_PORT = 8888;
    private static volatile boolean STARTED = false;

    protected static void debug(String s) {
        System.out.println(s);
    }

    public JMXServiceURL getJMXServiceURL() {
        return this.mJMXMPServiceURL;
    }

    JMXMPConnectorStarter(MBeanServer mbs) {
        this.mMBeanServer = mbs;
    }

    public synchronized void start() {
        if (STARTED) {
            return;
        }
        int TRY_COUNT = 100;
        int port = 8888;
        int tryCount = 0;
        while (tryCount < 100) {
            try {
                JMXConnectorServer cs = this.startJMXMPConnectorServer(port);
                break;
            }
            catch (BindException e) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (port < 1000) {
                port += 1000;
                continue;
            }
            ++port;
        }
    }

    public synchronized void stop() {
        try {
            this.mJMXMP.stop();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void ignore(Throwable t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMXConnectorServer startJMXMPConnectorServer(int port) throws MalformedURLException, IOException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (this.mJMXMPObjectName == null) {
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("jmx.remote.protocol.provider.pkgs", "com.sun.jmx.remote.protocol");
            env.put("jmx.remote.protocol.provider.class.loader", this.getClass().getClassLoader());
            JMXServiceURL serviceURL = new JMXServiceURL("service:jmx:jmxmp://localhost:" + port);
            JMXConnectorServer jmxmp = JMXConnectorServerFactory.newJMXConnectorServer(serviceURL, env, this.mMBeanServer);
            ObjectName objectName = Util.newObjectName("jmxremote:type=jmx-connector,name=jmxmp,port=" + port);
            objectName = this.mMBeanServer.registerMBean(jmxmp, objectName).getObjectName();
            boolean startedOK = false;
            try {
                jmxmp.start();
                startedOK = true;
            }
            finally {
                if (!startedOK) {
                    try {
                        jmxmp.stop();
                    }
                    catch (Exception e) {
                        JMXMPConnectorStarter.ignore(e);
                    }
                    try {
                        this.mMBeanServer.unregisterMBean(objectName);
                        objectName = null;
                    }
                    catch (Exception e) {
                        JMXMPConnectorStarter.ignore(e);
                    }
                }
            }
            this.mJMXMPServiceURL = serviceURL;
            this.mJMXMP = jmxmp;
            this.mJMXMPObjectName = objectName;
            System.out.println("JMXMP connector server URL = " + this.mJMXMPServiceURL);
        }
        return this.mJMXMP;
    }
}

