/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.cli;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service(name="attach-agent")
@I18n(value="attach.agent")
public class AttachAgent
implements AdminCommand {
    @Inject
    ServerEnvironmentImpl env;
    @Param(primary=true)
    private String pid;
    @Param(optional=true)
    private String options;
    private final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AttachAgent.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            File agentJar;
            VirtualMachine vm = VirtualMachine.attach(this.pid);
            File dir = this.env.getLibPath();
            if (dir.isDirectory() && (agentJar = new File(dir, "btrace-agent.jar")).isFile()) {
                vm.loadAgent(agentJar.getPath());
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(this.localStrings.getLocalString("attach.agent.exception", "Encountered exception during agent attach {0}", new Object[]{e.getMessage()}));
            e.printStackTrace();
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

