/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.provider;

import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ProbeRegistry {
    private static ProbeRegistry _me = new ProbeRegistry();
    private ConcurrentHashMap<Integer, FlashlightProbe> probeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, FlashlightProbe> probeDesc2ProbeMap = new ConcurrentHashMap();

    public static ProbeRegistry getInstance() {
        return _me;
    }

    public void registerProbe(FlashlightProbe probe) {
        this.probeMap.put(probe.getId(), probe);
        this.probeDesc2ProbeMap.put(probe.getProbeStr(), probe);
    }

    public void unregisterProbe(FlashlightProbe probe) {
        this.probeMap.remove(probe.getId());
    }

    public void unregisterProbe(int id) {
        this.probeMap.remove(id);
    }

    public FlashlightProbe getProbe(int id) {
        return this.probeMap.get(id);
    }

    public FlashlightProbe getProbe(String probeStr) {
        return this.probeDesc2ProbeMap.get(probeStr);
    }

    public static FlashlightProbe getProbeById(int id) {
        return _me.getProbe(id);
    }
}

