/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.constraints;

import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ValidationException;
import javax.validation.constraints.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternValidator
implements ConstraintValidator<Pattern, String> {
    private java.util.regex.Pattern pattern;

    @Override
    public void initialize(Pattern parameters) {
        Pattern.Flag[] flags = parameters.flags();
        int intFlag = 0;
        for (Pattern.Flag flag : flags) {
            intFlag |= this.mapFlagToInt(flag);
        }
        try {
            this.pattern = java.util.regex.Pattern.compile(parameters.regexp(), intFlag);
        }
        catch (PatternSyntaxException e) {
            throw new ValidationException("Invalid regular expression.", e);
        }
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        Matcher m = this.pattern.matcher(value);
        return m.matches();
    }

    private int mapFlagToInt(Pattern.Flag flag) {
        int intFlag = 0;
        switch (flag) {
            case UNIX_LINES: {
                intFlag = 1;
                break;
            }
            case CASE_INSENSITIVE: {
                intFlag = 2;
                break;
            }
            case COMMENTS: {
                intFlag = 4;
                break;
            }
            case MULTILINE: {
                intFlag = 8;
                break;
            }
            case DOTALL: {
                intFlag = 32;
                break;
            }
            case UNICODE_CASE: {
                intFlag = 64;
                break;
            }
            case CANON_EQ: {
                intFlag = 128;
            }
        }
        return intFlag;
    }
}

