/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.AuthorizationConstraintImpl;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractCommonAttributeHandler;
import com.sun.enterprise.deployment.annotation.handlers.PostProcessor;
import com.sun.enterprise.deployment.util.TypeUtil;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import javax.annotation.security.RolesAllowed;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class RolesAllowedHandler
extends AbstractCommonAttributeHandler
implements PostProcessor {
    public Class<? extends Annotation> getAnnotationType() {
        return RolesAllowed.class;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        if (!this.validateAccessControlAnnotations(ainfo)) {
            return this.getDefaultFailedResult();
        }
        RolesAllowed rolesAllowedAn = (RolesAllowed)ainfo.getAnnotation();
        for (EjbContext ejbContext : ejbContexts) {
            EjbDescriptor ejbDesc = ejbContext.getDescriptor();
            if (ElementType.TYPE.equals((Object)ainfo.getElementType())) {
                ejbContext.addPostProcessInfo(ainfo, this);
                continue;
            }
            Method annMethod = (Method)ainfo.getAnnotatedElement();
            for (Object next : ejbDesc.getSecurityBusinessMethodDescriptors()) {
                MethodDescriptor md = (MethodDescriptor)next;
                Method m = md.getMethod(ejbDesc);
                if (!TypeUtil.sameMethodSignature(m, annMethod) || this.hasMethodPermissionsFromDD(md, ejbDesc)) continue;
                this.addMethodPermissions(rolesAllowedAn, ejbDesc, md);
            }
        }
        return this.getDefaultProcessedResult();
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebComponentContext[] webCompContexts) throws AnnotationProcessorException {
        return this.processSecurityConstraintAnnotation(ainfo, webCompContexts);
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebBundleContext webBundleContext) throws AnnotationProcessorException {
        return this.getInvalidAnnotatedElementHandlerResult((AnnotatedElementHandler)webBundleContext, ainfo);
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAndWebAnnotationTypes();
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }

    @Override
    public void postProcessAnnotation(AnnotationInfo ainfo, AnnotatedElementHandler aeHandler) throws AnnotationProcessorException {
        EjbContext ejbContext = (EjbContext)aeHandler;
        EjbDescriptor ejbDesc = ejbContext.getDescriptor();
        RolesAllowed rolesAllowedAn = (RolesAllowed)ainfo.getAnnotation();
        if (!(ejbContext.isInherited() || ejbDesc.getMethodPermissionsFromDD() != null && ejbDesc.getMethodPermissionsFromDD().size() != 0)) {
            for (MethodDescriptor md : this.getMethodAllDescriptors(ejbDesc)) {
                this.addMethodPermissions(rolesAllowedAn, ejbDesc, md);
            }
        } else {
            Class classAn = (Class)ainfo.getAnnotatedElement();
            for (Object next : ejbDesc.getSecurityBusinessMethodDescriptors()) {
                MethodDescriptor md = (MethodDescriptor)next;
                Method m = md.getMethod(ejbDesc);
                if (!classAn.equals(ejbContext.getDeclaringClass(md)) || this.hasMethodPermissionsFromDD(md, ejbDesc)) continue;
                this.addMethodPermissions(rolesAllowedAn, ejbDesc, md);
            }
        }
    }

    private void addMethodPermissions(RolesAllowed rolesAllowedAn, EjbDescriptor ejbDesc, MethodDescriptor md) {
        for (String roleName : rolesAllowedAn.value()) {
            Role role = new Role(roleName);
            ejbDesc.getEjbBundleDescriptor().addRole(role);
            ejbDesc.addPermissionedMethod(new MethodPermission(role), md);
        }
    }

    @Override
    protected void processSecurityConstraint(Annotation authAnnotation, SecurityConstraint securityConstraint, WebComponentDescriptor webCompDesc) {
        WebBundleDescriptor webBundleDesc = webCompDesc.getWebBundleDescriptor();
        RolesAllowed rolesAllowedAn = (RolesAllowed)authAnnotation;
        AuthorizationConstraintImpl ac = new AuthorizationConstraintImpl();
        for (String roleName : rolesAllowedAn.value()) {
            Role role = new Role(roleName);
            webBundleDesc.addRole(role);
            ac.addSecurityRole(roleName);
        }
        securityConstraint.setAuthorizationConstraint(ac);
    }
}

