/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.container.util;

import com.sun.enterprise.config.serverbeans.EjbContainer;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.runtime.BeanCacheDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;
import com.sun.logging.LogDomains;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public class CacheProperties {
    protected static final Logger _logger = LogDomains.getLogger(CacheProperties.class, (String)"javax.enterprise.system.container.ejb");
    private int maxCacheSize;
    private int numberOfVictimsToSelect;
    private int cacheIdleTimeoutInSeconds;
    private int removalTimeoutInSeconds;
    private String victimSelectionPolicy;
    @Inject
    EjbContainer ejbContainer;

    public void init(EjbDescriptor desc) {
        BeanCacheDescriptor beanCacheDes = null;
        IASEjbExtraDescriptors iased = desc.getIASEjbExtraDescriptors();
        if (iased != null) {
            beanCacheDes = iased.getBeanCache();
        }
        this.loadProperties(this.ejbContainer, desc, beanCacheDes);
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public int getNumberOfVictimsToSelect() {
        return this.numberOfVictimsToSelect;
    }

    public int getCacheIdleTimeoutInSeconds() {
        return this.cacheIdleTimeoutInSeconds;
    }

    public int getRemovalTimeoutInSeconds() {
        return this.removalTimeoutInSeconds;
    }

    public String getVictimSelectionPolicy() {
        return this.victimSelectionPolicy;
    }

    public String getPassivationStorePath() {
        return this.ejbContainer.getSessionStore();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("maxSize: ").append(this.maxCacheSize).append("; victims: ").append(this.numberOfVictimsToSelect).append("; idleTimeout: ").append(this.cacheIdleTimeoutInSeconds).append("; removalTimeout: ").append(this.removalTimeoutInSeconds).append("; policy: ").append(this.victimSelectionPolicy);
        return sbuf.toString();
    }

    private void loadProperties(EjbContainer ejbContainer, EjbDescriptor ejbDesc, BeanCacheDescriptor beanCacheDes) {
        EjbSessionDescriptor sessionDesc;
        this.numberOfVictimsToSelect = new Integer(ejbContainer.getCacheResizeQuantity());
        this.maxCacheSize = new Integer(ejbContainer.getMaxCacheSize());
        this.cacheIdleTimeoutInSeconds = new Integer(ejbContainer.getCacheIdleTimeoutInSeconds());
        this.removalTimeoutInSeconds = new Integer(ejbContainer.getRemovalTimeoutInSeconds());
        this.victimSelectionPolicy = ejbContainer.getVictimSelectionPolicy();
        if (ejbDesc instanceof EjbSessionDescriptor && (sessionDesc = (EjbSessionDescriptor)ejbDesc).hasStatefulTimeout()) {
            long value = sessionDesc.getStatefulTimeoutValue();
            TimeUnit unit = sessionDesc.getStatefulTimeoutUnit();
            this.removalTimeoutInSeconds = (int)TimeUnit.SECONDS.convert(value, unit);
        }
        if (beanCacheDes != null) {
            int temp = 0;
            temp = beanCacheDes.getResizeQuantity();
            if (temp != -1) {
                this.numberOfVictimsToSelect = temp;
            }
            if ((temp = beanCacheDes.getMaxCacheSize()) != -1) {
                this.maxCacheSize = temp;
            }
            if ((temp = beanCacheDes.getCacheIdleTimeoutInSeconds()) != -1) {
                this.cacheIdleTimeoutInSeconds = temp;
            }
            if ((temp = beanCacheDes.getRemovalTimeoutInSeconds()) != -1) {
                this.removalTimeoutInSeconds = temp;
            }
            if (beanCacheDes.getVictimSelectionPolicy() != null) {
                this.victimSelectionPolicy = beanCacheDes.getVictimSelectionPolicy();
            }
        }
    }
}

