/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.embedded;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.ejb.spi.EJBContainerProvider;
import org.glassfish.api.embedded.ContainerBuilder;
import org.glassfish.api.embedded.EmbeddedDeployer;
import org.glassfish.api.embedded.Server;
import org.glassfish.ejb.embedded.EJBContainerImpl;
import org.glassfish.ejb.embedded.EjbBuilder;
import org.glassfish.ejb.embedded.EmbeddedEjbContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBContainerProviderImpl
implements EJBContainerProvider {
    private static final String GF_PROVIDER_NAME = EJBContainerProviderImpl.class.getName();
    private static final Logger _logger = LogDomains.getLogger(EjbContainerUtilImpl.class, (String)"javax.enterprise.system.container.ejb");
    private static final Object lock = new Object();
    private static EJBContainerImpl container;

    @Override
    public EJBContainer createEJBContainer(Map<?, ?> properties) throws EJBException {
        if (properties == null || properties.get("javax.ejb.embeddable.provider") == null || properties.get("javax.ejb.embeddable.provider").equals(GF_PROVIDER_NAME)) {
            this.init();
            if (container.isOpen()) {
                throw new EJBException(_logger.getResourceBundle().getString("ejb.embedded.exception_exists_container"));
            }
            try {
                HashSet<File> modules = new HashSet<File>();
                this.addEJBModules(modules, properties);
                if (modules.isEmpty()) {
                    _logger.log(Level.SEVERE, "No EJB modules found");
                }
                container.deploy(properties, modules);
                return container;
            }
            catch (Throwable t) {
                _logger.log(Level.SEVERE, "ejb.embedded.exception_instantiating", t);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = lock;
        synchronized (object) {
            if (container == null) {
                Server.Builder builder = new Server.Builder("GFEJBContainerProviderImpl");
                Server server = builder.build();
                EjbBuilder ejb = (EjbBuilder)server.createConfig(EjbBuilder.class);
                EmbeddedEjbContainer ejbContainer = (EmbeddedEjbContainer)server.addContainer((ContainerBuilder)ejb);
                EmbeddedDeployer deployer = server.getDeployer();
                container = new EJBContainerImpl(ejbContainer, deployer);
            }
        }
    }

    private void addEJBModules(Set<File> modules, Map<?, ?> properties) {
        Object obj = properties == null ? null : properties.get("javax.ejb.embeddable.modules");
        HashSet<File> expected = new HashSet<File>();
        if (obj != null) {
            Object[] arr;
            if (obj instanceof File) {
                expected.add(obj);
            } else if (obj instanceof String) {
                expected.add(new File(obj));
            } else if (obj instanceof File[]) {
                arr = obj;
                for (Object f : arr) {
                    expected.add((File)f);
                }
            } else if (obj instanceof String[]) {
                arr = obj;
                for (Object s : arr) {
                    expected.add(new File((String)s));
                }
            }
        }
        Set<File> files = this.getFromClassPath();
        boolean fromClassPath = true;
        if (files.isEmpty()) {
            files = expected;
            fromClassPath = false;
        }
        for (File f : files) {
            if (!f.exists()) continue;
            System.err.println("Found.... " + f.getName());
            if (fromClassPath && !expected.isEmpty() && !expected.contains(f)) continue;
            modules.add(f);
            System.err.println("...Added.... ");
        }
    }

    private Set<File> getFromClassPath() {
        HashSet<File> result = new HashSet<File>();
        return result;
    }
}

