/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.appserv.management.base.KitchenSink;
import com.sun.appserv.management.base.SystemStatus;
import com.sun.appserv.management.config.Enabled;
import com.sun.appserv.management.config.JDBCConnectionPoolConfig;
import com.sun.appserv.management.config.JDBCResourceConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.ResourcesConfig;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.component.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.AMXUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.TargetUtil;

public class JdbcTempHandler {
    private static final String DATA_SOURCE = "javax.sql.DataSource";
    private static final String XADATA_SOURCE = "javax.sql.XADataSource";
    private static final String CCDATA_SOURCE = "javax.sql.ConnectionPoolDataSource";
    private static final String JAVADB = "JavaDB";
    private static final String ORACLE = "Oracle";
    private static final String DERBY = "Derby";
    private static final String SYBASE = "Sybase";
    private static final String DB2 = "DB2";
    private static final String POINTBASE = "PointBase";
    private static final String POSTGRESQL = "PostgreSQL";
    private static final String INFORMIX = "Informix";
    private static final String CLOUDSCAPE = "Cloudscape";
    private static final String MSSQL = "Microsoft SQL Server";
    private static final String MYSQL = "MySQL";
    private static Map<String, String> dataSourceMap = new HashMap<String, String>();
    private static Map<String, String> XADataSourceMap = new HashMap<String, String>();
    private static Map<String, String> CCDataSourceMap = new HashMap<String, String>();
    private static List resTypeList = new ArrayList();
    private static List dbVendorList = new ArrayList();

    public static void getJdbcInfo(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        if (GuiUtil.isEmpty((String)jndiName)) {
            handlerCtx.setOutputValue("enabled", (Object)Boolean.TRUE);
            return;
        }
        JDBCResourceConfig jdbc = (JDBCResourceConfig)AMXRoot.getInstance().getResourcesConfig().getJDBCResourceConfigMap().get(jndiName);
        if (jdbc == null) {
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.NoSuchJDBCResource"));
        } else {
            handlerCtx.setOutputValue("poolName", (Object)jdbc.getPoolName());
            handlerCtx.setOutputValue("description", (Object)jdbc.getDescription());
            if (AMXRoot.getInstance().isEE()) {
                handlerCtx.setOutputValue("enabledString", (Object)TargetUtil.getEnabledStatus((Enabled)jdbc, (boolean)false));
            } else {
                handlerCtx.setOutputValue("enabled", (Object)TargetUtil.isResourceEnabled((Enabled)jdbc, (String)"server"));
            }
        }
    }

    public static void saveJdbc(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        String poolName = (String)handlerCtx.getInputValue("poolName");
        Boolean edit = (Boolean)handlerCtx.getInputValue("edit");
        JDBCResourceConfig jdbc = null;
        try {
            if (edit.booleanValue()) {
                jdbc = (JDBCResourceConfig)AMXRoot.getInstance().getResourcesConfig().getJDBCResourceConfigMap().get(jndiName);
                if (jdbc == null) {
                    GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.NoSuchJDBCResource"));
                    return;
                }
                jdbc.setPoolName(poolName);
                if (!AMXRoot.getInstance().isEE()) {
                    Boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
                    TargetUtil.setResourceEnabled((Enabled)jdbc, (String)"server", (boolean)enabled);
                }
                GuiUtil.prepareSuccessful((HandlerContext)handlerCtx);
            } else {
                HashMap<String, String> optionalMap = new HashMap<String, String>();
                optionalMap.put("enabled", "true");
                jdbc = AMXRoot.getInstance().getResourcesConfig().createJDBCResourceConfig(jndiName, poolName, optionalMap);
                TargetUtil.createNewTargets((HandlerContext)handlerCtx, (String)jndiName);
            }
            jdbc.setDescription((String)handlerCtx.getInputValue("description"));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getJdbcConnectionPools(HandlerContext handlerCtx) {
        Set keys = AMXRoot.getInstance().getResourcesConfig().getJDBCConnectionPoolConfigMap().keySet();
        handlerCtx.setOutputValue("jdbcConnectionPools", new ArrayList(keys));
    }

    public static void getJdbcConnectionPoolInfo(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        JDBCConnectionPoolConfig pool = (JDBCConnectionPoolConfig)AMXRoot.getInstance().getResourcesConfig().getJDBCConnectionPoolConfigMap().get(jndiName);
        if (pool == null) {
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.noSuchJDBCConnectionPool"));
        }
        handlerCtx.setOutputValue("datasourceClassname", (Object)pool.getDatasourceClassname());
        handlerCtx.setOutputValue("resType", (Object)pool.getResType());
        handlerCtx.setOutputValue("description", (Object)pool.getDescription());
        handlerCtx.setOutputValue("steadyPoolSize", (Object)pool.getSteadyPoolSize());
        handlerCtx.setOutputValue("maxPoolSize", (Object)pool.getMaxPoolSize());
        handlerCtx.setOutputValue("poolResizeQuantity", (Object)pool.getPoolResizeQuantity());
        handlerCtx.setOutputValue("idleTimeoutInSeconds", (Object)pool.getIdleTimeoutInSeconds());
        handlerCtx.setOutputValue("maxWaitTimeInMillis", (Object)pool.getMaxWaitTimeInMillis());
        handlerCtx.setOutputValue("isConnectionValidationRequired", (Object)pool.getIsConnectionValidationRequired());
        handlerCtx.setOutputValue("connectionValidationMethod", (Object)pool.getConnectionValidationMethod());
        handlerCtx.setOutputValue("validationTableName", (Object)pool.getValidationTableName());
        handlerCtx.setOutputValue("failAllConnections", (Object)pool.getFailAllConnections());
        handlerCtx.setOutputValue("allowNonComponentCallers", (Object)pool.getAllowNonComponentCallers());
        handlerCtx.setOutputValue("nonTransactionalConnections", (Object)pool.getNonTransactionalConnections());
        handlerCtx.setOutputValue("transactionIsolationLevel", (Object)pool.getTransactionIsolationLevel());
        handlerCtx.setOutputValue("isIsolationLevelGuaranteed", (Object)pool.getIsIsolationLevelGuaranteed());
    }

    public static void getJdbcConnectionPoolProperty(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        JDBCConnectionPoolConfig pool = (JDBCConnectionPoolConfig)AMXRoot.getInstance().getResourcesConfig().getJDBCConnectionPoolConfigMap().get(jndiName);
        if (pool == null) {
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.noSuchJDBCConnectionPool"));
        }
        handlerCtx.setOutputValue("properties", (Object)pool.getPropertyConfigMap());
    }

    public static void saveJdbcConnectionPool(HandlerContext handlerCtx) {
        try {
            String jndiName = (String)handlerCtx.getInputValue("jndiName");
            JDBCConnectionPoolConfig pool = (JDBCConnectionPoolConfig)AMXRoot.getInstance().getResourcesConfig().getJDBCConnectionPoolConfigMap().get(jndiName);
            if (pool == null) {
                GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.noSuchJDBCConnectionPool"));
                return;
            }
            pool.setDatasourceClassname((String)handlerCtx.getInputValue("datasourceClassname"));
            pool.setResType((String)handlerCtx.getInputValue("resType"));
            pool.setDescription((String)handlerCtx.getInputValue("description"));
            pool.setMaxPoolSize((String)handlerCtx.getInputValue("maxPoolSize"));
            pool.setSteadyPoolSize((String)handlerCtx.getInputValue("steadyPoolSize"));
            pool.setPoolResizeQuantity((String)handlerCtx.getInputValue("poolResizeQuantity"));
            pool.setIdleTimeoutInSeconds((String)handlerCtx.getInputValue("idleTimeoutInSeconds"));
            pool.setMaxWaitTimeInMillis((String)handlerCtx.getInputValue("maxWaitTimeInMillis"));
            pool.setIsConnectionValidationRequired((String)handlerCtx.getInputValue("isConnectionValidationRequired"));
            String method = (String)handlerCtx.getInputValue("connectionValidationMethod");
            pool.setConnectionValidationMethod(method);
            if ("table".equals(method)) {
                String table = (String)handlerCtx.getInputValue("validationTableName");
                if (!GuiUtil.isEmpty((String)table)) {
                    pool.setValidationTableName(table);
                }
            } else {
                pool.setValidationTableName("");
            }
            pool.setFailAllConnections((String)handlerCtx.getInputValue("failAllConnections"));
            pool.setAllowNonComponentCallers((String)handlerCtx.getInputValue("allowNonComponentCallers"));
            pool.setNonTransactionalConnections((String)handlerCtx.getInputValue("nonTransactionalConnections"));
            pool.setTransactionIsolationLevel((String)handlerCtx.getInputValue("transactionIsolationLevel"));
            pool.setIsIsolationLevelGuaranteed((String)handlerCtx.getInputValue("isIsolationLevelGuaranteed"));
            GuiUtil.prepareSuccessful((HandlerContext)handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void saveJdbcConnectionPoolProperty(HandlerContext handlerCtx) {
        try {
            String jndiName = (String)handlerCtx.getInputValue("jndiName");
            JDBCConnectionPoolConfig pool = (JDBCConnectionPoolConfig)AMXRoot.getInstance().getResourcesConfig().getJDBCConnectionPoolConfigMap().get(jndiName);
            if (pool == null) {
                GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.noSuchJDBCConnectionPool"));
                return;
            }
            AMXUtil.updateProperties((PropertiesAccess)pool, (Map)((Map)handlerCtx.getInputValue("newProps")));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getJdbcConnectionPoolDefaultInfo(HandlerContext handlerCtx) {
        Map defaultMap = AMXRoot.getInstance().getResourcesConfig().getDefaultValues("X-JDBCConnectionPoolConfig", true);
        handlerCtx.setOutputValue("steadyPoolSize", defaultMap.get("SteadyPoolSize"));
        handlerCtx.setOutputValue("maxPoolSize", defaultMap.get("MaxPoolSize"));
        handlerCtx.setOutputValue("poolResizeQuantity", defaultMap.get("PoolResizeQuantity"));
        handlerCtx.setOutputValue("idleTimeoutInSeconds", defaultMap.get("IdleTimeoutInSeconds"));
        handlerCtx.setOutputValue("maxWaitTimeInMillis", defaultMap.get("MaxWaitTimeInMillis"));
        handlerCtx.setOutputValue("isConnectionValidationRequired", (Object)JdbcTempHandler.StringToBoolean(defaultMap.get("IsConnectionValidationRequired")));
        handlerCtx.setOutputValue("connectionValidationMethod", defaultMap.get("ConnectionValidationMethod"));
        handlerCtx.setOutputValue("validationTableName", defaultMap.get("ValidationTableName"));
        handlerCtx.setOutputValue("failAllConnections", (Object)JdbcTempHandler.StringToBoolean(defaultMap.get("FailAllConnections")));
        handlerCtx.setOutputValue("allowNonComponentCallers", (Object)JdbcTempHandler.StringToBoolean(defaultMap.get("AllowNonComponentCallers")));
        handlerCtx.setOutputValue("nonTransactionalConnections", (Object)JdbcTempHandler.StringToBoolean(defaultMap.get("NonTransactionalConnections")));
        handlerCtx.setOutputValue("transactionIsolationLevel", defaultMap.get("TransactionIsolationLevel"));
        handlerCtx.setOutputValue("isIsolationLevelGuaranteed", (Object)JdbcTempHandler.StringToBoolean(defaultMap.get("IsIsolationLevelGuaranteed")));
    }

    public static void getPoolAdvanceInfo(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        JDBCConnectionPoolConfig pool = (JDBCConnectionPoolConfig)AMXRoot.getInstance().getResourcesConfig().getJDBCConnectionPoolConfigMap().get(jndiName);
        if (pool == null) {
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.noSuchJDBCConnectionPool"));
            return;
        }
        HashMap<String, Object> advance = new HashMap<String, Object>();
        advance.put("wrapJDBCObjects", JdbcTempHandler.StringToBoolean(pool.getWrapJDBCObjects()));
        advance.put("statementTimeoutInSeconds", pool.getStatementTimeoutInSeconds());
        advance.put("validateAtMostOncePeriodInSeconds", pool.getValidateAtMostOncePeriodInSeconds());
        advance.put("connectionLeakTimeoutInSeconds", pool.getConnectionLeakTimeoutInSeconds());
        advance.put("connectionLeakReclaim", JdbcTempHandler.StringToBoolean(pool.getConnectionLeakReclaim()));
        advance.put("connectionCreationRetryAttempts", pool.getConnectionCreationRetryAttempts());
        advance.put("connectionCreationRetryIntervalInSeconds", pool.getConnectionCreationRetryIntervalInSeconds());
        advance.put("lazyConnectionEnlistment", JdbcTempHandler.StringToBoolean(pool.getLazyConnectionEnlistment()));
        advance.put("lazyConnectionAssociation", JdbcTempHandler.StringToBoolean(pool.getLazyConnectionAssociation()));
        advance.put("associateWithThread", JdbcTempHandler.StringToBoolean(pool.getAssociateWithThread()));
        advance.put("matchConnections", JdbcTempHandler.StringToBoolean(pool.getMatchConnections()));
        advance.put("maxConnectionUsageCount", pool.getMaxConnectionUsageCount());
        handlerCtx.setOutputValue("advance", advance);
    }

    public static void getPoolAdvanceDefaultInfo(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        JDBCConnectionPoolConfig pool = (JDBCConnectionPoolConfig)AMXRoot.getInstance().getResourcesConfig().getJDBCConnectionPoolConfigMap().get(jndiName);
        if (pool == null) {
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.noSuchJDBCConnectionPool"));
            return;
        }
        HashMap<String, Boolean> advance = new HashMap<String, Boolean>();
        Map defaultMap = AMXRoot.getInstance().getResourcesConfig().getDefaultValues("X-JDBCConnectionPoolConfig", true);
        advance.put("wrapJDBCObjects", JdbcTempHandler.StringToBoolean(defaultMap.get("WrapJdbcObjects")));
        advance.put("statementTimeoutInSeconds", (Boolean)defaultMap.get("StatementTimeoutInSeconds"));
        advance.put("validateAtMostOncePeriodInSeconds", (Boolean)defaultMap.get("ValidateAtmostOncePeriodInSeconds"));
        advance.put("connectionLeakTimeoutInSeconds", (Boolean)defaultMap.get("ConnectionLeakTimeoutInSeconds"));
        advance.put("connectionLeakReclaim", JdbcTempHandler.StringToBoolean(defaultMap.get("ConnectionLeakReclaim")));
        advance.put("connectionCreationRetryAttempts", (Boolean)defaultMap.get("ConnectionCreationRetryAttempts"));
        advance.put("connectionCreationRetryIntervalInSeconds", (Boolean)defaultMap.get("ConnectionCreationRetryIntervalInSeconds"));
        advance.put("lazyConnectionEnlistment", JdbcTempHandler.StringToBoolean(defaultMap.get("LazyConnectionEnlistment")));
        advance.put("lazyConnectionAssociation", JdbcTempHandler.StringToBoolean(defaultMap.get("LazyConnectionAssociation")));
        advance.put("associateWithThread", JdbcTempHandler.StringToBoolean(defaultMap.get("AssociateWithThread")));
        advance.put("matchConnections", JdbcTempHandler.StringToBoolean(defaultMap.get("MatchConnections")));
        advance.put("maxConnectionUsageCount", (Boolean)defaultMap.get("MaxConnectionUsageCount"));
        handlerCtx.setOutputValue("advance", advance);
    }

    public static void savePoolAdvanceInfo(HandlerContext handlerCtx) {
        try {
            String jndiName = (String)handlerCtx.getInputValue("jndiName");
            Map advance = (Map)handlerCtx.getInputValue("advance");
            JDBCConnectionPoolConfig pool = (JDBCConnectionPoolConfig)AMXRoot.getInstance().getResourcesConfig().getJDBCConnectionPoolConfigMap().get(jndiName);
            if (pool == null) {
                GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.noSuchJDBCConnectionPool"));
                return;
            }
            pool.setWrapJDBCObjects(JdbcTempHandler.BooleanToString(advance.get("wrapJDBCObjects")));
            pool.setStatementTimeoutInSeconds((String)advance.get("statementTimeoutInSeconds"));
            pool.setValidateAtMostOncePeriodInSeconds((String)advance.get("validateAtMostOncePeriodInSeconds"));
            pool.setConnectionLeakTimeoutInSeconds((String)advance.get("connectionLeakTimeoutInSeconds"));
            pool.setConnectionLeakReclaim(JdbcTempHandler.BooleanToString(advance.get("connectionLeakReclaim")));
            pool.setConnectionCreationRetryAttempts((String)advance.get("connectionCreationRetryAttempts"));
            pool.setConnectionCreationRetryIntervalInSeconds((String)advance.get("connectionCreationRetryIntervalInSeconds"));
            pool.setLazyConnectionEnlistment(JdbcTempHandler.BooleanToString(advance.get("lazyConnectionEnlistment")));
            pool.setLazyConnectionAssociation(JdbcTempHandler.BooleanToString(advance.get("lazyConnectionAssociation")));
            pool.setAssociateWithThread(JdbcTempHandler.BooleanToString(advance.get("associateWithThread")));
            pool.setMatchConnections(JdbcTempHandler.BooleanToString(advance.get("matchConnections")));
            pool.setMaxConnectionUsageCount((String)advance.get("maxConnectionUsageCount"));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    private static String BooleanToString(Object test) {
        if (test == null) {
            return Boolean.FALSE.toString();
        }
        return test.toString();
    }

    private static Boolean StringToBoolean(Object test) {
        if (test == null) {
            return false;
        }
        if (test instanceof String) {
            return Boolean.valueOf((String)test);
        }
        if (test instanceof Boolean) {
            return (Boolean)test;
        }
        return false;
    }

    public static void pingJdbcConnectionPool(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        JDBCConnectionPoolConfig pool = (JDBCConnectionPoolConfig)AMXRoot.getInstance().getResourcesConfig().getJDBCConnectionPoolConfigMap().get(jndiName);
        try {
            SystemStatus ss = AMXRoot.getInstance().getDomainRoot().getSystemStatus();
            Map statusMap = ss.pingJDBCConnectionPool(jndiName);
            if (((Boolean)statusMap.get("PingSucceededKey")).booleanValue()) {
                GuiUtil.prepareAlert((HandlerContext)handlerCtx, (String)"success", (String)GuiUtil.getMessage((String)"msg.PingSucceed"), null);
            } else {
                GuiUtil.prepareAlert((HandlerContext)handlerCtx, (String)"error", (String)GuiUtil.getMessage((String)"msg.Error"), (String)statusMap.get("MessageKey").toString());
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getJDBCPoolWizard(HandlerContext handlerCtx) {
        Boolean fromStep2 = (Boolean)handlerCtx.getInputValue("fromStep2");
        if (fromStep2 == null || !fromStep2.booleanValue()) {
            Map defaultMap = AMXRoot.getInstance().getResourcesConfig().getDefaultValues("X-JDBCConnectionPoolConfig", true);
            HashMap attrMap = new HashMap();
            attrMap.put("SteadyPoolSize", defaultMap.get("SteadyPoolSize"));
            attrMap.put("MaxPoolSize", defaultMap.get("MaxPoolSize"));
            attrMap.put("MaxWaitTimeInMillis", defaultMap.get("MaxWaitTimeInMillis"));
            attrMap.put("PoolResizeQuantity", defaultMap.get("PoolResizeQuantity"));
            attrMap.put("IdleTimeoutInSeconds", defaultMap.get("IdleTimeoutInSeconds"));
            attrMap.put("IsIsolationLevelGuaranteed", defaultMap.get("IsIsolationLevelGuaranteed"));
            attrMap.put("IsConnectionValidationRequired", defaultMap.get("IsConnectionValidationRequired"));
            attrMap.put("ConnectionValidationMethod", defaultMap.get("ConnectionValidationMethod"));
            attrMap.put("FailAllConnections", defaultMap.get("FailAllConnections"));
            attrMap.put("NonTransactionalConnections", defaultMap.get("NonTransactionalConnections"));
            attrMap.put("AllowNonComponentCallers", defaultMap.get("AllowNonComponentCallers"));
            Map sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
            sessionMap.put("wizardPool", attrMap);
            sessionMap.put("wizardPoolExtra", new HashMap());
            sessionMap.put("wizardPoolProperties", new HashMap());
        }
        handlerCtx.setOutputValue("ResTypeList", (Object)resTypeList);
        handlerCtx.setOutputValue("DBVendorList", (Object)dbVendorList);
    }

    public static void updateJDBCPoolWizard(HandlerContext handlerCtx) {
        Map pool = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPool");
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        String resType = (String)pool.get("ResType");
        String dbVendor = (String)extra.get("DBVendor");
        String previousResType = (String)extra.get("PreviousResType");
        String previousDB = (String)extra.get("PreviousDB");
        if (!resType.equals(previousResType) || !dbVendor.equals(previousDB) || GuiUtil.isEmpty((String)((String)extra.get("DatasourceClassname")))) {
            if (!GuiUtil.isEmpty((String)resType) && !GuiUtil.isEmpty((String)dbVendor)) {
                String datasourceClassName = "";
                if (resType.equals(DATA_SOURCE)) {
                    datasourceClassName = dataSourceMap.get(dbVendor);
                } else if (resType.equals(XADATA_SOURCE)) {
                    datasourceClassName = XADataSourceMap.get(dbVendor);
                } else if (resType.equals(CCDATA_SOURCE)) {
                    datasourceClassName = CCDataSourceMap.get(dbVendor);
                }
                if (datasourceClassName == null) {
                    datasourceClassName = "";
                }
                extra.put("DatasourceClassname", datasourceClassName);
                KitchenSink ks = AMXRoot.getInstance().getDomainRoot().getKitchenSink();
                Map result = ks.getConnectionDefinitionPropertiesAndDefaults(datasourceClassName);
                Map propsMap = (Map)result.get("PropertyMapKey");
                if (propsMap == null) {
                    System.out.println("!!!!!! JdbcHandlers:updateJDBCPoolWizard(), error getting property map");
                    System.out.println(result.get("ReasonFailedKey"));
                }
                handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", propsMap);
            }
            extra.put("PreviousResType", resType);
            extra.put("PreviousDB", dbVendor);
        }
    }

    public static void createJdbcConnectionPool(HandlerContext handlerCtx) {
        try {
            Map pool = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPool");
            Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
            Map properties = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolProperties");
            String name = (String)extra.get("name");
            String datasourceClassname = (String)extra.get("DatasourceClassname");
            String method = (String)pool.get("ConnectionValidationMethod");
            if ("table".equals(method)) {
                String table = (String)pool.get("ValidationTableName");
                if (!GuiUtil.isEmpty((String)table)) {
                    pool.put("ValidationTableName", table);
                }
            } else {
                pool.remove("ValidationTableName");
            }
            Map allOptions = new HashMap();
            allOptions.put("res-type", pool.get("ResType"));
            allOptions.put("connection-validation-method", pool.get("ConnectionValidationMethod"));
            allOptions.put("transaction-isolation-level", pool.get("TransactionIsolationLevel"));
            allOptions.put("steady-pool-size", pool.get("SteadyPoolSize"));
            allOptions.put("max-pool-size", pool.get("MaxPoolSize"));
            allOptions.put("max-wait-time-in-millis", pool.get("MaxWaitTimeInMillis"));
            allOptions.put("pool-resize-quantity", pool.get("PoolResizeQuantity"));
            allOptions.put("idle-timeout-in-seconds", pool.get("IdleTimeoutInSeconds"));
            allOptions.put("is-isolation-level-guaranteed", pool.get("IsIsolationLevelGuaranteed"));
            allOptions.put("fail-all-connections", pool.get("FailAllConnections"));
            allOptions.put("non-transactional-connections", pool.get("NonTransactionalConnections"));
            allOptions.put("allow-non-component-callers", pool.get("AllowNonComponentCallers"));
            allOptions.put("is-connection-validation-required", pool.get("IsConnectionValidationRequired"));
            allOptions.put("validation-table-name", pool.get("ValidationTableName"));
            allOptions = AMXUtil.convertToPropertiesOptionMap((Map)properties, allOptions);
            JDBCConnectionPoolConfig newPool = AMXRoot.getInstance().getResourcesConfig().createJDBCConnectionPoolConfig(name, datasourceClassname, allOptions);
            newPool.setDescription((String)extra.get("Description"));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getJDBCConnectionPoolMaps(HandlerContext handlerCtx) {
        List selectedList = (List)handlerCtx.getInputValue("selectedRows");
        boolean hasOrig = selectedList != null && selectedList.size() != 0;
        ArrayList result = new ArrayList();
        Iterator iter = AMXRoot.getInstance().getResourcesConfig().getJDBCConnectionPoolConfigMap().values().iterator();
        if (iter != null) {
            while (iter.hasNext()) {
                try {
                    JDBCConnectionPoolConfig res = (JDBCConnectionPoolConfig)iter.next();
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    oneRow.put("name", res.getName());
                    oneRow.put("selected", hasOrig ? GuiUtil.isSelected((String)res.getName(), (List)selectedList) : false);
                    oneRow.put("resInfo", GuiUtil.checkEmpty((String)res.getResType()));
                    oneRow.put("extraInfo", res.getDatasourceClassname());
                    oneRow.put("description", GuiUtil.checkEmpty((String)res.getDescription()));
                    result.add(oneRow);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void setDisableConnectionPoolTableField(HandlerContext handlerCtx) {
        String methodValue = (String)handlerCtx.getInputValue("methodValue");
        Field tableField = (Field)handlerCtx.getInputValue("tableField");
        if ("table".equals(methodValue)) {
            tableField.setDisabled(false);
        } else {
            tableField.setDisabled(true);
        }
    }

    public static void deleteResource(HandlerContext handlerCtx) {
        String target = "server";
        ResourcesConfig resourcesConfig = AMXRoot.getInstance().getResourcesConfig();
        List obj = (List)handlerCtx.getInputValue("selectedRows");
        String resourceType = (String)handlerCtx.getInputValue("resourceType");
        Boolean isJmsConnectionFactory = (Boolean)handlerCtx.getInputValue("isJmsConnectionFactory");
        boolean isJms = isJmsConnectionFactory == null ? false : isJmsConnectionFactory;
        List selectedRows = obj;
        try {
            for (Map oneRow : selectedRows) {
                String resourceName = (String)oneRow.get("name");
                if ("jdbcResource".equals(resourceType)) {
                    resourcesConfig.removeJDBCResourceConfig(resourceName);
                    continue;
                }
                if (!"jdbcConnectionPool".equals(resourceType)) continue;
                Iterator iter = resourcesConfig.getJDBCResourceConfigMap().values().iterator();
                if (iter != null) {
                    while (iter.hasNext()) {
                        JDBCResourceConfig jdbc = (JDBCResourceConfig)iter.next();
                        if (!jdbc.getPoolName().equals(resourceName)) continue;
                        resourcesConfig.removeJDBCResourceConfig(jdbc.getName());
                    }
                }
                resourcesConfig.removeJDBCConnectionPoolConfig(resourceName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GuiUtil.prepareAlert((HandlerContext)handlerCtx, (String)"error", (String)GuiUtil.getMessage((String)"msg.Error"), (String)ex.getMessage());
        }
    }

    static {
        dataSourceMap.put(ORACLE, "oracle.jdbc.pool.OracleDataSource");
        dataSourceMap.put(DERBY, "org.apache.derby.jdbc.ClientDataSource");
        dataSourceMap.put(JAVADB, "org.apache.derby.jdbc.ClientDataSource");
        dataSourceMap.put(DB2, "com.ibm.db2.jdbc.DB2DataSource");
        dataSourceMap.put(MSSQL, "com.ddtek.jdbcx.sqlserver.SQLServerDataSource");
        dataSourceMap.put(SYBASE, "com.sybase.jdbc2.jdbc.SybDataSource");
        dataSourceMap.put(POINTBASE, "com.pointbase.jdbc.jdbcDataSource");
        dataSourceMap.put(CLOUDSCAPE, "com.cloudscape.core.BasicDataSource");
        dataSourceMap.put(INFORMIX, "com.informix.jdbcx.IfxDataSource");
        dataSourceMap.put(MYSQL, "com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
        dataSourceMap.put(POSTGRESQL, "org.postgresql.ds.PGSimpleDataSource");
        XADataSourceMap.put(ORACLE, "oracle.jdbc.xa.client.OracleXADataSource");
        XADataSourceMap.put(DERBY, "org.apache.derby.jdbc.ClientXADataSource");
        XADataSourceMap.put(JAVADB, "org.apache.derby.jdbc.ClientXADataSource");
        XADataSourceMap.put(DB2, "com.ibm.db2.jdbc.DB2XADataSource");
        XADataSourceMap.put(MSSQL, "com.ddtek.jdbcx.sqlserver.SQLServerDataSource");
        XADataSourceMap.put(SYBASE, "com.sybase.jdbc2.jdbc.SybXADataSource");
        XADataSourceMap.put(POINTBASE, "com.pointbase.xa.xaDataSource");
        XADataSourceMap.put(CLOUDSCAPE, "com.cloudscape.core.XADataSource");
        XADataSourceMap.put(INFORMIX, "com.informix.jdbcx.IfxXADataSource");
        XADataSourceMap.put(MYSQL, "com.mysql.jdbc.jdbc2.optional.MysqlXADataSource");
        XADataSourceMap.put(POSTGRESQL, "org.postgresql.xa.PGXADataSource");
        CCDataSourceMap.put(ORACLE, "oracle.jdbc.pool.OracleConnectionPoolDataSource");
        CCDataSourceMap.put(DB2, "com.ibm.db2.jdbc.DB2ConnectionPoolDataSource");
        CCDataSourceMap.put(SYBASE, "com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource");
        CCDataSourceMap.put(DERBY, "org.apache.derby.jdbc.ClientConnectionPoolDataSource");
        CCDataSourceMap.put(JAVADB, "org.apache.derby.jdbc.ClientConnectionPoolDataSource");
        CCDataSourceMap.put(POSTGRESQL, "org.postgresql.ds.PGConnectionPoolDataSource");
        CCDataSourceMap.put(MYSQL, "com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource");
        resTypeList.add("");
        resTypeList.add(DATA_SOURCE);
        resTypeList.add(XADATA_SOURCE);
        resTypeList.add(CCDATA_SOURCE);
        dbVendorList.add("");
        dbVendorList.add(JAVADB);
        dbVendorList.add(ORACLE);
        dbVendorList.add(DERBY);
        dbVendorList.add(SYBASE);
        dbVendorList.add(DB2);
        dbVendorList.add(POINTBASE);
        dbVendorList.add(POSTGRESQL);
        dbVendorList.add(INFORMIX);
        dbVendorList.add(CLOUDSCAPE);
        dbVendorList.add(MSSQL);
        dbVendorList.add(MYSQL);
    }
}

