/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRegistration;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.StringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletRegistrationImpl
implements ServletRegistration {
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected StandardWrapper wrapper;
    protected StandardContext ctx;

    ServletRegistrationImpl(StandardWrapper wrapper, StandardContext ctx) {
        this.wrapper = wrapper;
        this.ctx = ctx;
    }

    @Override
    public String getName() {
        return this.wrapper.getName();
    }

    @Override
    public String getClassName() {
        return this.wrapper.getServletClassName();
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("servletRegistration.alreadyInitialized", (Object)"init parameter", (Object)this.wrapper.getName(), this.ctx.getName()));
        }
        return this.wrapper.setInitParameter(name, value, false);
    }

    @Override
    public String getInitParameter(String name) {
        return this.wrapper.getInitParameter(name);
    }

    @Override
    public Set<String> setInitParameters(Map<String, String> initParameters) {
        return this.wrapper.setInitParameters(initParameters);
    }

    @Override
    public Map<String, String> getInitParameters() {
        return this.wrapper.getInitParameters();
    }

    @Override
    public Set<String> addMapping(String ... urlPatterns) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("servletRegistration.alreadyInitialized", (Object)"mapping", (Object)this.wrapper.getName(), this.ctx.getName()));
        }
        if (urlPatterns == null || urlPatterns.length == 0) {
            throw new IllegalArgumentException(sm.getString("servletRegistration.mappingWithNullOrEmptyUrlPatterns", (Object)this.wrapper.getName(), this.ctx.getName()));
        }
        return this.ctx.addServletMapping(this.wrapper.getName(), urlPatterns);
    }

    @Override
    public Iterable<String> getMappings() {
        return this.wrapper.getMappings();
    }
}

