/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;

public class JPQLException
extends EclipseLinkException {
    public static final int recognitionException = 8001;
    public static final int generalParsingException = 8002;
    public static final int classNotFoundException = 8003;
    public static final int aliasResolutionException = 8004;
    public static final int resolutionClassNotFoundException = 8005;
    public static final int missingDescriptorException = 8006;
    public static final int missingMappingException = 8007;
    public static final int invalidContextKeyException = 8008;
    public static final int expressionNotSupported = 8009;
    public static final int generalParsingException2 = 8010;
    public static final int invalidCollectionMemberDecl = 8011;
    public static final int notYetImplemented = 8012;
    public static final int constructorClassNotFound = 8013;
    public static final int invalidSizeArgument = 8014;
    public static final int invalidEnumLiteral = 8015;
    public static final int invalidSelectForGroupByQuery = 8016;
    public static final int invalidHavingExpression = 8017;
    public static final int invalidMultipleUseOfSameParameter = 8018;
    public static final int multipleVariableDeclaration = 8019;
    public static final int invalidFunctionArgument = 8020;
    public static final int expectedOrderableOrderByItem = 8021;
    public static final int invalidExpressionArgument = 8022;
    public static final int syntaxError = 8023;
    public static final int syntaxErrorAt = 8024;
    public static final int unexpectedToken = 8025;
    public static final int unexpectedChar = 8026;
    public static final int expectedCharFound = 8027;
    public static final int unexpectedEOF = 8028;
    public static final int invalidNavigation = 8029;
    public static final int unknownAttribute = 8030;
    public static final int unsupportJoinArgument = 8031;
    public static final int invalidSetClauseTarget = 8032;
    public static final int invalidSetClauseNavigation = 8033;
    public static final int entityTypeNotFound = 8034;
    public static final int invalidEnumEqualExpression = 8035;
    public static final int invalidCollectionNavigation = 8036;
    public static final int entityTypeNotFound2 = 8037;
    public static final int resolutionClassNotFoundException2 = 8038;
    public static final int variableCannotHaveMapKey = 8039;
    public Collection internalExceptions = null;

    protected JPQLException() {
    }

    protected JPQLException(String theMessage) {
        super(theMessage);
    }

    protected JPQLException(String message, Exception internalException) {
        super(message, internalException);
    }

    protected JPQLException(String message, Exception internalException, int theErrorCode) {
        this(message, internalException);
        this.setErrorCode(theErrorCode);
    }

    public static JPQLException recognitionException(String theEjbql, String theMessage) {
        Object[] args = new Object[]{theEjbql, theMessage};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8001, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8001);
        return exception;
    }

    public static JPQLException generalParsingException(String theEjbql, Exception theException) {
        Object[] args = new Object[]{theEjbql, theException.getMessage()};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8002, args);
        JPQLException exception = new JPQLException(message, theException, 8002);
        exception.setErrorCode(8002);
        return exception;
    }

    public static JPQLException generalParsingException(String theEjbql) {
        Object[] args = new Object[]{theEjbql};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8010, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8002);
        return exception;
    }

    public static JPQLException classNotFoundException(String theClassName, String theMessage, Exception theException) {
        Object[] args = new Object[]{theClassName, theMessage};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8003, args);
        JPQLException exception = new JPQLException(message, theException, 8003);
        exception.setErrorCode(8003);
        return exception;
    }

    public static JPQLException resolutionClassNotFoundException(String query, String theClassName) {
        Object[] args = new Object[]{query, theClassName};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8005, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8005);
        return exception;
    }

    public static JPQLException resolutionClassNotFoundException2(String query, int line, int column, String theClassName) {
        Object[] args = new Object[]{query, line, column, theClassName};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8038, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8038);
        return exception;
    }

    public static JPQLException missingDescriptorException(String query, String theClassName) {
        Object[] args = new Object[]{query, theClassName};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8006, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8006);
        return exception;
    }

    public static JPQLException missingMappingException(String query, String theAttributeName) {
        Object[] args = new Object[]{query, theAttributeName};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8007, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8007);
        return exception;
    }

    public static JPQLException aliasResolutionException(String query, int line, int column, String theAlias) {
        Object[] args = new Object[]{query, line, column, theAlias};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8004, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8004);
        return exception;
    }

    public static JPQLException invalidContextKeyException(String query, String theKey) {
        Object[] args = new Object[]{query, theKey};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8008, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8008);
        return exception;
    }

    public static JPQLException expressionNotSupported(String query, String unsupportedExpression) {
        Object[] args = new Object[]{query, unsupportedExpression};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8009, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8009);
        return exception;
    }

    public static JPQLException invalidCollectionMemberDecl(String query, int line, int column, String attributeName) {
        Object[] args = new Object[]{query, line, column, attributeName};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8011, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8011);
        return exception;
    }

    public static JPQLException notYetImplemented(String query, String detail) {
        Object[] args = new Object[]{query, detail};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8012, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8012);
        return exception;
    }

    public static JPQLException constructorClassNotFound(String query, int line, int column, String className) {
        Object[] args = new Object[]{query, line, column, className};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8013, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8013);
        return exception;
    }

    public static JPQLException invalidSizeArgument(String query, int line, int column, String attributeName) {
        Object[] args = new Object[]{query, line, column, attributeName};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8014, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8014);
        return exception;
    }

    public static JPQLException invalidEnumLiteral(String query, int line, int column, String enumType, String literal) {
        Object[] args = new Object[]{query, line, column, enumType, literal};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8015, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8015);
        return exception;
    }

    public static JPQLException invalidSelectForGroupByQuery(String query, int line, int column, String select, String groupBy) {
        Object[] args = new Object[]{query, line, column, select, groupBy};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8016, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8016);
        return exception;
    }

    public static JPQLException invalidHavingExpression(String query, int line, int column, String having, String groupBy) {
        Object[] args = new Object[]{query, line, column, having, groupBy};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8017, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8017);
        return exception;
    }

    public static JPQLException invalidMultipleUseOfSameParameter(String query, int line, int column, String parameter, String oldType, String newType) {
        Object[] args = new Object[]{query, line, column, parameter, oldType, newType};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8018, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8018);
        return exception;
    }

    public static JPQLException multipleVariableDeclaration(String query, int line, int column, String variable, String oldDecl) {
        Object[] args = new Object[]{query, line, column, variable, oldDecl};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8019, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8019);
        return exception;
    }

    public static JPQLException invalidFunctionArgument(String query, int line, int column, String functionName, String attributeName, String type) {
        Object[] args = new Object[]{query, line, column, functionName, attributeName, type};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8020, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8020);
        return exception;
    }

    public static JPQLException invalidExpressionArgument(String query, int line, int column, String expression, String attributeName, String type) {
        Object[] args = new Object[]{query, line, column, expression, attributeName, type};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8022, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8022);
        return exception;
    }

    public static JPQLException unsupportJoinArgument(String query, int line, int column, String join, String type) {
        Object[] args = new Object[]{query, line, column, join, type};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8031, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8031);
        return exception;
    }

    public static JPQLException expectedOrderableOrderByItem(String query, int line, int column, String item, String type) {
        Object[] args = new Object[]{query, line, column, item, type};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8021, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8021);
        return exception;
    }

    public static JPQLException syntaxError(String query, Exception ex) {
        Object[] args = new Object[]{query};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8023, args);
        JPQLException exception = new JPQLException(message, ex);
        exception.setErrorCode(8023);
        return exception;
    }

    public static JPQLException syntaxErrorAt(String query, int line, int column, String token, Exception ex) {
        Object[] args = new Object[]{query, line, column, token};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8024, args);
        JPQLException exception = new JPQLException(message, ex);
        exception.setErrorCode(8024);
        return exception;
    }

    public static JPQLException unexpectedToken(String query, int line, int column, String token, Exception ex) {
        Object[] args = new Object[]{query, line, column, token};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8025, args);
        JPQLException exception = new JPQLException(message, ex);
        exception.setErrorCode(8025);
        return exception;
    }

    public static JPQLException unexpectedChar(String query, int line, int column, String unexpected, Exception ex) {
        Object[] args = new Object[]{query, line, column, unexpected};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8026, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8026);
        return exception;
    }

    public static JPQLException expectedCharFound(String query, int line, int column, String expected, String found, Exception ex) {
        Object[] args = new Object[]{query, line, column, expected, found};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8027, args);
        JPQLException exception = new JPQLException(message, ex);
        exception.setErrorCode(8027);
        return exception;
    }

    public static JPQLException unexpectedEOF(String query, int line, int column, Exception ex) {
        Object[] args = new Object[]{query, line, column};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8028, args);
        JPQLException exception = new JPQLException(message, ex);
        exception.setErrorCode(8028);
        return exception;
    }

    public static JPQLException invalidNavigation(String query, int line, int column, String expr, String lhs, String type) {
        Object[] args = new Object[]{query, line, column, expr, lhs, type};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8029, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8029);
        return exception;
    }

    public static JPQLException invalidCollectionNavigation(String query, int line, int column, String expr, String attribute) {
        Object[] args = new Object[]{query, line, column, expr, attribute};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8036, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8036);
        return exception;
    }

    public static JPQLException invalidSetClauseTarget(String query, int line, int column, String expr, String attribute) {
        Object[] args = new Object[]{query, line, column, attribute, expr};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8032, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8032);
        return exception;
    }

    public static JPQLException invalidSetClauseNavigation(String query, int line, int column, String expr, String relationship) {
        Object[] args = new Object[]{query, line, column, expr, relationship};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8033, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8033);
        return exception;
    }

    public static JPQLException unknownAttribute(String query, int line, int column, String attribute, String type) {
        Object[] args = new Object[]{query, line, column, attribute, type};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8030, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8030);
        return exception;
    }

    public static JPQLException invalidEnumEqualExpression(String query, int line, int column, String enumType, String type) {
        Object[] args = new Object[]{query, line, column, enumType, type};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8035, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8035);
        return exception;
    }

    public static JPQLException entityTypeNotFound(String query, String type) {
        Object[] args = new Object[]{query, type};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8034, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8034);
        return exception;
    }

    public static JPQLException entityTypeNotFound2(String query, int line, int column, String type) {
        Object[] args = new Object[]{query, line, column, type};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8037, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8037);
        return exception;
    }

    public static JPQLException variableCannotHaveMapKey(String query, int line, int column, String name) {
        Object[] args = new Object[]{query, line, column, name};
        String message = ExceptionMessageGenerator.buildMessage(JPQLException.class, 8039, args);
        JPQLException exception = new JPQLException(message);
        exception.setErrorCode(8039);
        return exception;
    }

    public Object addInternalException(Object theException) {
        this.getInternalExceptions().add(theException);
        return theException;
    }

    public boolean hasInternalExceptions() {
        return !this.getInternalExceptions().isEmpty();
    }

    public Collection getInternalExceptions() {
        if (this.internalExceptions == null) {
            this.setInternalExceptions(new Vector());
        }
        return this.internalExceptions;
    }

    public void setInternalExceptions(Collection theExceptions) {
        this.internalExceptions = theExceptions;
    }

    public void printFullStackTrace() {
        if (this.hasInternalExceptions()) {
            for (Throwable error : this.getInternalExceptions()) {
                error.printStackTrace();
            }
        }
    }
}

