/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.loader;

import java.io.IOException;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.admin.amx.util.jmx.MBeanRegistrationListener;
import org.glassfish.api.amx.AMXValues;

public final class J2EELoader {
    private final MBeanServer mMBeanServer;
    private final ConfigListener mConfigListener;
    private static final Set<String> SYNC_TYPES = SetUtil.newUnmodifiableStringSet((String[])new String[0]);

    protected static void debug(String s) {
        System.out.println(s);
    }

    public J2EELoader(MBeanServer mbeanServer) {
        this.mMBeanServer = mbeanServer;
        ConfigListener configListener = null;
        try {
            configListener = new ConfigListener(mbeanServer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mConfigListener = configListener;
    }

    public synchronized void start() {
        try {
            this.mConfigListener.startListening();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private final class ConfigListener
    extends MBeanRegistrationListener {
        public ConfigListener(MBeanServer mbeanServer) throws IOException {
            super("J2EELoader.ConfigListener", (MBeanServerConnection)mbeanServer, JMXUtil.newObjectNamePattern((String)AMXValues.amxJMXDomain(), (String)"*"));
        }

        protected void mbeanRegistered(ObjectName objectName) {
            String type = objectName.getKeyProperty("type");
            if (SYNC_TYPES.contains(type)) {
                // empty if block
            }
        }

        protected void mbeanUnregistered(ObjectName objectName) {
            String type = objectName.getKeyProperty("type");
            if (SYNC_TYPES.contains(type)) {
                // empty if block
            }
        }
    }
}

