/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.ObjectName;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.intf.config.AMXConfigHelper;
import org.glassfish.admin.amx.intf.config.ConfigTools;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyHandlers {
    private static final String SNIFFER_EAR = "ear";
    private static final String PROPERTY_NAME = "Name";
    private static final String PROPERTY_VALUE = "Value";
    private static final String PROPERTY_DESC = "Description";

    public static void getChildrenTable(HandlerContext handlerCtx) {
        String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
        String childType = (String)handlerCtx.getInputValue("childType");
        AMXProxy amx = V3AMX.objectNameToProxy(objectNameStr);
        List result = V3AMX.getChildrenMapForTableList(amx, childType, null);
        handlerCtx.setOutputValue("result", (Object)result);
    }

    private static String getA(Map<String, Object> attrs, String key) {
        Object val = attrs.get(key);
        return val == null ? "" : val.toString();
    }

    public static void deleteChildren(HandlerContext handlerCtx) {
        List obj;
        String type = (String)handlerCtx.getInputValue("type");
        String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
        AMXConfigProxy amx = (AMXConfigProxy)V3AMX.objectNameToProxy(objectNameStr);
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String Name = (String)oneRow.get(PROPERTY_NAME);
                amx.removeChild(type, Name);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getProxyAttrs(HandlerContext handlerCtx) {
        AMXProxy amx = null;
        try {
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            amx = V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(objectNameStr));
            AMXConfigHelper helper = new AMXConfigHelper((AMXConfigProxy)amx);
            Map attrs = helper.simpleAttributesMap();
            handlerCtx.setOutputValue("valueMap", (Object)attrs);
        }
        catch (Exception ex) {
            if (!(amx instanceof AMXConfigProxy)) {
                ProxyHandlers.getRuntimeProxyAttrs(handlerCtx);
                return;
            }
            ex.printStackTrace();
            handlerCtx.setOutputValue("valueMap", new HashMap());
        }
    }

    public static void getRuntimeProxyAttrs(HandlerContext handlerCtx) {
        try {
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            AMXProxy amx = V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(objectNameStr));
            Map attrs = amx.attributesMap();
            handlerCtx.setOutputValue("valueMap", (Object)attrs);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("valueMap", new HashMap());
        }
    }

    public static void getProxyAttribute(HandlerContext handlerCtx) {
        String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
        String attrName = (String)handlerCtx.getInputValue("attrName");
        Object result = "";
        try {
            Object value;
            String index;
            AMXProxy amx = V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(objectNameStr));
            Object val = amx.attributesMap().get(attrName);
            result = val instanceof Object[] ? ((index = (String)handlerCtx.getInputValue("index")) == null ? val : ((value = ((Object[])val)[Integer.parseInt(index)]) == null ? "" : value.toString())) : (val == null ? "" : val.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        handlerCtx.setOutputValue("value", result);
    }

    public static void getDefaultProxyAttrs(HandlerContext handlerCtx) {
        try {
            String parentName = (String)handlerCtx.getInputValue("parentObjectNameStr");
            String childType = (String)handlerCtx.getInputValue("childType");
            AMXConfigProxy amx = (AMXConfigProxy)V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(parentName));
            Map valueMap = amx.getDefaultValues(childType, true);
            handlerCtx.setOutputValue("valueMap", (Object)valueMap);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("valueMap", new HashMap());
        }
    }

    public static void proxyExist(HandlerContext handlerCtx) {
        try {
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            handlerCtx.setOutputValue("exist", (Object)ProxyHandlers.isProxyExist(objectNameStr));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("exist", (Object)Boolean.FALSE);
        }
    }

    public static void saveBeanAttributes(HandlerContext handlerCtx) {
        try {
            List convertToFalse;
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            if (!ProxyHandlers.isProxyExist(objectNameStr)) {
                Boolean forceCreate = (Boolean)handlerCtx.getInputValue("forceCreate");
                if (forceCreate != null && forceCreate.booleanValue()) {
                    ProxyHandlers.createProxy(handlerCtx);
                    return;
                }
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("error.noSuchProxy"));
                return;
            }
            Map attrs = (Map)handlerCtx.getInputValue("attrs");
            List skipAttrs = (List)handlerCtx.getInputValue("skipAttrs");
            if (skipAttrs != null) {
                for (String sk : skipAttrs) {
                    if (!attrs.keySet().contains(sk)) continue;
                    attrs.remove(sk);
                }
            }
            if ((convertToFalse = (List)handlerCtx.getInputValue("convertToFalse")) != null) {
                for (String sk : convertToFalse) {
                    if (!attrs.keySet().contains(sk) || attrs.get(sk) != null) continue;
                    attrs.remove(sk);
                    attrs.put(sk, "false");
                }
            }
            V3AMX.setAttributes(objectNameStr, attrs);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void updateStatus(HandlerContext handlerCtx) {
        List obj;
        String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
        AMXConfigProxy amx = (AMXConfigProxy)V3AMX.objectNameToProxy(objectNameStr);
        String status = (String)handlerCtx.getInputValue("enabled");
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        Object attr = null;
        try {
            for (Map oneRow : selectedRows) {
                String Name = (String)oneRow.get(PROPERTY_NAME);
                V3AMX.setAttribute(objectNameStr + Name, new Attribute("Enabled", status));
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void createProxy(HandlerContext handlerCtx) {
        try {
            String childType = (String)handlerCtx.getInputValue("childType");
            HashMap<String, String> attrs = (HashMap<String, String>)handlerCtx.getInputValue("attrs");
            String parentObjectNameStr = (String)handlerCtx.getInputValue("parentObjectNameStr");
            AMXConfigProxy amx = (AMXConfigProxy)V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(parentObjectNameStr));
            List convertToFalse = (List)handlerCtx.getInputValue("convertToFalse");
            if (convertToFalse != null) {
                for (String sk : convertToFalse) {
                    if (!attrs.keySet().contains(sk) || attrs.get(sk) != null) continue;
                    attrs.put(sk, "false");
                }
            }
            List skipAttrs = (List)handlerCtx.getInputValue("skipAttrs");
            V3AMX.removeSpecifiedAttr((Map<String, Object>)attrs, skipAttrs);
            List onlyUseAttrs = (List)handlerCtx.getInputValue("onlyUseAttrs");
            if (onlyUseAttrs != null) {
                HashMap<String, String> newAttrs = new HashMap<String, String>();
                for (String key : onlyUseAttrs) {
                    if (!attrs.keySet().contains(key)) continue;
                    newAttrs.put(key, (String)attrs.get(key));
                }
                attrs = newAttrs;
            }
            V3AMX.removeElement((Map<String, Object>)attrs);
            AMXConfigProxy child = amx.createChild(childType, (Map)attrs);
            handlerCtx.setOutputValue("result", (Object)child.objectName().toString());
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getChildrenByType(HandlerContext handlerCtx) {
        try {
            String type = (String)handlerCtx.getInputValue("type");
            String parentObjectNameStr = (String)handlerCtx.getInputValue("parentObjectNameStr");
            ArrayList result = new ArrayList();
            AMXConfigProxy amx = (AMXConfigProxy)V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(parentObjectNameStr));
            Map childrenMap = amx.childrenMap(type);
            result.addAll(childrenMap.keySet());
            handlerCtx.setOutputValue("result", result);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getApplicationByType(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        AMXProxy amx = V3AMX.objectNameToProxy("v3:pp=/domain,type=applications");
        Map children = amx.childrenMap("application");
        ArrayList<String> result = new ArrayList<String>();
        for (AMXProxy oneChild : children.values()) {
            try {
                AMXConfigHelper helper = new AMXConfigHelper((AMXConfigProxy)oneChild);
                Map attrs = helper.simpleAttributesMap();
                for (String attrName : attrs.keySet()) {
                    if (!attrName.equals(PROPERTY_NAME)) continue;
                    String appName = ProxyHandlers.getA(attrs, PROPERTY_NAME);
                    Map module = V3AMX.objectNameToProxy("v3:pp=/domain/applications,type=application,name=" + appName).childrenMap("module");
                    for (AMXProxy oneModule : module.values()) {
                        AMXConfigHelper helperModule = new AMXConfigHelper((AMXConfigProxy)oneModule);
                        Map modattrs = helperModule.simpleAttributesMap();
                        for (String modName : modattrs.keySet()) {
                            if (!modName.equals("Children")) continue;
                            ObjectName[] engines = (ObjectName[])modattrs.get(modName);
                            for (int i = 0; i < engines.length; ++i) {
                                String enginename = engines[i].getKeyProperty("name");
                                if (!enginename.equals(type)) continue;
                                result.add(appName);
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                GuiUtil.handleException(handlerCtx, ex);
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getApplicationBySnifferType(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        Boolean fullName = (Boolean)handlerCtx.getInputValue("fullName");
        if (fullName == null) {
            fullName = false;
        }
        AMXProxy amx = V3AMX.objectNameToProxy("v3:pp=/domain,type=applications");
        Map applications = amx.childrenMap("application");
        ArrayList<String> result = new ArrayList<String>();
        block0: for (AMXProxy oneApp : applications.values()) {
            Map modules = oneApp.childrenMap("module");
            for (AMXProxy oneModule : modules.values()) {
                Map engines = oneModule.childrenMap("engine");
                for (AMXProxy oneEngine : engines.values()) {
                    if (!oneEngine.getName().equals(type)) continue;
                    String appName = oneApp.getName();
                    if (fullName.booleanValue()) {
                        AMXProxy earSniffer = (AMXProxy)oneApp.childrenMap("engine").get(SNIFFER_EAR);
                        result.add(earSniffer == null ? appName : appName + "#" + oneModule.getName());
                        continue;
                    }
                    result.add(appName);
                    continue block0;
                }
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void setProxyProperties(HandlerContext handlerCtx) {
        try {
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            Boolean systemProp = (Boolean)handlerCtx.getInputValue("systemProp");
            ObjectName objectName = new ObjectName(objectNameStr);
            List propertyList = (List)handlerCtx.getInputValue("propertyList");
            ArrayList newList = new ArrayList();
            HashSet<String> propertyNames = new HashSet<String>();
            ConfigTools configTools = (ConfigTools)V3AMX.getInstance().getDomainRoot().getExt().child(ConfigTools.class);
            if (propertyList.size() == 0) {
                if (systemProp != null && systemProp.booleanValue()) {
                    configTools.clearSystemProperties(objectName);
                } else {
                    configTools.clearProperties(objectName);
                }
            } else {
                for (Map oneRow : propertyList) {
                    HashMap<String, String> newRow = new HashMap<String, String>();
                    String name = (String)oneRow.get(PROPERTY_NAME);
                    if (GuiUtil.isEmpty(name)) continue;
                    if (propertyNames.contains(name)) {
                        GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.duplicatePropTableKey", new Object[]{name}));
                        return;
                    }
                    propertyNames.add(name);
                    String value = (String)oneRow.get(PROPERTY_VALUE);
                    if (GuiUtil.isEmpty(value)) {
                        value = "";
                    }
                    newRow.put(PROPERTY_NAME, name);
                    newRow.put(PROPERTY_VALUE, value);
                    String desc = (String)oneRow.get(PROPERTY_DESC);
                    if (!GuiUtil.isEmpty(desc)) {
                        newRow.put(PROPERTY_DESC, desc);
                    }
                    newList.add(newRow);
                }
                if (systemProp != null && systemProp.booleanValue()) {
                    configTools.setSystemProperties(objectName, newList, true);
                } else {
                    configTools.setProperties(objectName, newList, true);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void updateProxyProperties(HandlerContext handlerCtx) {
        try {
            List propertyList = (List)handlerCtx.getInputValue("propertyList");
            ArrayList newList = new ArrayList();
            if (propertyList != null && propertyList.size() != 0) {
                for (Map oneRow : propertyList) {
                    HashMap<String, Object> newRow = new HashMap<String, Object>();
                    newRow.put("selected", false);
                    String name = (String)oneRow.get(PROPERTY_NAME);
                    if (GuiUtil.isEmpty(name)) continue;
                    String value = (String)oneRow.get(PROPERTY_VALUE);
                    if (GuiUtil.isEmpty(value)) {
                        value = "";
                    }
                    newRow.put(PROPERTY_NAME, name);
                    newRow.put(PROPERTY_VALUE, value);
                    String desc = (String)oneRow.get(PROPERTY_DESC);
                    if (!GuiUtil.isEmpty(desc)) {
                        desc = "";
                    }
                    newRow.put(PROPERTY_DESC, desc);
                    newList.add(newRow);
                }
            }
            handlerCtx.setOutputValue("TableList", newList);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static Map getDefaultProxyAttrsMap(String parentObjectNameStr, String childType) {
        try {
            String parentName = parentObjectNameStr;
            String child = childType;
            AMXConfigProxy amx = (AMXConfigProxy)V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(parentName));
            Map valueMap = amx.getDefaultValues(child, true);
            return valueMap;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new HashMap();
        }
    }

    public static boolean isProxyExist(String objectNameStr) {
        try {
            ObjectName objName = new ObjectName(objectNameStr);
            return V3AMX.getInstance().getMbeanServerConnection().isRegistered(objName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static void getAmxRootInstance(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("amxRoot", (Object)V3AMX.getInstance());
    }
}

