/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admingui.common.util.V3AMX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppUtil {
    public static final List sniffersHide = new ArrayList();
    public static final String PROP_IS_COMPOSITE = "isComposite";

    public static List getAllSniffers(AMXProxy app) {
        Map modules = app.childrenMap("module");
        ArrayList<String> sniffersList = new ArrayList<String>();
        for (AMXProxy oneModule : modules.values()) {
            List<String> sniffers = AppUtil.getSnifferListOfModule(oneModule);
            for (String oneSniffer : sniffers) {
                if (sniffersList.contains(oneSniffer)) continue;
                sniffersList.add(oneSniffer);
            }
        }
        return sniffersList;
    }

    public static List<String> getSnifferListOfModule(AMXProxy module) {
        ArrayList<String> sniffersList = new ArrayList<String>();
        Map engines = module.childrenMap("engine");
        for (String oneSniffer : engines.keySet()) {
            String sniffer = oneSniffer;
            if (sniffersHide.contains(sniffer)) continue;
            sniffersList.add(sniffer);
        }
        Collections.sort(sniffersList);
        return sniffersList;
    }

    public static boolean isApplicationEnabled(AMXProxy application) {
        Map attrs = application.attributesMap();
        String enabled = (String)attrs.get("Enabled");
        String appName = (String)attrs.get("Name");
        if ("true".equals(enabled)) {
            String objName = "v3:pp=/domain/servers/server[server],type=application-ref,name=" + appName;
            AMXProxy appRef = V3AMX.objectNameToProxy(objName);
            String appRefEnabled = (String)appRef.attributesMap().get("Enabled");
            return "true".equals(appRefEnabled);
        }
        return false;
    }

    public static boolean isApplicationEnabled(String appObjectName) {
        return AppUtil.isApplicationEnabled(V3AMX.objectNameToProxy(appObjectName));
    }

    static {
        sniffersHide.add("security");
    }
}

