/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.ncli;

import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.glassfish.admin.ncli.CommandMetadataCache;
import org.glassfish.admin.ncli.NewCommand;
import org.glassfish.admin.ncli.Option;
import org.glassfish.admin.ncli.Parser;
import org.glassfish.admin.ncli.ParserException;
import org.glassfish.admin.ncli.ProgramOptionBuilder;
import org.glassfish.admin.ncli.comm.TargetServer;
import org.glassfish.admin.ncli.metadata.CommandDesc;
import org.glassfish.admin.ncli.metadata.OptionDesc;
import org.glassfish.api.admin.cli.OptionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandRunner {
    private static final ProgramOptionBuilder POB = ProgramOptionBuilder.getInstance();
    private final Set<String> slc = new HashSet<String>();
    private final Set<String> uslc = new HashSet<String>();
    private final PrintStream out;
    private final PrintStream err;
    private final CommandMetadataCache cache;
    private String cmdName;
    private TargetServer ts;
    private Set<Option> programOptions;
    private CommandDesc desc;
    private NewCommand command;
    private boolean usesDeprecatedSyntax;
    private String[] cmdArgs;
    private int cmdArgsStart;
    private static final LocalStringsImpl lsm = new LocalStringsImpl(CommandRunner.class);

    CommandRunner(PrintStream out, PrintStream err) {
        if (out == null || err == null) {
            throw new NullPointerException("null out or err");
        }
        this.out = out;
        this.err = err;
        this.cache = new CommandMetadataCache();
        this.initialize();
    }

    void parseMetaOptions(String[] argv) throws ParserException {
        Map<String, String> metaOptions;
        Set<OptionDesc> known = POB.getAllOptionMetadata();
        if (argv.length == 0) {
            throw new ParserException(lsm.get("no.command"));
        }
        if (argv[0].startsWith("-")) {
            this.usesDeprecatedSyntax = false;
            Parser p = new Parser(known, false);
            p.parse(argv, 0);
            metaOptions = p.getOptions();
            this.cmdArgs = p.getOperands();
            if (this.cmdArgs.length == 0) {
                throw new ParserException(lsm.get("no.command"));
            }
            this.cmdName = this.cmdArgs[0];
            this.handleUnsupportedLegacyCommand(this.cmdName);
            this.cmdArgsStart = 1;
        } else {
            this.cmdName = argv[0];
            this.handleUnsupportedLegacyCommand(this.cmdName);
            Parser p = new Parser(known, true);
            p.parse(argv, 1);
            metaOptions = p.getOptions();
            if (metaOptions.size() > 0) {
                this.usesDeprecatedSyntax = true;
                Set<String> names = metaOptions.keySet();
                Object[] nameArray = names.toArray(new String[names.size()]);
                this.out.println(lsm.get("deprecated.syntax", new Object[]{this.cmdName, Arrays.toString(nameArray)}));
            } else {
                this.usesDeprecatedSyntax = false;
            }
            this.cmdArgs = p.getOperands();
            this.cmdArgsStart = 0;
        }
        this.programOptions = this.initializeAllProgramOptions(metaOptions);
        this.ts = this.initializeTargetServer();
    }

    void parseCommand(String[] argv) throws ParserException {
        this.parseMetaOptions(argv);
        CommandRunner.populate(this.cache, this.ts);
        this.desc = this.cache.get(this.cmdName, this.ts);
        if (this.desc == null) {
            this.desc = this.getCommandMetadata(this.cmdName, this.ts);
        }
        if (this.desc == null) {
            throw new ParserException(lsm.get("unknown.command", new Object[]{this.cmdName}));
        }
        HashSet<OptionDesc> opts = new HashSet<OptionDesc>(this.desc.getOptionDesc());
        Parser p = new Parser(opts, false);
        p.parse(this.cmdArgs, this.cmdArgsStart);
    }

    public void execute(String[] argv) throws ParserException {
        this.parseCommand(argv);
        this.cache.put(this.cmdName, this.ts, this.desc);
    }

    public static void main(String[] argv) throws Exception {
        CommandRunner cr = new CommandRunner(System.out, System.err);
        cr.parseMetaOptions(argv);
        System.out.println("Meta-options:");
        for (Option po : cr.getProgramOptions()) {
            System.out.println("  " + po);
        }
        System.out.println("Target Server: " + cr.getTargetServer());
        System.out.println("Command: " + cr.getCommandName());
        System.out.println("Arguments: " + Arrays.toString(cr.getCommandArguments()));
        cr.parseCommand(argv);
    }

    Set<Option> getProgramOptions() {
        return this.programOptions;
    }

    String getCommandName() {
        return this.cmdName;
    }

    boolean usesDeprecatedSyntax() {
        return this.usesDeprecatedSyntax;
    }

    String[] getCommandArguments() {
        if (this.cmdArgsStart == 0) {
            return this.cmdArgs;
        }
        int len = this.cmdArgs.length - this.cmdArgsStart;
        String[] args = new String[len];
        System.arraycopy(this.cmdArgs, this.cmdArgsStart, args, 0, len);
        return args;
    }

    TargetServer getTargetServer() {
        return this.ts;
    }

    private void initialize() {
        CommandRunner.file2Set("supported-legacy-command-names", this.slc);
        CommandRunner.file2Set("unsupported-legacy-command-names", this.uslc);
    }

    private void handleUnsupportedLegacyCommand(String cmd) throws ParserException {
        for (String c : this.uslc) {
            if (!c.equals(cmd)) continue;
            throw new ParserException(lsm.get("unsupported.legacy.command", new Object[]{cmd}));
        }
    }

    private CommandDesc getCommandMetadata(String cmdName, TargetServer from) {
        return null;
    }

    private Set<Option> initializeAllProgramOptions(Map<String, String> metaOptions) {
        Set<OptionDesc> validOnes = POB.getAllOptionMetadata();
        HashSet<Option> options = new HashSet<Option>();
        for (OptionDesc opt : validOnes) {
            String value = metaOptions.get(opt.getName());
            boolean added = options.add(new Option(opt, value));
            assert (added) : "Programming Error: This option could not be added to the set: " + opt.getName();
        }
        return Collections.unmodifiableSet(options);
    }

    private TargetServer initializeTargetServer() {
        String host = null;
        int port = -1;
        String user = null;
        String password = null;
        boolean secure = false;
        for (Option po : this.programOptions) {
            String name = po.getName();
            if ("host".equals(name)) {
                host = po.getEffectiveValue();
            }
            if ("port".equals(name)) {
                port = Integer.parseInt(po.getEffectiveValue());
            }
            if ("user".equals(name)) {
                user = po.getEffectiveValue();
            }
            if ("password".equals(name)) {
                password = po.getEffectiveValue();
            }
            if (!"secure".equals(name)) continue;
            secure = Boolean.valueOf(po.getEffectiveValue());
        }
        return new TargetServer(host, port, user, password, secure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void file2Set(String file, Set<String> set) {
        BufferedReader reader = null;
        try {
            String line;
            InputStream is = CommandRunner.class.getClassLoader().getResourceAsStream(file);
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                StringTokenizer tok = new StringTokenizer(line, " ");
                String cmd = tok.nextToken();
                set.add(cmd);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void populate(CommandMetadataCache cache, TargetServer ts) {
        CommandDesc desc = new CommandDesc();
        desc.setName("list-commands");
        CommandRunner.addOpt(desc, "localonly", '\u0000', false, false, OptionType.BOOLEAN);
        CommandRunner.addOpt(desc, "remoteonly", '\u0000', false, false, OptionType.BOOLEAN);
        cache.put(desc.getName(), ts, desc);
        desc = new CommandDesc();
        desc.setName("monitor");
        CommandRunner.addOpt(desc, "interval", '\u0000', false, false, OptionType.STRING);
        CommandRunner.addOpt(desc, "filter", '\u0000', false, false, OptionType.STRING);
        CommandRunner.addOpt(desc, "filename", '\u0000', false, false, OptionType.FILE);
        cache.put(desc.getName(), ts, desc);
        desc = new CommandDesc();
        desc.setName("create-jdbc-resource");
        CommandRunner.addOpt(desc, "connectionpoolid", '\u0000', true, false, OptionType.STRING);
        CommandRunner.addOpt(desc, "enabled", '\u0000', false, false, OptionType.BOOLEAN);
        CommandRunner.addOpt(desc, "description", '\u0000', false, false, OptionType.STRING);
        CommandRunner.addOpt(desc, "target", '\u0000', false, false, OptionType.STRING);
        CommandRunner.addOpt(desc, "property", '\u0000', false, false, OptionType.PROPERTY);
        cache.put(desc.getName(), ts, desc);
    }

    private static void addOpt(CommandDesc desc, String name, char sym, boolean req, boolean rep, OptionType type) {
        OptionDesc opt = new OptionDesc();
        opt.setName(name);
        if (sym != '\u0000') {
            opt.setSymbol(Character.toString(sym));
        }
        opt.setRequired(Boolean.toString(req));
        opt.setRepeats(Boolean.toString(rep));
        opt.setType(type.name());
        desc.getOptionDesc().add(opt);
    }
}

