/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.ext;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.v3.admin.RestartDomainCommand;
import com.sun.enterprise.v3.common.PlainTextActionReporter;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.amx.base.Runtime;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.intf.config.Config;
import org.glassfish.admin.amx.intf.config.Domain;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkConfig;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkListener;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkListeners;
import org.glassfish.admin.amx.intf.config.grizzly.Protocol;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.mbeanserver.BooterNewMBean;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.container.Sniffer;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuntimeImpl
extends AMXImplBase {
    private final ApplicationRegistry appRegistry;
    private final Habitat mHabitat = InjectedValues.getInstance().getHabitat();
    private static final String ADMIN_LISTENER_NAME = "admin-listener";

    public RuntimeImpl(ObjectName parent) {
        super(parent, Runtime.class);
        this.appRegistry = (ApplicationRegistry)this.mHabitat.getComponent(ApplicationRegistry.class);
    }

    public Map<String, String> getDeploymentConfigurations(String appName) {
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo == null) {
            throw new IllegalArgumentException(appName);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            for (Sniffer sniffer : appInfo.getSniffers()) {
                result.putAll(sniffer.getDeploymentConfigurations(appInfo.getSource()));
            }
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void stopDomain() {
        ModulesRegistry registry = InjectedValues.getInstance().getModulesRegistry();
        Collection modules = registry.getModules("com.sun.enterprise.osgi-adapter");
        if (modules.size() == 1) {
            Module mgmtAgentModule = (Module)modules.iterator().next();
            mgmtAgentModule.stop();
        } else {
            ImplUtil.getLogger().warning("Cannot find primordial com.sun.enterprise.osgi-adapter");
        }
        ImplUtil.getLogger().warning("Stopping server forcibly");
        System.exit(0);
    }

    public void restartDomain() {
        ModulesRegistry registry = InjectedValues.getInstance().getModulesRegistry();
        AdminCommandContext ctx = new AdminCommandContext(ImplUtil.getLogger(), (ActionReport)new PlainTextActionReporter());
        RestartDomainCommand cmd = new RestartDomainCommand(registry);
        cmd.execute(ctx);
    }

    private NetworkConfig networkConfig() {
        return (NetworkConfig)((Config)((Domain)this.getDomainRootProxy().child(Domain.class)).getConfigs().getConfig().get("server-config")).getNetworkConfig().as(NetworkConfig.class);
    }

    private NetworkListener getAdminListener() {
        NetworkConfig network = this.networkConfig();
        NetworkListeners listeners = network.getNetworkListeners();
        Map listenersMap = listeners.getNetworkListener();
        NetworkListener listener = (NetworkListener)listenersMap.get(ADMIN_LISTENER_NAME);
        return listener;
    }

    private int getRESTPort() {
        return (int)this.getAdminListener().resolveLong("Port").longValue();
    }

    private String get_asadmin() {
        Protocol protocol = (Protocol)this.networkConfig().getProtocols().getProtocol().get(ADMIN_LISTENER_NAME);
        return protocol.getHttp().resolveAttribute("DefaultVirtualServer");
    }

    public String getRESTBaseURL() {
        Protocol protocol = (Protocol)this.networkConfig().getProtocols().getProtocol().get(ADMIN_LISTENER_NAME);
        String scheme = protocol.resolveBoolean("SecurityEnabled") != false ? "https" : "http";
        String host = "localhost";
        return scheme + "://" + "localhost" + ":" + this.getRESTPort() + "/" + this.get_asadmin() + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeREST(String cmd) {
        String result = null;
        HttpURLConnection conn = null;
        try {
            String url = this.getRESTBaseURL() + cmd;
            URL invoke = new URL(url);
            conn = (HttpURLConnection)invoke.openConnection();
            InputStream is = conn.getInputStream();
            result = RuntimeImpl.toString((Object)is);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = ExceptionUtil.toString((Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return result;
    }

    public String[] getSupportedCipherSuites() {
        try {
            SSLUtils sslUtils = (SSLUtils)this.mHabitat.getComponent(SSLUtils.class);
            return sslUtils.getSupportedCipherSuites();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new String[0];
        }
    }

    public JMXServiceURL[] getJMXServiceURLs() {
        try {
            return (JMXServiceURL[])this.getMBeanServer().getAttribute(BooterNewMBean.OBJECT_NAME, "JMXServiceURLs");
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }
}

