/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.config;

import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.impl.config.ConfigBeanRegistry;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.intf.config.BackendPrincipal;
import org.glassfish.admin.amx.intf.config.ConfigTools;
import org.glassfish.admin.amx.intf.config.ConnectorConnectionPool;
import org.glassfish.admin.amx.intf.config.Domain;
import org.glassfish.admin.amx.intf.config.Resources;
import org.glassfish.admin.amx.intf.config.SecurityMap;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.Property;
import org.glassfish.api.admin.config.PropertyBag;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigToolsImpl
extends AMXImplBase {
    private static void debug(String s) {
        System.out.println(s);
    }

    public ConfigToolsImpl(ObjectName parent) {
        super(parent, ConfigTools.class);
    }

    private static Property findProperty(List<Property> props, String name) {
        for (Property prop : props) {
            if (prop == null) {
                ConfigToolsImpl.debug("WARNING: null Property object in List<Property>");
                continue;
            }
            if (!prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    private static SystemProperty findSystemProperty(List<SystemProperty> props, String name) {
        for (SystemProperty prop : props) {
            if (!prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    public Object test() {
        Domain domain = (Domain)this.getDomainRootProxy().getDomain().as(Domain.class);
        Resources resources = domain.getResources();
        String NAME = "test";
        try {
            resources.removeChild(Util.deduceType(ConnectorConnectionPool.class), "test");
        }
        catch (Exception e) {
            // empty catch block
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Name", "test");
        params.put("ResourceAdapterName", "test");
        params.put("ConnectionDefinitionName", "test");
        params.put("SteadyPoolSize", 23);
        HashMap<String, Object> securityParams = new HashMap<String, Object>();
        securityParams.put("Name", "test");
        params.put(Util.deduceType(SecurityMap.class), securityParams);
        HashMap<String, String> backendParams = new HashMap<String, String>();
        backendParams.put("UserName", "testUser");
        backendParams.put("Password", "testPassword");
        securityParams.put(Util.deduceType(BackendPrincipal.class), backendParams);
        AMXConfigProxy result = resources.createChild(Util.deduceType(ConnectorConnectionPool.class), params);
        return result.objectName();
    }

    public void setProperties(ObjectName parent, List<Map<String, String>> props, boolean clearAll) {
        if (parent == null || props == null) {
            throw new IllegalArgumentException();
        }
        ConfigBean configBean = ConfigBeanRegistry.getInstance().getConfigBean(parent);
        if (configBean == null) {
            throw new IllegalArgumentException("" + parent);
        }
        PropertyBagProxy proxy = (PropertyBagProxy)configBean.getProxy(PropertyBagProxy.class);
        if (!PropertyBag.class.isAssignableFrom(proxy.getClass())) {
            throw new IllegalArgumentException("ConfigBean " + configBean.getProxyType().getName() + " is not a PropertyBag");
        }
        PropsSetter propsSetter = new PropsSetter(props, clearAll);
        try {
            ConfigSupport.apply((ConfigCode)propsSetter, (ConfigBeanProxy[])new ConfigBeanProxy[]{proxy});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void clearProperties(ObjectName parent) {
        this.setProperties(parent, new ArrayList<Map<String, String>>(), true);
    }

    public void clearSystemProperties(ObjectName parent) {
        this.setSystemProperties(parent, new ArrayList<Map<String, String>>(), true);
    }

    public void setSystemProperties(ObjectName parent, List<Map<String, String>> props, boolean clearAll) {
        if (parent == null || props == null) {
            throw new IllegalArgumentException();
        }
        ConfigBean configBean = ConfigBeanRegistry.getInstance().getConfigBean(parent);
        if (configBean == null) {
            throw new IllegalArgumentException("" + parent);
        }
        SystemPropertyBagProxy proxy = (SystemPropertyBagProxy)configBean.getProxy(SystemPropertyBagProxy.class);
        if (!SystemPropertyBag.class.isAssignableFrom(proxy.getClass())) {
            throw new IllegalArgumentException("ConfigBean " + configBean.getProxyType().getName() + " is not a SystemPropertyBag");
        }
        SystemPropsSetter propsSetter = new SystemPropsSetter(props, clearAll);
        try {
            ConfigSupport.apply((ConfigCode)propsSetter, (ConfigBeanProxy[])new ConfigBeanProxy[]{proxy});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private String[] getTypesImplementing(Class<?> clazz) {
        DomDocument domDoc = new DomDocument(InjectedValues.getInstance().getHabitat());
        try {
            List models = domDoc.getAllModelsImplementing(clazz);
            String[] names = new String[models == null ? 0 : models.size()];
            if (models != null) {
                int i = 0;
                for (ConfigModel model : models) {
                    names[i] = model.getTagName();
                    ++i;
                }
            }
            return names;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String[] getConfigNamedTypes() {
        return this.getTypesImplementing(Named.class);
    }

    public String[] getConfigResourceTypes() {
        return this.getTypesImplementing(Resource.class);
    }

    static interface SystemPropertyBagProxy
    extends ConfigBeanProxy,
    SystemPropertyBag {
    }

    static interface PropertyBagProxy
    extends ConfigBeanProxy,
    PropertyBag {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SystemPropsSetter
    extends AnyPropsSetter {
        public SystemPropsSetter(List<Map<String, String>> newProps, boolean clearAll) {
            super(newProps, clearAll);
        }

        @Override
        public Object _run(ConfigBeanProxy parent, ConfigSupport configSupport) throws PropertyVetoException, TransactionFailure {
            SystemPropertyBag bag = (SystemPropertyBag)parent;
            List props = bag.getSystemProperty();
            if (this.mClearAll) {
                props.clear();
            }
            for (Map newProp : this.mNewProps) {
                String name = (String)newProp.get("Name");
                String value = (String)newProp.get("Value");
                String description = (String)newProp.get("Description");
                SystemProperty prop = ConfigToolsImpl.findSystemProperty(props, name);
                if (prop != null) {
                    props.remove(prop);
                }
                prop = (SystemProperty)parent.createChild(SystemProperty.class);
                prop.setName(name);
                prop.setValue(value);
                prop.setDescription(description);
                props.add(prop);
                ConfigToolsImpl.debug("Created/updated system property: " + name);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PropsSetter
    extends AnyPropsSetter {
        public PropsSetter(List<Map<String, String>> newProps, boolean clearAll) {
            super(newProps, clearAll);
        }

        @Override
        public Object _run(ConfigBeanProxy parent, ConfigSupport configSupport) throws PropertyVetoException, TransactionFailure {
            PropertyBag bag = (PropertyBag)parent;
            List props = bag.getProperty();
            if (this.mClearAll) {
                props.clear();
            }
            for (Map newProp : this.mNewProps) {
                String name = (String)newProp.get("Name");
                String value = (String)newProp.get("Value");
                String description = (String)newProp.get("Description");
                Property prop = ConfigToolsImpl.findProperty(props, name);
                if (prop != null) {
                    props.remove(prop);
                }
                prop = (Property)parent.createChild(Property.class);
                prop.setName(name);
                prop.setValue(value);
                prop.setDescription(description);
                props.add(prop);
                ConfigToolsImpl.debug("Created/updated property: " + name);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AnyPropsSetter
    implements ConfigCode {
        protected final List<Map<String, String>> mNewProps;
        protected final boolean mClearAll;

        AnyPropsSetter(List<Map<String, String>> newProps, boolean clearAll) {
            this.mNewProps = newProps;
            this.mClearAll = clearAll;
        }

        public Object run(ConfigBeanProxy ... params) throws PropertyVetoException, TransactionFailure {
            if (params.length != 1) {
                throw new IllegalArgumentException();
            }
            ConfigBeanProxy parent = params[0];
            ConfigBean source = (ConfigBean)ConfigBean.unwrap((ConfigBeanProxy)parent);
            ConfigSupport configSupport = (ConfigSupport)source.getHabitat().getComponent(ConfigSupport.class);
            return this._run(parent, configSupport);
        }

        abstract Object _run(ConfigBeanProxy var1, ConfigSupport var2) throws PropertyVetoException, TransactionFailure;
    }
}

