/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.mbeanserver.Booter;
import org.glassfish.admin.mbeanserver.BooterNew;
import org.glassfish.admin.mbeanserver.JMXMPConnectorStarter;
import org.glassfish.admin.mbeanserver.Util;
import org.glassfish.api.Async;
import org.glassfish.api.Startup;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

@Service
@Async
public final class ConnectorStartupService
implements Startup,
PostConstruct {
    @Inject
    private MBeanServer mMBeanServer = ManagementFactory.getPlatformMBeanServer();
    @Inject
    private AdminService mAdminService;
    @Inject
    private Habitat mHabitat;
    private volatile BooterNew mNewBooter;

    private static void debug(String s) {
        System.out.println("### " + s);
    }

    public void postConstruct() {
        this.mNewBooter = BooterNew.create(this.mHabitat, this.mMBeanServer);
        List configuredConnectors = this.mAdminService.getJmxConnector();
        ConnectorsStarterThread starter = new ConnectorsStarterThread(this.mMBeanServer, configuredConnectors, this.mNewBooter);
        starter.start();
    }

    private static Registry startRegistry(int port) {
        try {
            return LocateRegistry.createRegistry(port);
        }
        catch (Exception e) {
            throw new RuntimeException("Port " + port + " is not available for the internal rmi registry. " + "This means that a call was made with the same port, without closing earlier " + "registry instance. This has to do with the system jmx connector configuration " + "in admin-service element of the configuration associated with this instance");
        }
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConnectorsStarterThread
    extends Thread {
        private final List<JmxConnector> mConfiguredConnectors;
        private final MBeanServer mMBeanServer;
        private final BooterNew mAMXBooterNew;

        public ConnectorsStarterThread(MBeanServer mbs, List<JmxConnector> configuredConnectors, BooterNew amxBooterNew) {
            this.mMBeanServer = mbs;
            this.mConfiguredConnectors = configuredConnectors;
            this.mAMXBooterNew = amxBooterNew;
        }

        private static String toString(JmxConnector c) {
            return "JmxConnector config: { name = " + c.getName() + ", Protocol = " + c.getProtocol() + ", Address = " + c.getAddress() + ", Port = " + c.getPort() + ", AcceptAll = " + c.getAcceptAll() + ", AuthRealmName = " + c.getAuthRealmName() + ", SecurityEnabled = " + c.getSecurityEnabled() + "}";
        }

        private JMXConnectorServer startConnector(JmxConnector connConfig) throws IOException {
            Util.getLogger().fine("Starting JMXConnector: " + ConnectorsStarterThread.toString(connConfig));
            String protocol = connConfig.getProtocol();
            if (!protocol.equals("rmi_jrmp")) {
                throw new IllegalArgumentException("The only protocol supported is rmi_jrmp");
            }
            String address = connConfig.getAddress();
            int port = Integer.parseInt(connConfig.getPort());
            String authRealmName = connConfig.getAuthRealmName();
            boolean securityEnabled = Boolean.parseBoolean(connConfig.getSecurityEnabled());
            RMIConnectorStarter starter = new RMIConnectorStarter(this.mMBeanServer, address, port, protocol, authRealmName, securityEnabled);
            JMXConnectorServer server = starter.startRMIConnector("jmxrmi");
            JMXServiceURL url = server.getAddress();
            Util.getLogger().info("Started JMXConnector, JMXService URL = " + url);
            try {
                ObjectName objectName = new ObjectName("jmxremote:type=jmx-connector,name=jmxrmi");
                objectName = this.mMBeanServer.registerMBean(server, objectName).getObjectName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return server;
        }

        @Override
        public void run() {
            Util.getLogger().fine("Number of JMX connectors: " + this.mConfiguredConnectors.size());
            for (JmxConnector c : this.mConfiguredConnectors) {
                if (!Boolean.parseBoolean(c.getEnabled())) {
                    Util.getLogger().info("JmxConnector " + c.getName() + " is disabled, skipping.");
                    continue;
                }
                try {
                    JMXConnectorServer server = this.startConnector(c);
                }
                catch (Throwable t) {
                    Util.getLogger().warning("Cannot start JMX connector: " + ConnectorsStarterThread.toString(c) + ": " + t);
                }
            }
            if (Boolean.valueOf(System.getProperty("START_JMXMP")).booleanValue()) {
                this.startJMXMPConnector();
            }
        }

        private void startJMXMPConnector() {
            JMXMPConnectorStarter jmxmpStarter = new JMXMPConnectorStarter(this.mMBeanServer);
            try {
                jmxmpStarter.start();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        private final class RMIConnectorStarter {
            private final MBeanServer mMBeanServer;
            private final String mAddress;
            private final int mPort;
            private final String mProtocol;
            private final String mAuthRealmName;
            private final boolean mSecurityEnabled;
            private final Registry mRegistry;

            public RMIConnectorStarter(MBeanServer mbeanServer, String address, int port, String protocol, String authRealmName, boolean securityEnabled) {
                this.mMBeanServer = mbeanServer;
                this.mAddress = address;
                this.mPort = port;
                this.mProtocol = protocol;
                this.mAuthRealmName = authRealmName;
                this.mSecurityEnabled = securityEnabled;
                if (securityEnabled) {
                    throw new IllegalArgumentException("JMXConnectorServer not yet supporting security");
                }
                if (!"rmi_jrmp".equals(protocol)) {
                    throw new IllegalArgumentException("JMXConnectorServer not yet supporting protocol: " + protocol);
                }
                this.mRegistry = ConnectorStartupService.startRegistry(this.mPort);
            }

            public JMXConnectorServer startRMIConnector(String name) throws IOException {
                HashMap env = new HashMap();
                String s = "service:jmx:rmi:///jndi/rmi://" + Util.localhost() + ":" + this.mPort + "/" + name;
                JMXServiceURL url = new JMXServiceURL(s);
                JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, env, this.mMBeanServer);
                BootAMXListener listener = new BootAMXListener(cs, ConnectorsStarterThread.this.mAMXBooterNew);
                cs.addNotificationListener(listener, null, null);
                cs.start();
                return cs;
            }
        }
    }

    private static final class BootAMXListener
    implements NotificationListener {
        private final JMXConnectorServer mServer;
        private final Booter mBooter;

        public BootAMXListener(JMXConnectorServer server, Booter booter) {
            this.mServer = server;
            this.mBooter = booter;
        }

        public void handleNotification(Notification notif, Object handback) {
            JMXConnectionNotification n;
            if (notif instanceof JMXConnectionNotification && (n = (JMXConnectionNotification)notif).getType().equals("jmx.remote.connection.opened")) {
                Util.getLogger().info("ConnectorStartupService.BootAMXListener: connection made, booting AMX MBeans");
                this.mBooter.bootAMX();
                try {
                    this.mServer.removeNotificationListener(this);
                    Util.getLogger().fine("ConnectorStartupService.BootAMXListener: AMX is booted, stopped listening");
                }
                catch (ListenerNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

