/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.glassfish.admin.monitor.StatsProviderRegistry;
import org.glassfish.api.amx.AMXValues;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObjectManager;
import org.glassfish.gmbal.ManagedObjectManagerFactory;
import org.glassfish.probe.provider.PluginPoint;
import org.glassfish.probe.provider.StatsProviderManagerDelegate;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class StatsProviderManagerDelegateImpl
implements StatsProviderManagerDelegate,
PostConstruct {
    @Inject
    protected ProbeClientMediator pcm;
    private final MonitoringRuntimeDataRegistry mrdr;
    private final Domain domain;
    private final TreeNode serverNode;
    private final HashMap momMap = new HashMap();
    private static final ObjectName MONITORING_ROOT = AMXValues.monitoringRoot();
    private static final ObjectName MONITORING_SERVER = AMXValues.serverMon((String)AMXValues.dasName());
    private StatsProviderRegistry statsProviderRegistry;

    StatsProviderManagerDelegateImpl(MonitoringRuntimeDataRegistry mrdr, Domain domain) {
        this.mrdr = mrdr;
        this.domain = domain;
        this.serverNode = this.constructServerPP();
        this.statsProviderRegistry = new StatsProviderRegistry(mrdr);
    }

    public void postConstruct() {
    }

    public void register(String configElement, PluginPoint pp, String subTreePath, Object statsProvider) {
        TreeNode ppNode = this.getPluginPointNode(pp, this.serverNode);
        TreeNode parentNode = this.createSubTree(ppNode, subTreePath);
        ArrayList<String> childNodeNames = new ArrayList<String>();
        for (Method m : statsProvider.getClass().getDeclaredMethods()) {
            String methodNameLower;
            ManagedAttribute ma = m.getAnnotation(ManagedAttribute.class);
            if (ma == null) continue;
            String methodName = m.getName();
            String id = ma.id();
            if ((id == null || id.isEmpty()) && (methodNameLower = methodName.toLowerCase()).startsWith("get") && methodNameLower.length() > 3) {
                id = methodNameLower.substring(3);
            }
            TreeNode attrNode = TreeNodeFactory.createMethodInvoker(id, statsProvider, id, m);
            parentNode.addChild(attrNode);
            childNodeNames.add(attrNode.getName());
        }
        Collection handles = null;
        try {
            handles = this.pcm.registerListener(statsProvider);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ManagedObjectManager mom = ManagedObjectManagerFactory.createFederated(MONITORING_SERVER);
            mom.stripPackagePrefix();
            mom.createRoot(statsProvider, subTreePath);
            this.momMap.put(statsProvider, mom);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.statsProviderRegistry.registerStatsProvider(configElement, parentNode.getCompletePathName(), childNodeNames, handles, statsProvider);
    }

    public void unRegister(Object statsProvider) {
        try {
            ((ManagedObjectManager)this.momMap.get(statsProvider)).unregister(statsProvider);
            this.statsProviderRegistry.unregisterStatsProvider(statsProvider);
        }
        catch (Exception ex) {
            Logger.getLogger(StatsProviderManagerDelegateImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void unregisterAll() {
    }

    private TreeNode createSubTreeNode(TreeNode parent, String child) {
        TreeNode childNode = parent.getNode(child);
        if (childNode == null) {
            childNode = TreeNodeFactory.createTreeNode(child, null, child);
            parent.addChild(childNode);
        }
        return childNode;
    }

    private TreeNode getPluginPointNode(PluginPoint pp, TreeNode serverNode) {
        if (pp.getName().equals(serverNode.getName())) {
            return serverNode;
        }
        return this.createSubTree(serverNode, pp.getPath());
    }

    private TreeNode createSubTree(TreeNode parent, String subTreePath) {
        StringTokenizer st = new StringTokenizer(subTreePath, "/");
        TreeNode parentNode = parent;
        while (st.hasMoreTokens()) {
            TreeNode subTreeNode;
            parentNode = subTreeNode = this.createSubTreeNode(parentNode, st.nextToken());
        }
        return parentNode;
    }

    private TreeNode constructServerPP() {
        TreeNode srvrNode = this.mrdr.get("server");
        if (srvrNode != null) {
            return srvrNode;
        }
        Server srvr = null;
        List ls = this.domain.getServers().getServer();
        for (Server sr : ls) {
            if (!"server".equals(sr.getName())) continue;
            srvr = sr;
            break;
        }
        srvrNode = TreeNodeFactory.createTreeNode("server", null, "server");
        this.mrdr.add("server", srvrNode);
        return srvrNode;
    }
}

