/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.admingui.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.intf.config.AuthRealm;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealmsHandlers {
    private static List skipRealmPropsList = new ArrayList();
    private static List realmClassList;
    private static final String PROPERTY_NAME = "Name";
    private static final String PROPERTY_VALUE = "Value";

    public static void getRealmAttrForCreate(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("realmClasses", (Object)realmClassList);
        handlerCtx.setOutputValue("classnameOption", (Object)"predefine");
        HashMap<String, Boolean> attrMap = new HashMap<String, Boolean>();
        attrMap.put("predefinedClassname", Boolean.TRUE);
        handlerCtx.setOutputValue("attrMap", attrMap);
        handlerCtx.setOutputValue("properties", new ArrayList());
    }

    public static void getRealmAttrForEdit(HandlerContext handlerCtx) {
        String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
        AuthRealm realm = (AuthRealm)V3AMX.objectNameToProxy((String)objectNameStr).as(AuthRealm.class);
        Map origProps = realm.getProperty();
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        attrMap.put(PROPERTY_NAME, realm.getName());
        attrMap.put("fileJaax", "fileRealm");
        attrMap.put("ldapJaax", "ldapRealm");
        attrMap.put("solarisJaax", "solarisRealm");
        attrMap.put("jdbcJaax", "jdbcRealm");
        String classname = realm.getClassname();
        if (realmClassList.contains(classname)) {
            handlerCtx.setOutputValue("classnameOption", (Object)"predefine");
            attrMap.put("predefinedClassname", Boolean.TRUE);
            attrMap.put("classname", classname);
            List props = V3AMX.getChildrenMapForTableList((AMXProxy)realm, (String)"property", (List)skipRealmPropsList);
            handlerCtx.setOutputValue("properties", (Object)props);
            if (classname.indexOf("FileRealm") != -1) {
                attrMap.put("file", V3AMX.getPropValue((Map)origProps, (String)"file"));
                attrMap.put("fileJaax", V3AMX.getPropValue((Map)origProps, (String)"jaas-context"));
                attrMap.put("fileAsGroups", V3AMX.getPropValue((Map)origProps, (String)"assign-groups"));
            } else if (classname.indexOf("LDAPRealm") != -1) {
                attrMap.put("ldapJaax", V3AMX.getPropValue((Map)origProps, (String)"jaas-context"));
                attrMap.put("ldapAsGroups", V3AMX.getPropValue((Map)origProps, (String)"assign-groups"));
                attrMap.put("directory", V3AMX.getPropValue((Map)origProps, (String)"directory"));
                attrMap.put("baseDn", V3AMX.getPropValue((Map)origProps, (String)"base-dn"));
            } else if (classname.indexOf("SolarisRealm") != -1) {
                attrMap.put("solarisJaax", V3AMX.getPropValue((Map)origProps, (String)"jaas-context"));
                attrMap.put("solarisAsGroups", V3AMX.getPropValue((Map)origProps, (String)"assign-groups"));
            } else if (classname.indexOf("JDBCRealm") != -1) {
                attrMap.put("jdbcJaax", V3AMX.getPropValue((Map)origProps, (String)"jaas-context"));
                attrMap.put("jdbcAsGroups", V3AMX.getPropValue((Map)origProps, (String)"assign-groups"));
                attrMap.put("datasourceJndi", V3AMX.getPropValue((Map)origProps, (String)"datasource-jndi"));
                attrMap.put("userTable", V3AMX.getPropValue((Map)origProps, (String)"user-table"));
                attrMap.put("userNameColumn", V3AMX.getPropValue((Map)origProps, (String)"user-name-column"));
                attrMap.put("passwordColumn", V3AMX.getPropValue((Map)origProps, (String)"password-column"));
                attrMap.put("groupTable", V3AMX.getPropValue((Map)origProps, (String)"group-table"));
                attrMap.put("groupNameColumn", V3AMX.getPropValue((Map)origProps, (String)"group-name-column"));
                attrMap.put("dbUser", V3AMX.getPropValue((Map)origProps, (String)"db-user"));
                attrMap.put("dbPassword", V3AMX.getPropValue((Map)origProps, (String)"db-password"));
                attrMap.put("digestAlgorithm", V3AMX.getPropValue((Map)origProps, (String)"digest-algorithm"));
                attrMap.put("encoding", V3AMX.getPropValue((Map)origProps, (String)"encoding"));
                attrMap.put("charset", V3AMX.getPropValue((Map)origProps, (String)"charset"));
            } else if (classname.indexOf("CertificateRealm") != -1) {
                attrMap.put("certAsGroups", V3AMX.getPropValue((Map)origProps, (String)"assign-groups"));
            }
        } else {
            handlerCtx.setOutputValue("classnameOption", (Object)"input");
            attrMap.put("predefinedClassname", Boolean.FALSE);
            attrMap.put("classnameInput", classname);
            List props = V3AMX.getNonSkipPropertiesMap((AMXConfigProxy)realm, null);
            handlerCtx.setOutputValue("properties", (Object)props);
        }
        handlerCtx.setOutputValue("attrMap", attrMap);
        handlerCtx.setOutputValue("realmClasses", (Object)realmClassList);
    }

    public static void saveRealm(HandlerContext handlerCtx) {
        String option = (String)handlerCtx.getInputValue("classnameOption");
        List propList = (List)handlerCtx.getInputValue("propList");
        Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
        String classname = "";
        try {
            if (option.equals("predefine")) {
                classname = (String)attrMap.get("classname");
                if (classname.indexOf("FileRealm") != -1) {
                    RealmsHandlers.putOptional(attrMap, propList, "file", "file");
                    RealmsHandlers.putOptional(attrMap, propList, "jaas-context", "fileJaax");
                    RealmsHandlers.putOptional(attrMap, propList, "assign-groups", "fileAsGroups");
                } else if (classname.indexOf("LDAPRealm") != -1) {
                    RealmsHandlers.putOptional(attrMap, propList, "jaas-context", "ldapJaax");
                    RealmsHandlers.putOptional(attrMap, propList, "base-dn", "baseDn");
                    RealmsHandlers.putOptional(attrMap, propList, "directory", "directory");
                    RealmsHandlers.putOptional(attrMap, propList, "assign-groups", "ldapAsGroups");
                } else if (classname.indexOf("SolarisRealm") != -1) {
                    RealmsHandlers.putOptional(attrMap, propList, "jaas-context", "solarisJaax");
                    RealmsHandlers.putOptional(attrMap, propList, "assign-groups", "solarisAsGroups");
                } else if (classname.indexOf("JDBCRealm") != -1) {
                    RealmsHandlers.putOptional(attrMap, propList, "jaas-context", "jdbcJaax");
                    RealmsHandlers.putOptional(attrMap, propList, "datasource-jndi", "datasourceJndi");
                    RealmsHandlers.putOptional(attrMap, propList, "user-table", "userTable");
                    RealmsHandlers.putOptional(attrMap, propList, "user-name-column", "userNameColumn");
                    RealmsHandlers.putOptional(attrMap, propList, "password-column", "passwordColumn");
                    RealmsHandlers.putOptional(attrMap, propList, "group-table", "groupTable");
                    RealmsHandlers.putOptional(attrMap, propList, "group-name-column", "groupNameColumn");
                    RealmsHandlers.putOptional(attrMap, propList, "db-user", "dbUser");
                    RealmsHandlers.putOptional(attrMap, propList, "db-password", "dbPassword");
                    RealmsHandlers.putOptional(attrMap, propList, "digest-algorithm", "digestAlgorithm");
                    RealmsHandlers.putOptional(attrMap, propList, "encoding", "encoding");
                    RealmsHandlers.putOptional(attrMap, propList, "charset", "charset");
                    RealmsHandlers.putOptional(attrMap, propList, "assign-groups", "jdbcAsGroups");
                } else if (classname.indexOf("CertificateRealm") != -1) {
                    RealmsHandlers.putOptional(attrMap, propList, "assign-groups", "certAsGroups");
                }
            } else {
                classname = (String)attrMap.get("classnameInput");
            }
            Boolean edit = (Boolean)handlerCtx.getInputValue("edit");
            if (edit.booleanValue()) {
                String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
                V3AMX.setAttribute((String)objectNameStr, (Attribute)new Attribute("Classname", classname));
                V3AMX.setProperties((String)objectNameStr, (List)propList, (boolean)false);
            } else {
                HashMap cMap = new HashMap();
                cMap.put(PROPERTY_NAME, attrMap.get(PROPERTY_NAME));
                cMap.put("Classname", attrMap.get("classname"));
                AMXConfigProxy amx = (AMXConfigProxy)V3AMX.objectNameToProxy((String)"v3:pp=/domain/configs/config[server-config],type=security-service");
                AMXConfigProxy child = amx.createChild("auth-realm", cMap);
                V3AMX.setProperties((String)child.objectName().toString(), (List)propList, (boolean)false);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    private static void putOptional(Map<String, String> attrMap, List propList, String propName, String key) {
        HashMap<String, String> oneProp = new HashMap<String, String>();
        oneProp.put(PROPERTY_NAME, propName);
        String value = attrMap.get(key);
        if (GuiUtil.isEmpty((String)value)) {
            return;
        }
        oneProp.put(PROPERTY_VALUE, attrMap.get(key));
        propList.add(oneProp);
    }

    static {
        String[] classnames = V3AMX.getInstance().getRealmsMgr().getPredefinedAuthRealmClassNames();
        realmClassList = new ArrayList();
        realmClassList.add("");
        for (int i = 0; i < classnames.length; ++i) {
            realmClassList.add(classnames[i]);
        }
        skipRealmPropsList.add("jaas-context");
        skipRealmPropsList.add("file");
        skipRealmPropsList.add("assign-groups");
        skipRealmPropsList.add("base-dn");
        skipRealmPropsList.add("directory");
        skipRealmPropsList.add("datasource-jndi");
        skipRealmPropsList.add("user-table");
        skipRealmPropsList.add("user-name-column");
        skipRealmPropsList.add("password-column");
        skipRealmPropsList.add("group-table");
        skipRealmPropsList.add("group-name-column");
        skipRealmPropsList.add("db-user");
        skipRealmPropsList.add("db-password");
        skipRealmPropsList.add("digest-algorithm");
        skipRealmPropsList.add("encoding");
        skipRealmPropsList.add("charset");
    }
}

