/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.validation.ConstraintDescriptor;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import org.hibernate.validation.engine.ConstraintValidatorContextImpl;
import org.hibernate.validation.engine.ConstraintViolationImpl;
import org.hibernate.validation.engine.MessageInterpolatorContext;
import org.hibernate.validation.engine.MetaConstraint;
import org.hibernate.validation.util.IdentitySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionContext<T> {
    public static final String PROPERTY_ROOT = "";
    public static final String PROPERTY_PATH_SEPERATOR = ".";
    private final T rootBean;
    private Class<T> rootBeanClass;
    private final Map<Class<?>, IdentitySet> processedObjects;
    private final Map<Object, Set<String>> processedPaths;
    private final List<ConstraintViolation<T>> failingConstraintViolations;
    private List<String> propertyPath;
    private Class<?> currentGroup;
    private Stack<Object> beanStack = new Stack();
    private boolean allowOneValidationPerPath = true;
    private final MessageInterpolator messageInterpolator;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final TraversableResolver traversableResolver;

    public static <T> ExecutionContext<T> getContextForValidate(T object, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver) {
        Class<?> rootBeanClass = object.getClass();
        return new ExecutionContext(rootBeanClass, object, object, messageInterpolator, constraintValidatorFactory, traversableResolver);
    }

    public static <T> ExecutionContext<T> getContextForValidateValue(Class<T> rootBeanClass, Object object, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver) {
        return new ExecutionContext<Object>(rootBeanClass, null, object, messageInterpolator, constraintValidatorFactory, traversableResolver);
    }

    public static <T> ExecutionContext<T> getContextForValidateProperty(T rootBean, Object object, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver) {
        Class<?> rootBeanClass = rootBean.getClass();
        return new ExecutionContext(rootBeanClass, rootBean, object, messageInterpolator, constraintValidatorFactory, traversableResolver);
    }

    private ExecutionContext(Class<T> rootBeanClass, T rootBean, Object object, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver) {
        this.rootBean = rootBean;
        this.rootBeanClass = rootBeanClass;
        this.messageInterpolator = messageInterpolator;
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.traversableResolver = traversableResolver;
        this.beanStack.push(object);
        this.processedObjects = new HashMap();
        this.processedPaths = new IdentityHashMap<Object, Set<String>>();
        this.propertyPath = new ArrayList<String>();
        this.failingConstraintViolations = new ArrayList<ConstraintViolation<T>>();
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public Object peekCurrentBean() {
        return this.beanStack.peek();
    }

    public Class<?> peekCurrentBeanType() {
        return this.beanStack.peek().getClass();
    }

    public void pushCurrentBean(Object validatedBean) {
        this.beanStack.push(validatedBean);
    }

    public void popCurrentBean() {
        this.beanStack.pop();
    }

    public T getRootBean() {
        return this.rootBean;
    }

    public Class<T> getRootBeanClass() {
        return this.rootBeanClass;
    }

    public Class<?> getCurrentGroup() {
        return this.currentGroup;
    }

    public void setCurrentGroup(Class<?> currentGroup) {
        this.currentGroup = currentGroup;
        this.markProcessed();
    }

    public boolean isAlreadyValidated(Object value) {
        boolean alreadyValidated = this.isAlreadyValidatedForCurrentGroup(value);
        if (alreadyValidated && this.allowOneValidationPerPath) {
            alreadyValidated = this.isAlreadyValidatedForPath(value);
        }
        return alreadyValidated;
    }

    private boolean isAlreadyValidatedForPath(Object value) {
        for (String path : this.processedPaths.get(value)) {
            if (!path.contains(this.peekPropertyPath()) && !this.peekPropertyPath().contains(path)) continue;
            return true;
        }
        return false;
    }

    private boolean isAlreadyValidatedForCurrentGroup(Object value) {
        IdentitySet objectsProcessedInCurrentGroups = this.processedObjects.get(this.currentGroup);
        return objectsProcessedInCurrentGroups != null && objectsProcessedInCurrentGroups.contains(value);
    }

    public void addConstraintFailures(List<ConstraintViolation<T>> failingConstraintViolations) {
        for (ConstraintViolation<T> violation : failingConstraintViolations) {
            this.addConstraintFailure(violation);
        }
    }

    public List<ConstraintViolation<T>> getFailingConstraints() {
        return this.failingConstraintViolations;
    }

    public void pushProperty(String property) {
        this.propertyPath.add(property);
    }

    public void popProperty() {
        if (this.propertyPath.size() > 0) {
            this.propertyPath.remove(this.propertyPath.size() - 1);
        }
    }

    public void markCurrentPropertyAsIndexed() {
        String property = this.peekProperty();
        property = property + "[]";
        this.propertyPath.remove(this.propertyPath.size() - 1);
        this.pushProperty(property);
    }

    public void setPropertyIndex(String index) {
        String property = this.peekProperty();
        property = property.replaceAll("\\[[0-9]*\\]$", "[" + index + "]");
        this.propertyPath.remove(this.propertyPath.size() - 1);
        this.pushProperty(property);
    }

    public String peekPropertyPath() {
        return this.buildPath(this.propertyPath.size() - 1);
    }

    public String peekProperty() {
        if (this.propertyPath.size() == 0) {
            return PROPERTY_ROOT;
        }
        return this.propertyPath.get(this.propertyPath.size() - 1);
    }

    public String peekParentPath() {
        return this.buildPath(this.propertyPath.size() - 2);
    }

    public boolean isValidationRequired(MetaConstraint metaConstraint) {
        if (!metaConstraint.getGroupList().contains(this.currentGroup)) {
            return false;
        }
        Class<?> rootBeanClass = this.rootBean == null ? null : this.rootBean.getClass();
        return this.traversableResolver.isTraversable(this.peekCurrentBean(), this.peekProperty(), rootBeanClass, this.peekPropertyPath(), metaConstraint.getElementType());
    }

    public List<ConstraintViolationImpl<T>> createConstraintViolations(Object value, ConstraintValidatorContextImpl constraintValidatorContext) {
        ArrayList<ConstraintViolationImpl<T>> constraintViolations = new ArrayList<ConstraintViolationImpl<T>>();
        for (ConstraintValidatorContextImpl.ErrorMessage error : constraintValidatorContext.getErrorMessages()) {
            ConstraintViolationImpl<T> violation = this.createConstraintViolation(value, error, constraintValidatorContext.getConstraintDescriptor());
            constraintViolations.add(violation);
        }
        return constraintViolations;
    }

    public ConstraintViolationImpl<T> createConstraintViolation(Object value, ConstraintValidatorContextImpl.ErrorMessage error, ConstraintDescriptor<?> descriptor) {
        String messageTemplate = error.getMessage();
        String interpolatedMessage = this.messageInterpolator.interpolate(messageTemplate, new MessageInterpolatorContext(descriptor, this.peekCurrentBean()));
        return new ConstraintViolationImpl<T>(messageTemplate, interpolatedMessage, this.getRootBeanClass(), this.getRootBean(), this.peekCurrentBean(), value, error.getProperty(), descriptor);
    }

    private String buildPath(int index) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i <= index; ++i) {
            builder.append(this.propertyPath.get(i));
            if (i >= index) continue;
            builder.append(PROPERTY_PATH_SEPERATOR);
        }
        return builder.toString();
    }

    private void markProcessed() {
        this.markProcessForCurrentGroup();
        if (this.allowOneValidationPerPath) {
            this.markProcessedForCurrentPath();
        }
    }

    private void markProcessedForCurrentPath() {
        if (this.processedPaths.containsKey(this.peekCurrentBean())) {
            this.processedPaths.get(this.peekCurrentBean()).add(this.peekPropertyPath());
        } else {
            HashSet<String> set = new HashSet<String>();
            set.add(this.peekPropertyPath());
            this.processedPaths.put(this.peekCurrentBean(), set);
        }
    }

    private void markProcessForCurrentGroup() {
        if (this.processedObjects.containsKey(this.currentGroup)) {
            this.processedObjects.get(this.currentGroup).add(this.peekCurrentBean());
        } else {
            IdentitySet set = new IdentitySet();
            set.add(this.peekCurrentBean());
            this.processedObjects.put(this.currentGroup, set);
        }
    }

    private void addConstraintFailure(ConstraintViolation<T> failingConstraintViolation) {
        int i = this.failingConstraintViolations.indexOf(failingConstraintViolation);
        if (i == -1) {
            this.failingConstraintViolations.add(failingConstraintViolation);
        }
    }
}

