/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleLifecycleListener;
import com.sun.enterprise.module.ModulesRegistry;
import java.beans.PropertyChangeEvent;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import org.glassfish.admin.monitor.StatsProviderManagerDelegateImpl;
import org.glassfish.admin.monitor.StatsProviderRegistry;
import org.glassfish.api.Startup;
import org.glassfish.api.amx.MBeanListener;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.provider.ProbeProviderFactory;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@Scoped(value=Singleton.class)
public class MonitoringBootstrap
implements EventListener,
Startup,
PostConstruct,
ModuleLifecycleListener,
ConfigListener {
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    @Inject
    private Domain domain;
    @Inject
    ModulesRegistry registry;
    @Inject
    protected ProbeProviderFactory probeProviderFactory;
    @Inject
    protected ProbeClientMediator pcm;
    @Inject
    Events events;
    @Inject(optional=true)
    ModuleMonitoringLevels config = null;
    @Inject(optional=true)
    MonitoringService monitoringService = null;
    @Inject
    private ProbeRegistry probeRegistry;
    Map<String, Module> map = Collections.synchronizedMap(new WeakHashMap());
    private final boolean debug = false;
    private final String PROBE_PROVIDER_CLASS_NAMES = "probe-provider-class-names";
    private final String PROBE_PROVIDER_XML_FILE_NAMES = "probe-provider-xml-file-names";
    private final String DELIMITER = ",";
    private StatsProviderManagerDelegateImpl spmd;

    public void postConstruct() {
        this.events.register((EventListener)this);
        this.registry.register((ModuleLifecycleListener)this);
        for (Module m : this.registry.getModules()) {
            this.moduleStarted(m);
        }
    }

    public void setStatsProviderManagerDelegate() {
        this.spmd = new StatsProviderManagerDelegateImpl(this.pcm, this.probeRegistry, this.mrdr, this.domain, this.monitoringService);
        StatsProviderManager.setStatsProviderManagerDelegate(this.spmd);
        this.mprint(" StatsProviderManagerDelegate is assigned ********************");
        MBeanListener.listenForDomainRoot((MBeanServerConnection)ManagementFactory.getPlatformMBeanServer(), (MBeanListener.Callback)this.spmd);
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            this.mprint("***************************************");
            this.mprint("**** SERVER_READY event received *****");
            this.mprint("***************************************");
            this.setStatsProviderManagerDelegate();
        }
    }

    public void moduleResolved(Module module) {
    }

    public synchronized void moduleStarted(Module module) {
        if (module == null) {
            return;
        }
        String str = module.getName();
        if (!this.map.containsKey(str)) {
            this.map.put(str, module);
            this.addProvider(module);
        }
    }

    public synchronized void moduleStopped(Module module) {
        if (module == null) {
            return;
        }
        String str = module.getName();
        if (this.map.containsKey(str)) {
            this.map.remove(str);
            this.removeProvider(module);
        }
    }

    private void addProvider(Module module) {
        String mname = module.getName();
        ClassLoader mcl = module.getClassLoader();
        ModuleDefinition md = module.getModuleDefinition();
        Manifest mf = null;
        if (md != null) {
            mf = md.getManifest();
        }
        if (mf != null) {
            Attributes attrs = mf.getMainAttributes();
            String cnames = null;
            String xnames = null;
            if (attrs != null) {
                StringTokenizer st;
                cnames = attrs.getValue("probe-provider-class-names");
                if (cnames != null) {
                    this.mprint("**************cnames = " + cnames);
                }
                if (cnames != null) {
                    st = new StringTokenizer(cnames, ",");
                    while (st.hasMoreTokens()) {
                        try {
                            this.processProbeProviderClass(mcl.loadClass(st.nextToken()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if ((xnames = attrs.getValue("probe-provider-xml-file-names")) != null) {
                    this.mprint("xnames = " + xnames);
                    st = new StringTokenizer(xnames, ",");
                    while (st.hasMoreTokens()) {
                        this.processProbeProviderXML(mcl, st.nextToken());
                    }
                }
            }
        }
    }

    private void removeProvider(Module module) {
        this.mprint("removeProvider ...");
    }

    private void processProbeProviderClass(Class cls) {
        this.mprint("processProbeProviderClass for " + cls);
        try {
            this.probeProviderFactory.getProbeProvider(cls);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MonitoringBootstrap.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MonitoringBootstrap.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void processProbeProviderXML(ClassLoader mcl, String xname) {
        this.probeProviderFactory.processXMLProbeProviders(mcl, xname);
    }

    private void mprint(String str) {
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] propertyChangeEvents) {
        for (PropertyChangeEvent event : propertyChangeEvents) {
            String propName;
            if (event.getSource() instanceof ModuleMonitoringLevels) {
                propName = event.getPropertyName();
                boolean enabled = this.getEnabledValue(event.getNewValue().toString());
                StatsProviderRegistry spr = this.spmd.getStatsProviderRegistry();
                if (spr != null) {
                    spr.setConfigEnabled(propName, enabled);
                    if (enabled) {
                        spr.enableStatsProvider(propName);
                    } else {
                        spr.disableStatsProvider(propName);
                    }
                }
            }
            if (!(event.getSource() instanceof MonitoringService) || !(propName = event.getPropertyName()).equals("mbean-enabled")) continue;
            StatsProviderRegistry spr = this.spmd.getStatsProviderRegistry();
            if (event.getNewValue().toString().equals("true")) {
                spr.registerAllGmbal();
                continue;
            }
            spr.unregisterAllGmbal();
        }
        return null;
    }

    private boolean getEnabledValue(String enabledStr) {
        return !"OFF".equals(enabledStr);
    }
}

