/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.naming;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.resource.naming.ExternalNameNotFoundException;
import com.sun.enterprise.resource.naming.ProxyRefAddr;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;

public class JndiProxyObjectFactory
implements ObjectFactory {
    private static Hashtable contextMap = new Hashtable();

    public static Context removeInitialContext(String jndiName) {
        return (Context)contextMap.remove(jndiName);
    }

    private Context loadInitialContext(String factoryClass, Hashtable env) {
        Object factory = ConnectorsUtil.loadObject((String)factoryClass);
        if (factory == null) {
            System.err.println("Cannot load external-jndi-resource factory-class '" + factoryClass + "'");
            return null;
        }
        if (!(factory instanceof InitialContextFactory)) {
            System.err.println("external-jndi-resource factory-class '" + factoryClass + "' must be of type " + "javax.naming.spi.InitialContextFactory");
            return null;
        }
        Context context = null;
        try {
            context = ((InitialContextFactory)factory).getInitialContext(env);
        }
        catch (NamingException ne) {
            System.err.println("Exception thrown creating initial context for external JNDI factory '" + factoryClass + "' " + ne.getMessage());
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        String jndiLookupName = "";
        String jndiFactoryClass = null;
        String bindName = null;
        Reference ref = (Reference)obj;
        Enumeration<RefAddr> addrs = ref.getAll();
        while (addrs.hasMoreElements()) {
            RefAddr addr = addrs.nextElement();
            String prop = addr.getType();
            if (prop.equals("jndiName")) {
                bindName = (String)addr.getContent();
                continue;
            }
            if (prop.equals("jndiLookupName")) {
                jndiLookupName = (String)addr.getContent();
                continue;
            }
            if (!prop.equals("jndiFactoryClass")) continue;
            jndiFactoryClass = (String)addr.getContent();
        }
        if (bindName == null) {
            throw new NamingException("JndiProxyObjectFactory: no bindName context info");
        }
        ProxyRefAddr contextAddr = (ProxyRefAddr)ref.get(bindName);
        Hashtable env = null;
        if (contextAddr == null || jndiFactoryClass == null || (env = (Hashtable)contextAddr.getContent()) == null) {
            throw new NamingException("JndiProxyObjectFactory: no info in the reference about the target context; contextAddr = " + contextAddr + " " + "env = " + env + " factoryClass = " + jndiFactoryClass);
        }
        Context context = (Context)contextMap.get(bindName);
        if (context == null) {
            Hashtable hashtable = contextMap;
            synchronized (hashtable) {
                context = (Context)contextMap.get(bindName);
                if (context == null) {
                    context = this.loadInitialContext(jndiFactoryClass, env);
                    contextMap.put(bindName, context);
                }
            }
        }
        if (context == null) {
            throw new NamingException("JndiProxyObjectFactory no InitialContext" + jndiFactoryClass);
        }
        try {
            return context.lookup(jndiLookupName);
        }
        catch (NameNotFoundException e) {
            throw new ExternalNameNotFoundException(e);
        }
    }
}

