/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby.rack;

import com.sun.grizzly.jruby.RackGrizzlyAdapter;
import com.sun.grizzly.jruby.rack.DefaultRackApplicationFactory;
import java.io.File;
import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.runtime.builtin.IRubyObject;

public class GenericApplicationFactory
extends DefaultRackApplicationFactory {
    private final File configScript;

    public GenericApplicationFactory(String config, RackGrizzlyAdapter adapter) {
        super(adapter);
        this.configScript = new File(config);
        if (!this.configScript.exists()) {
            String msg = "Specified Rack configuration script " + this.configScript.getAbsolutePath() + "could not be found, aborting";
            this.logger.severe(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    public IRubyObject createApplicationObject(Ruby runtime) {
        String path;
        runtime.evalScriptlet("require 'rubygems'");
        runtime.evalScriptlet("gem 'rack'");
        runtime.evalScriptlet("require 'jruby/rack'");
        runtime.evalScriptlet("require 'rack/handler/grizzly'");
        try {
            path = this.configScript.getCanonicalPath();
        }
        catch (IOException e) {
            path = this.configScript.getAbsolutePath();
        }
        IRubyObject app = runtime.evalScriptlet("load '" + path + "'");
        runtime.defineReadonlyVariable("$glassfish_app", app);
        return runtime.evalScriptlet("Rack::Handler::Grizzly.new($glassfish_app)");
    }
}

