/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Initializer;
import javax.enterprise.inject.spi.Decorator;
import javax.persistence.EntityManager;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.DecoratorBean;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.ejb.EJBApiAbstraction;
import org.jboss.webbeans.ejb.spi.EjbServices;
import org.jboss.webbeans.injection.ConstructorInjectionPoint;
import org.jboss.webbeans.injection.FieldInjectionPoint;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.injection.ParameterInjectionPoint;
import org.jboss.webbeans.injection.WBInjectionPoint;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.WBConstructor;
import org.jboss.webbeans.introspector.WBField;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.metadata.cache.MetaAnnotationStore;
import org.jboss.webbeans.persistence.PersistenceApiAbstraction;
import org.jboss.webbeans.persistence.spi.JpaServices;
import org.jboss.webbeans.resources.spi.ResourceServices;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBean<T>
extends AbstractClassBean<T> {
    private static LogProvider log = Logging.getLogProvider(SimpleBean.class);
    private ConstructorInjectionPoint<T> constructor;
    private WBMethod<?> postConstruct;
    private WBMethod<?> preDestroy;
    private Set<WBInjectionPoint<?, ?>> ejbInjectionPoints;
    private Set<WBInjectionPoint<?, ?>> persistenceUnitInjectionPoints;
    private Set<WBInjectionPoint<?, ?>> resourceInjectionPoints;
    private SimpleBean<?> specializedBean;

    public static <T> SimpleBean<T> of(WBClass<T> clazz, BeanManagerImpl manager) {
        return new SimpleBean<T>(clazz, manager);
    }

    protected SimpleBean(WBClass<T> type, BeanManagerImpl manager) {
        super(type, manager);
        this.initType();
        this.initTypes();
        this.initBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T create(CreationalContext<T> creationalContext) {
        try {
            DependentContext.instance().setActive(true);
            T instance = null;
            instance = this.constructor.newInstance(this.manager, creationalContext);
            instance = this.applyDecorators(instance, creationalContext);
            creationalContext.push(instance);
            this.injectEjbAndCommonFields(instance);
            this.injectBoundFields(instance, creationalContext);
            this.callInitializers(instance, creationalContext);
            this.callPostConstruct(instance);
            T t = instance;
            return t;
        }
        finally {
            DependentContext.instance().setActive(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        try {
            DependentContext.instance().setActive(true);
            this.callPreDestroy(instance);
            creationalContext.release();
        }
        catch (Exception e) {
            log.error("Error destroying " + this.toString(), e);
        }
        finally {
            DependentContext.instance().setActive(false);
        }
    }

    protected void callPreDestroy(T instance) {
        WBMethod<?> preDestroy = this.getPreDestroy();
        if (preDestroy != null) {
            try {
                preDestroy.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke " + preDestroy + " on " + instance, e);
            }
        }
    }

    protected void callPostConstruct(T instance) {
        WBMethod<?> postConstruct = this.getPostConstruct();
        if (postConstruct != null) {
            try {
                postConstruct.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke " + postConstruct + " on " + instance, e);
            }
        }
    }

    protected void initEjbInjectionPoints() {
        Class<? extends Annotation> ejbAnnotationType = this.manager.getServices().get(EJBApiAbstraction.class).EJB_ANNOTATION_CLASS;
        this.ejbInjectionPoints = new HashSet();
        for (WBField<?> wBField : this.annotatedItem.getAnnotatedFields(ejbAnnotationType)) {
            this.ejbInjectionPoints.add(FieldInjectionPoint.of(this, wBField));
        }
        for (WBMethod wBMethod : this.annotatedItem.getAnnotatedMethods(ejbAnnotationType)) {
            this.ejbInjectionPoints.add(MethodInjectionPoint.of(this, wBMethod));
        }
    }

    protected void initPersistenceUnitInjectionPoints() {
        this.persistenceUnitInjectionPoints = new HashSet();
        Class<? extends Annotation> persistenceContextAnnotationType = this.manager.getServices().get(PersistenceApiAbstraction.class).PERSISTENCE_CONTEXT_ANNOTATION_CLASS;
        Object extendedPersistenceContextEnum = this.manager.getServices().get(PersistenceApiAbstraction.class).EXTENDED_PERSISTENCE_CONTEXT_ENUM_VALUE;
        for (WBField<?> wBField : this.annotatedItem.getAnnotatedFields(persistenceContextAnnotationType)) {
            if (extendedPersistenceContextEnum.equals(Reflections.invokeAndWrap("type", (Object)wBField.getAnnotation(persistenceContextAnnotationType), new Object[0]))) {
                throw new DefinitionException("Cannot inject an extended persistence context into " + wBField);
            }
            this.persistenceUnitInjectionPoints.add(FieldInjectionPoint.of(this, wBField));
        }
        for (WBMethod wBMethod : this.annotatedItem.getAnnotatedMethods(persistenceContextAnnotationType)) {
            if (extendedPersistenceContextEnum.equals(Reflections.invokeAndWrap("type", (Object)wBMethod.getAnnotation(persistenceContextAnnotationType), new Object[0]))) {
                throw new DefinitionException("Cannot inject an extended persistence context into " + wBMethod);
            }
            this.persistenceUnitInjectionPoints.add(MethodInjectionPoint.of(this, wBMethod));
        }
    }

    protected void initResourceInjectionPoints() {
        Class<? extends Annotation> resourceAnnotationType = this.manager.getServices().get(EJBApiAbstraction.class).RESOURCE_ANNOTATION_CLASS;
        this.resourceInjectionPoints = new HashSet();
        for (WBField<?> field : this.annotatedItem.getAnnotatedFields(resourceAnnotationType)) {
            this.resourceInjectionPoints.add(FieldInjectionPoint.of(this, field));
        }
    }

    protected void injectEjbAndCommonFields(T beanInstance) {
        EjbServices ejbServices = this.manager.getServices().get(EjbServices.class);
        JpaServices jpaServices = this.manager.getServices().get(JpaServices.class);
        ResourceServices resourceServices = this.manager.getServices().get(ResourceServices.class);
        if (ejbServices != null) {
            for (WBInjectionPoint<?, ?> injectionPoint : this.ejbInjectionPoints) {
                Object ejbInstance = ejbServices.resolveEjb(injectionPoint);
                injectionPoint.inject(beanInstance, ejbInstance);
            }
        }
        if (jpaServices != null) {
            for (WBInjectionPoint<?, ?> injectionPoint : this.persistenceUnitInjectionPoints) {
                EntityManager puInstance = jpaServices.resolvePersistenceContext(injectionPoint);
                injectionPoint.inject(beanInstance, puInstance);
            }
        }
        if (resourceServices != null) {
            for (WBInjectionPoint<?, ?> injectionPoint : this.resourceInjectionPoints) {
                Object resourceInstance = resourceServices.resolveResource(injectionPoint);
                injectionPoint.inject(beanInstance, resourceInstance);
            }
        }
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            this.initConstructor();
            super.initialize(environment);
            this.initPostConstruct();
            this.initPreDestroy();
            if (this.getManager().getServices().contains(EjbServices.class)) {
                this.initEjbInjectionPoints();
            }
            if (this.getManager().getServices().contains(JpaServices.class)) {
                this.initPersistenceUnitInjectionPoints();
            }
            if (this.getManager().getServices().contains(ResourceServices.class)) {
                this.initResourceInjectionPoints();
            }
        }
    }

    @Override
    protected void initInjectionPoints() {
        super.initInjectionPoints();
        for (ParameterInjectionPoint<?> parameter : this.constructor.getParameters()) {
            this.injectionPoints.add(ParameterInjectionPoint.of(this, parameter));
        }
    }

    @Override
    protected void checkType() {
        if (this.getAnnotatedItem().isNonStaticMemberClass()) {
            throw new DefinitionException("Simple bean " + this.type + " cannot be a non-static inner class");
        }
        if (this.getAnnotatedItem().isParameterizedType()) {
            throw new DefinitionException("Simple bean " + this.type + " cannot be a parameterized type");
        }
        boolean passivating = this.manager.getServices().get(MetaAnnotationStore.class).getScopeModel(this.scopeType).isPassivating();
        if (passivating && !this._serializable) {
            throw new DefinitionException("Simple bean declaring a passivating scope must have a serializable implementation class " + this.toString());
        }
        if (this.hasDecorators()) {
            if (this.getAnnotatedItem().isFinal()) {
                throw new DefinitionException("Bean class which has decorators cannot be declared final " + this);
            }
            for (Decorator<?> decorator : this.getDecorators()) {
                if (decorator instanceof DecoratorBean) {
                    DecoratorBean decoratorBean = (DecoratorBean)decorator;
                    for (WBMethod<?> decoratorMethod : decoratorBean.getAnnotatedItem().getMethods()) {
                        WBMethod method = this.getAnnotatedItem().getMethod(decoratorMethod.getSignature());
                        if (method == null || method.isStatic() || method.isPrivate() || !method.isFinal()) continue;
                        throw new DefinitionException("Decorated bean method " + method + " (decorated by " + decoratorMethod + ") cannot be declarted final");
                    }
                    continue;
                }
                throw new IllegalStateException("Can only operate on container provided decorators " + decorator);
            }
        }
    }

    @Override
    protected void checkBeanImplementation() {
        super.checkBeanImplementation();
        if (!this.isDependent()) {
            for (WBField<?> field : this.getAnnotatedItem().getFields()) {
                if (!field.isPublic() || field.isStatic()) continue;
                throw new DefinitionException("Normal scoped Web Bean implementation class has a public field " + this.getAnnotatedItem());
            }
        }
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        super.preSpecialize(environment);
        if (environment.getEjbDescriptors().containsKey(this.getAnnotatedItem().getSuperclass().getJavaClass())) {
            throw new DefinitionException("Simple bean must specialize a simple bean");
        }
    }

    @Override
    protected void specialize(BeanDeployerEnvironment environment) {
        if (environment.getClassBean(this.getAnnotatedItem().getSuperclass()) == null) {
            throw new DefinitionException(this.toString() + " does not specialize a bean");
        }
        AbstractClassBean<?> specializedBean = environment.getClassBean(this.getAnnotatedItem().getSuperclass());
        if (!(specializedBean instanceof SimpleBean)) {
            throw new DefinitionException(this.toString() + " doesn't have a simple bean as a superclass " + specializedBean);
        }
        this.specializedBean = (SimpleBean)specializedBean;
    }

    protected void initConstructor() {
        Set initializerAnnotatedConstructors = this.getAnnotatedItem().getAnnotatedConstructors(Initializer.class);
        log.trace("Found " + initializerAnnotatedConstructors + " constructors annotated with @Initializer for " + this.getType());
        if (initializerAnnotatedConstructors.size() > 1) {
            if (initializerAnnotatedConstructors.size() > 1) {
                throw new DefinitionException("Cannot have more than one constructor annotated with @Initializer for " + this.getType());
            }
        } else if (initializerAnnotatedConstructors.size() == 1) {
            this.constructor = ConstructorInjectionPoint.of(this, initializerAnnotatedConstructors.iterator().next());
            log.trace("Exactly one constructor (" + this.constructor + ") annotated with @Initializer defined, using it as the bean constructor for " + this.getType());
            return;
        }
        if (this.getAnnotatedItem().getNoArgsConstructor() != null) {
            this.constructor = ConstructorInjectionPoint.of(this, this.getAnnotatedItem().getNoArgsConstructor());
            log.trace("Exactly one constructor (" + this.constructor + ") defined, using it as the bean constructor for " + this.getType());
            return;
        }
        throw new DefinitionException("Cannot determine constructor to use for " + this.getType());
    }

    protected void initPostConstruct() {
        Set<WBMethod<?>> postConstructMethods = this.getAnnotatedItem().getAnnotatedMethods(PostConstruct.class);
        log.trace("Found " + postConstructMethods + " constructors annotated with @Initializer for " + this.getType());
        if (postConstructMethods.size() > 1) {
            throw new DefinitionException("Cannot have more than one post construct method annotated with @PostConstruct for " + this.getType());
        }
        if (postConstructMethods.size() == 1) {
            this.postConstruct = postConstructMethods.iterator().next();
            log.trace("Exactly one post construct method (" + this.postConstruct + ") for " + this.getType());
            return;
        }
    }

    protected void initPreDestroy() {
        Set<WBMethod<?>> preDestroyMethods = this.getAnnotatedItem().getAnnotatedMethods(PreDestroy.class);
        log.trace("Found " + preDestroyMethods + " constructors annotated with @Initializer for " + this.getType());
        if (preDestroyMethods.size() > 1) {
            throw new DefinitionException("Cannot have more than one pre destroy method annotated with @PreDestroy for " + this.getType());
        }
        if (preDestroyMethods.size() == 1) {
            this.preDestroy = preDestroyMethods.iterator().next();
            log.trace("Exactly one post construct method (" + this.preDestroy + ") for " + this.getType());
            return;
        }
    }

    public WBConstructor<T> getConstructor() {
        return this.constructor;
    }

    public WBMethod<?> getPostConstruct() {
        return this.postConstruct;
    }

    public WBMethod<?> getPreDestroy() {
        return this.preDestroy;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Names.scopeTypeToString(this.getScopeType()));
        if (this.getName() == null) {
            buffer.append("unnamed simple bean");
        } else {
            buffer.append("simple bean '" + this.getName() + "'");
        }
        buffer.append(" ").append(this.getType().getName()).append(", ");
        buffer.append(" API types = ").append(Names.typesToString(this.getTypes())).append(", binding types = " + Names.annotationsToString(this.getBindings()));
        return buffer.toString();
    }

    @Override
    public SimpleBean<?> getSpecializedBean() {
        return this.specializedBean;
    }
}

