/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.context;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.bootstrap.api.Lifecycle;
import org.jboss.webbeans.context.ConversationContext;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.context.RequestContext;
import org.jboss.webbeans.context.SessionContext;
import org.jboss.webbeans.context.api.BeanStore;
import org.jboss.webbeans.conversation.ConversationManager;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.servlet.ConversationBeanStore;

public class ContextLifecycle
implements Lifecycle {
    private static LogProvider log = Logging.getLogProvider(ContextLifecycle.class);
    @Any
    private Instance<ConversationManager> conversationManager;

    public void restoreSession(String id, BeanStore sessionBeanStore) {
        log.trace("Restoring session " + id);
        SessionContext.instance().setBeanStore(sessionBeanStore);
        SessionContext.instance().setActive(true);
    }

    public void endSession(String id, BeanStore sessionBeanStore) {
        log.trace("Ending session " + id);
        SessionContext.instance().setActive(true);
        ConversationManager conversationManager = CurrentManager.rootManager().getInstanceByType(ConversationManager.class, new Annotation[0]);
        conversationManager.destroyAllConversations();
        SessionContext.instance().destroy();
        SessionContext.instance().setBeanStore(null);
        SessionContext.instance().setActive(false);
    }

    public void beginRequest(String id, BeanStore requestBeanStore) {
        log.trace("Starting request " + id);
        RequestContext.instance().setBeanStore(requestBeanStore);
        RequestContext.instance().setActive(true);
        DependentContext.instance().setActive(true);
    }

    public void endRequest(String id, BeanStore requestBeanStore) {
        log.trace("Ending request " + id);
        RequestContext.instance().setBeanStore(requestBeanStore);
        DependentContext.instance().setActive(false);
        RequestContext.instance().destroy();
        RequestContext.instance().setActive(false);
    }

    protected void restoreConversation(String id, BeanStore conversationBeanStore) {
        log.trace("Starting conversation " + id);
        ConversationContext.instance().setBeanStore(conversationBeanStore);
        ConversationContext.instance().setActive(true);
    }

    protected void destroyConversation(String id, ConversationBeanStore conversationBeanStore) {
        log.trace("Ending conversation " + id);
        ConversationContext destructionContext = new ConversationContext();
        destructionContext.setBeanStore(conversationBeanStore);
        destructionContext.destroy();
    }
}

