/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.MethodSignature;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.introspector.WBParameter;
import org.jboss.webbeans.introspector.WBType;
import org.jboss.webbeans.introspector.jlr.AbstractWBMember;
import org.jboss.webbeans.introspector.jlr.MethodSignatureImpl;
import org.jboss.webbeans.introspector.jlr.WBParameterImpl;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WBMethodImpl<T>
extends AbstractWBMember<T, Method>
implements WBMethod<T> {
    private final Method method;
    private final List<WBParameter<?>> parameters;
    private final ListMultimap<Class<? extends Annotation>, WBParameter<?>> annotatedParameters;
    private final String propertyName;
    private final WBType<?> declaringClass;
    private String toString;
    private final MethodSignature signature;

    public static <T> WBMethodImpl<T> of(Method method, WBType<?> declaringClass, ClassTransformer classTransformer) {
        return new WBMethodImpl<T>(method, declaringClass, classTransformer);
    }

    protected WBMethodImpl(Method method, WBType<?> declaringClass, ClassTransformer classTransformer) {
        super(AnnotationStore.of(method, classTransformer.getTypeStore()), method, method.getReturnType(), method.getGenericReturnType());
        this.method = method;
        this.method.setAccessible(true);
        this.declaringClass = declaringClass;
        this.parameters = new ArrayList();
        this.annotatedParameters = Multimaps.newListMultimap(new HashMap(), new Supplier<List<WBParameter<?>>>(){

            @Override
            public List<WBParameter<?>> get() {
                return new ArrayList();
            }
        });
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            WBParameter<?> parameter;
            Type type;
            Class<?> clazz;
            if (method.getParameterAnnotations()[i].length > 0) {
                clazz = method.getParameterTypes()[i];
                type = method.getGenericParameterTypes()[i];
                parameter = WBParameterImpl.of(method.getParameterAnnotations()[i], clazz, type, this, classTransformer);
                this.parameters.add(parameter);
                for (Annotation annotation : parameter.getAnnotations()) {
                    if (!MAPPED_PARAMETER_ANNOTATIONS.contains(annotation.annotationType())) continue;
                    this.annotatedParameters.put(annotation.annotationType(), parameter);
                }
                continue;
            }
            clazz = method.getParameterTypes()[i];
            type = method.getGenericParameterTypes()[i];
            parameter = WBParameterImpl.of(new Annotation[0], clazz, type, this, classTransformer);
            this.parameters.add(parameter);
        }
        String propertyName = Reflections.getPropertyName(this.getDelegate());
        this.propertyName = propertyName == null ? this.getName() : propertyName;
        this.signature = new MethodSignatureImpl(this);
    }

    @Override
    public Method getAnnotatedMethod() {
        return this.method;
    }

    @Override
    public Method getDelegate() {
        return this.method;
    }

    @Override
    public List<WBParameter<?>> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public Class<?>[] getParameterTypesAsArray() {
        return this.method.getParameterTypes();
    }

    @Override
    public List<WBParameter<?>> getAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableList(this.annotatedParameters.get(annotationType));
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof WBMethod) {
            WBMethod that = (WBMethod)other;
            return this.getDeclaringType().equals(that.getDeclaringType()) && this.getName().equals(that.getName()) && ((Object)this.getParameters()).equals(that.getParameters());
        }
        return false;
    }

    @Override
    public boolean isEquivalent(Method method) {
        return this.getDeclaringType().isEquivalent(method.getDeclaringClass()) && this.getName().equals(method.getName()) && Arrays.equals(this.getParameterTypesAsArray(), method.getParameterTypes());
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public T invokeOnInstance(Object instance, Object ... parameters) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method = Reflections.lookupMethod(this.getName(), this.getParameterTypesAsArray(), instance);
        Object result = method.invoke(instance, parameters);
        return (T)result;
    }

    @Override
    public T invoke(Object instance, Object ... parameters) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object result = this.method.invoke(instance, parameters);
        return (T)result;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public WBType<?> getDeclaringType() {
        return this.declaringClass;
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Annotated method on class " + this.getDeclaringType().getName() + Names.methodToString(this.method);
        return this.toString;
    }

    @Override
    public MethodSignature getSignature() {
        return this.signature;
    }
}

