/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.util.serviceProvider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLoader<S>
implements Iterable<S> {
    private Log log = Logging.getLog(ServiceLoader.class);
    private static final String SERVICES = "META-INF/services/";
    private final String serviceFile;
    private final ClassLoader loader;
    private Set<S> providers;

    public static <S> ServiceLoader<S> load(Class<S> service) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return ServiceLoader.load(service, loader);
    }

    public static <S> ServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        if (loader == null) {
            loader = service.getClassLoader();
        }
        return new ServiceLoader<S>(service, loader);
    }

    public static <S> ServiceLoader<S> loadInstalled(Class<S> service) {
        throw new UnsupportedOperationException();
    }

    private ServiceLoader(Class<S> service, ClassLoader loader) {
        this.loader = loader;
        this.serviceFile = SERVICES + service.getName();
    }

    public void reload() {
        this.providers = new HashSet<S>();
        Enumeration<URL> enumeration = null;
        boolean errorOccurred = false;
        try {
            enumeration = this.loader.getResources(this.serviceFile);
        }
        catch (IOException ioe) {
            errorOccurred = true;
        }
        if (!errorOccurred) {
            while (enumeration.hasMoreElements()) {
                try {
                    URL url = enumeration.nextElement();
                    InputStream is = url.openStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String line = reader.readLine();
                    while (null != line) {
                        block14: {
                            try {
                                int comment = line.indexOf(35);
                                if (comment > -1) {
                                    line = line.substring(0, comment);
                                }
                                line.trim();
                                if (line.length() <= 0) break block14;
                                try {
                                    Class<?> clazz = this.loader.loadClass(line);
                                    Object instance = clazz.newInstance();
                                    this.providers.add(instance);
                                }
                                catch (NoClassDefFoundError e) {
                                    this.log.warn((Object)"Error loading #0", line, e);
                                    throw e;
                                }
                                catch (InstantiationException e) {
                                    this.log.warn((Object)"Error loading #0", line, e);
                                    throw e;
                                }
                                catch (IllegalAccessException e) {
                                    this.log.warn((Object)"Error loading #0", line, e);
                                    throw e;
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        line = reader.readLine();
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }

    @Override
    public Iterator<S> iterator() {
        if (this.providers == null) {
            this.reload();
        }
        return this.providers.iterator();
    }

    public String toString() {
        return "Services for " + this.serviceFile;
    }
}

