/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.xml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.InjectionException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.webbeans.DeploymentException;
import org.jboss.webbeans.resources.spi.ResourceLoader;
import org.jboss.webbeans.resources.spi.ResourceLoadingException;
import org.jboss.webbeans.util.dom.NodeListIterable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansXmlParser {
    private final Iterable<URL> beansXml;
    private final ResourceLoader resourceLoader;
    private List<Class<? extends Annotation>> enabledDeploymentTypes;
    private List<Class<?>> enabledDecoratorClasses;
    private List<Class<?>> enabledInterceptorClasses;

    public List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        return this.enabledDeploymentTypes;
    }

    public List<Class<?>> getEnabledDecoratorClasses() {
        return this.enabledDecoratorClasses;
    }

    public List<Class<?>> getEnabledInterceptorClasses() {
        return Collections.emptyList();
    }

    public BeansXmlParser(ResourceLoader resourceLoader, Iterable<URL> beansXml) {
        this.beansXml = beansXml;
        this.resourceLoader = resourceLoader;
    }

    public void parse() {
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new InjectionException("Error configuring XML parser", e);
        }
        ArrayList<XmlElement> deployElements = new ArrayList<XmlElement>();
        ArrayList<XmlElement> decoratorElements = new ArrayList<XmlElement>();
        ArrayList<XmlElement> interceptorElements = new ArrayList<XmlElement>();
        for (URL url : this.beansXml) {
            Document document;
            boolean fileHasContents;
            InputStream is;
            try {
                is = url.openStream();
                fileHasContents = is.available() > 0;
            }
            catch (IOException e) {
                throw new InjectionException("Error loading beans.xml " + url.toString(), e);
            }
            if (!fileHasContents) continue;
            try {
                document = documentBuilder.parse(is);
                document.normalize();
            }
            catch (SAXException e) {
                throw new DeploymentException("Error parsing beans.xml " + url.toString(), e);
            }
            catch (IOException e) {
                throw new DeploymentException("Error loading beans.xml " + url.toString(), e);
            }
            Element beans = document.getDocumentElement();
            for (Node child : new NodeListIterable(beans.getChildNodes())) {
                if (child instanceof Element && "deploy".equals(child.getNodeName())) {
                    deployElements.add(new XmlElement(url, (Element)child));
                }
                if (child instanceof Element && "interceptors".equals(child.getNodeName())) {
                    interceptorElements.add(new XmlElement(url, (Element)child));
                }
                if (!(child instanceof Element) || !"decorators".equals(child.getNodeName())) continue;
                decoratorElements.add(new XmlElement(url, (Element)child));
            }
        }
        if (deployElements.size() > 1) {
            throw new DeploymentException("<deploy> can only be specified once, but it is specified muliple times " + deployElements);
        }
        if (deployElements.size() == 1) {
            this.enabledDeploymentTypes = new ArrayList<Class<? extends Annotation>>();
            this.enabledDeploymentTypes.addAll(BeansXmlParser.processDeployElement(this.resourceLoader, (XmlElement)deployElements.get(0)));
        }
        if (decoratorElements.size() > 1) {
            throw new DeploymentException("<decorator> can only be specified once, but it is specified muliple times " + decoratorElements);
        }
        if (decoratorElements.size() == 1) {
            this.enabledDecoratorClasses = new ArrayList();
            this.enabledDecoratorClasses.addAll(BeansXmlParser.processElement(this.resourceLoader, (XmlElement)decoratorElements.get(0)));
        }
        if (interceptorElements.size() > 1) {
            throw new DeploymentException("<interceptor> can only be specified once, but it is specified muliple times " + interceptorElements);
        }
        if (interceptorElements.size() == 1) {
            this.enabledInterceptorClasses = new ArrayList();
            this.enabledInterceptorClasses.addAll(BeansXmlParser.processElement(this.resourceLoader, (XmlElement)interceptorElements.get(0)));
        }
    }

    private static List<Class<? extends Annotation>> processDeployElement(ResourceLoader resourceLoader, XmlElement element) {
        ArrayList<Class<? extends Annotation>> list = new ArrayList<Class<? extends Annotation>>();
        for (Node child : new NodeListIterable(element.getElement().getChildNodes())) {
            String className = BeansXmlParser.processNode(child);
            if (className == null) continue;
            try {
                list.add(resourceLoader.classForName(className).asSubclass(Annotation.class));
            }
            catch (ResourceLoadingException e) {
                throw new DeploymentException("Cannot load class " + className + " defined in " + element.getFile().toString());
            }
        }
        return list;
    }

    private static String processNode(Node node) {
        if (node instanceof Element && node.getChildNodes().getLength() == 1 && node.getChildNodes().item(0) instanceof Text) {
            String className = ((Text)node.getChildNodes().item(0)).getData();
            return className;
        }
        return null;
    }

    private static List<Class<?>> processElement(ResourceLoader resourceLoader, XmlElement element) {
        ArrayList list = new ArrayList();
        for (Node child : new NodeListIterable(element.getElement().getChildNodes())) {
            String className = BeansXmlParser.processNode(child);
            if (className == null) continue;
            try {
                list.add(resourceLoader.classForName(className));
            }
            catch (ResourceLoadingException e) {
                throw new DeploymentException("Cannot load class " + className + " defined in " + element.getFile().toString());
            }
        }
        return list;
    }

    private static class XmlElement {
        private URL file;
        private Element element;

        public XmlElement(URL file, Element element) {
            this.file = file;
            this.element = element;
        }

        public URL getFile() {
            return this.file;
        }

        public Element getElement() {
            return this.element;
        }

        public String toString() {
            return "File: " + this.getFile() + "; Node: " + this.getElement();
        }
    }
}

