/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.commands;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.commands.CommandTable;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.ValidOption;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;

public class ListCommandsCommand
extends CLICommand {
    String[] remoteCommands;
    String[] localCommands;
    boolean localOnly;
    boolean remoteOnly;
    private static final String SPACES = "                                                            ";
    private static final LocalStringsImpl strings = new LocalStringsImpl(ListCommandsCommand.class);

    public ListCommandsCommand(String name, ProgramOptions programOpts, Environment env) throws CommandException {
        super(name, programOpts, env);
    }

    protected void prepare() throws CommandException, CommandValidationException {
        this.processProgramOptions();
        LinkedHashSet<ValidOption> opts = new LinkedHashSet<ValidOption>();
        ListCommandsCommand.addOption(opts, "localonly", '\u0000', "BOOLEAN", false, "false");
        ListCommandsCommand.addOption(opts, "remoteonly", '\u0000', "BOOLEAN", false, "false");
        ListCommandsCommand.addOption(opts, "help", '?', "BOOLEAN", false, "false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 0;
    }

    protected void validate() throws CommandException, CommandValidationException {
        super.validate();
        this.localOnly = this.getBooleanOption("localonly");
        this.remoteOnly = this.getBooleanOption("remoteonly");
        if (this.localOnly && this.remoteOnly) {
            throw new CommandException(strings.get("listCommands.notBoth"));
        }
    }

    public int executeCommand() throws CommandException, CommandValidationException {
        if (!this.remoteOnly) {
            this.getLocalCommands();
            this.printLocalCommands();
        }
        if (!this.localOnly) {
            this.getRemoteCommands();
            this.printRemoteCommands();
        }
        logger.printMessage("");
        return 0;
    }

    String[] getLocalCommands() throws CommandException {
        ArrayList names = new ArrayList();
        names.addAll(new CommandTable().keySet());
        this.localCommands = names.toArray(new String[names.size()]);
        Arrays.sort(this.localCommands);
        return this.localCommands;
    }

    String[] getRemoteCommands() throws CommandException, CommandValidationException {
        RemoteCommand cmd = new RemoteCommand("list-commands", this.programOpts, this.env);
        String cmds = cmd.executeAndReturnOutput("list-commands");
        ArrayList<String> rcmds = new ArrayList<String>();
        BufferedReader r = new BufferedReader(new StringReader(cmds));
        try {
            String line;
            while ((line = r.readLine()) != null) {
                int i;
                if (!line.startsWith("Command") || (i = line.indexOf(58)) < 0) continue;
                String s = line.substring(i + 1).trim();
                rcmds.add(s);
            }
        }
        catch (IOException ioex) {
            // empty catch block
        }
        Collections.sort(rcmds);
        this.remoteCommands = rcmds.toArray(new String[rcmds.size()]);
        return this.remoteCommands;
    }

    void printLocalCommands() {
        logger.printMessage("********** Local Commands **********");
        for (String s : this.localCommands) {
            logger.printMessage(s);
        }
    }

    void printRemoteCommands() {
        logger.printMessage("********** Remote Commands **********");
        int num = this.remoteCommands.length;
        int offset = num / 2 + num % 2;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < offset; ++i) {
            sb.append(this.remoteCommands[i]);
            sb.append(this.justify(this.remoteCommands[i], 40));
            if (i + offset < num) {
                sb.append(this.remoteCommands[i + offset]);
            }
            if (i >= offset - 1) continue;
            sb.append(CLIConstants.EOL);
        }
        logger.printMessage(sb.toString());
    }

    private String justify(String s, int width) {
        int numSpaces = width - s.length();
        return SPACES.substring(0, numSpaces);
    }
}

