/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import com.sun.grizzly.util.buf.MessageBytes;
import java.io.IOException;
import java.util.EventListener;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.glassfish.web.valve.GlassFishValve;

final class StandardContextValve
extends ValveBase {
    private static final String info = "org.apache.catalina.core.StandardContextValve/1.0";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private StandardContext context = null;
    private static java.util.logging.Logger log = java.util.logging.Logger.getLogger(StandardContextValve.class.getName());

    StandardContextValve() {
    }

    public String getInfo() {
        return info;
    }

    public void setContainer(Container container) {
        super.setContainer(container);
        this.context = (StandardContext)container;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        Wrapper wrapper = this.preInvoke(request, response);
        if (wrapper == null) {
            return 2;
        }
        if (wrapper.getPipeline().hasNonBasicValves() || wrapper.hasCustomPipeline()) {
            wrapper.getPipeline().invoke(request, response);
        } else {
            GlassFishValve basic = wrapper.getPipeline().getBasic();
            if (basic != null) {
                basic.invoke(request, response);
                basic.postInvoke(request, response);
            }
        }
        return 2;
    }

    public void invoke(org.apache.catalina.connector.Request request, org.apache.catalina.connector.Response response) throws IOException, ServletException {
        Wrapper wrapper = this.preInvoke(request, response);
        if (wrapper == null) {
            return;
        }
        if (wrapper.getPipeline().hasNonBasicValves() || wrapper.hasCustomPipeline()) {
            wrapper.getPipeline().invoke(request, response);
        } else {
            GlassFishValve basic = wrapper.getPipeline().getBasic();
            if (basic != null) {
                basic.invoke(request, response);
                basic.postInvoke(request, response);
            }
        }
        this.postInvoke(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(Request request, Response response) throws IOException, ServletException {
        List<EventListener> listeners = ((Context)this.container).getApplicationEventListeners();
        if (!listeners.isEmpty()) {
            ServletRequestEvent event = new ServletRequestEvent(((StandardContext)this.container).getServletContext(), request.getRequest());
            int len = listeners.size();
            for (int i = 0; i < len; ++i) {
                Object var12_11;
                EventListener eventListener = listeners.get(len - 1 - i);
                if (!(eventListener instanceof ServletRequestListener)) continue;
                ServletRequestListener listener = (ServletRequestListener)eventListener;
                this.container.fireContainerEvent("beforeRequestDestroyed", listener);
                try {
                    try {
                        listener.requestDestroyed(event);
                    }
                    catch (Throwable t) {
                        this.log(sm.getString("standardContextValve.requestListener.requestDestroyed", listener.getClass().getName()), t);
                        ServletRequest sreq = request.getRequest();
                        sreq.setAttribute("javax.servlet.error.exception", t);
                        var12_11 = null;
                        this.container.fireContainerEvent("afterRequestDestroyed", listener);
                        continue;
                    }
                    var12_11 = null;
                    this.container.fireContainerEvent("afterRequestDestroyed", listener);
                    continue;
                }
                catch (Throwable throwable) {
                    var12_11 = null;
                    this.container.fireContainerEvent("afterRequestDestroyed", listener);
                    throw throwable;
                }
            }
        }
    }

    private void notFound(HttpServletResponse response) {
        try {
            response.sendError(404);
        }
        catch (IllegalStateException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void log(String message) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardContextValve[" + this.container.getName() + "]: " + message);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("StandardContextValve[" + containerName + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardContextValve[" + this.container.getName() + "]: " + message, throwable);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("StandardContextValve[" + containerName + "]: " + message);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Wrapper preInvoke(Request request, Response response) {
        Wrapper wrapper;
        MessageBytes requestPathMB;
        HttpRequest hreq = (HttpRequest)request;
        if (request.getCheckRestrictedResources() && ((requestPathMB = hreq.getRequestPathMB()).startsWithIgnoreCase("/META-INF/", 0) || requestPathMB.equalsIgnoreCase("/META-INF") || requestPathMB.startsWithIgnoreCase("/WEB-INF/", 0) || requestPathMB.equalsIgnoreCase("/WEB-INF"))) {
            String requestURI = hreq.getDecodedRequestURI();
            this.notFound((HttpServletResponse)response.getResponse());
            return null;
        }
        boolean reloaded = false;
        while (((StandardContext)this.container).getPaused()) {
            reloaded = true;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        if (reloaded && this.context.getLoader() != null && this.context.getLoader().getClassLoader() != null) {
            Thread.currentThread().setContextClassLoader(this.context.getLoader().getClassLoader());
        }
        if ((wrapper = request.getWrapper()) == null) {
            String requestURI = hreq.getDecodedRequestURI();
            this.notFound((HttpServletResponse)response.getResponse());
            return null;
        }
        if (wrapper.isUnavailable() && (wrapper = (Wrapper)this.container.findChild(wrapper.getName())) == null) {
            String requestURI = hreq.getDecodedRequestURI();
            this.notFound((HttpServletResponse)response.getResponse());
            return null;
        }
        List<EventListener> listeners = ((Context)this.container).getApplicationEventListeners();
        ServletRequestEvent event = null;
        if (!listeners.isEmpty()) {
            event = new ServletRequestEvent(((StandardContext)this.container).getServletContext(), request.getRequest());
            for (EventListener eventListener : listeners) {
                Object var15_16;
                if (!(eventListener instanceof ServletRequestListener)) continue;
                ServletRequestListener listener = (ServletRequestListener)eventListener;
                this.container.fireContainerEvent("beforeRequestInitialized", listener);
                try {
                    try {
                        listener.requestInitialized(event);
                    }
                    catch (Throwable t) {
                        this.log(sm.getString("standardContextValve.requestListener.requestInit", listener.getClass().getName()), t);
                        ServletRequest sreq = request.getRequest();
                        sreq.setAttribute("javax.servlet.error.exception", t);
                        Wrapper wrapper2 = null;
                        var15_16 = null;
                        this.container.fireContainerEvent("afterRequestInitialized", listener);
                        return wrapper2;
                    }
                    var15_16 = null;
                    this.container.fireContainerEvent("afterRequestInitialized", listener);
                }
                catch (Throwable throwable) {
                    var15_16 = null;
                    this.container.fireContainerEvent("afterRequestInitialized", listener);
                    throw throwable;
                }
            }
        }
        return wrapper;
    }
}

