/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.jruby;

import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.scripting.jruby.Messages;
import org.glassfish.scripting.jruby.common.config.JRubyConfig;
import org.glassfish.scripting.jruby.monitor.JRubyHttpStatsProvider;
import org.glassfish.scripting.jruby.monitor.JRubyRuntimePoolStatsProvider;

public class JRubyApplication
implements ApplicationContainer {
    private final Logger logger;
    private Object jRubyRuntime;
    private Adapter adapter;
    private final RequestDispatcher dispatcher;
    private ClassLoader acl;
    private final ServerEnvironment serverEnvironment;
    private final DeploymentContext deploymentContext;
    private final JRubyConfig config;
    private final String appName;
    private final JRubyRuntimePoolStatsProvider jRubyRuntimePoolStatsProvider;
    private final JRubyHttpStatsProvider jRubyHttpStatsProvider;

    public JRubyApplication(DeploymentContext context, ServerEnvironment env, RequestDispatcher dispatcher, JRubyConfig config) throws IOException {
        this.logger = context.getLogger();
        this.dispatcher = dispatcher;
        this.serverEnvironment = env;
        this.deploymentContext = context;
        this.appName = ((DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class)).name;
        this.config = config;
        this.jRubyRuntimePoolStatsProvider = new JRubyRuntimePoolStatsProvider(this.appName, config.contextRoot());
        this.jRubyHttpStatsProvider = new JRubyHttpStatsProvider(this.appName, config.contextRoot());
        context.getLogger().info(Messages.format("railsdeployer.loading.info", ((DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class)).name, config.contextRoot()));
    }

    private boolean initJRubyGrizzlyAdapter() {
        try {
            URL[] urls = this.findJRubyJars();
            if (urls.length == 0) {
                return false;
            }
            URLClassLoader cl = new URLClassLoader(urls, JRubyApplication.class.getClassLoader());
            Class<?> c = cl.loadClass("com.sun.grizzly.jruby.RubyRuntime");
            this.jRubyRuntime = c.getConstructor(JRubyConfig.class).newInstance(this.config);
            this.adapter = (Adapter)c.getMethod("getAdapter", new Class[0]).invoke(this.jRubyRuntime, new Object[0]);
            this.startJRubyGrizzlyAdapter();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, Messages.format("railsapplication.adaptor.creation.error", e.getMessage()), e);
            return false;
        }
        return true;
    }

    private boolean startJRubyGrizzlyAdapter() {
        try {
            this.jRubyRuntime.getClass().getMethod("start", new Class[0]).invoke(this.jRubyRuntime, new Object[0]);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, Messages.format("railsapplication.adaptor.creation.error", e.getMessage()), e);
            return false;
        }
        return true;
    }

    public boolean stop(ApplicationContext startupContext) {
        try {
            this.jRubyRuntime.getClass().getMethod("destroy", new Class[0]).invoke(this.jRubyRuntime, new Object[0]);
            StatsProviderManager.unregister(this.jRubyHttpStatsProvider);
            StatsProviderManager.unregister(this.jRubyRuntimePoolStatsProvider);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, Messages.format("railsapplication.error.stopping", this.config.contextRoot(), e.getMessage()), e);
            return false;
        }
        return true;
    }

    public boolean suspend() {
        return false;
    }

    public boolean resume() {
        return false;
    }

    public ClassLoader getClassLoader() {
        return this.acl;
    }

    public Object getDescriptor() {
        return null;
    }

    public boolean start(ApplicationContext startupContext) throws Exception {
        this.acl = startupContext.getClassLoader();
        if (!this.initJRubyGrizzlyAdapter()) {
            return false;
        }
        try {
            String ctx = this.config.contextRoot();
            if (this.config.contextRoot().equals("/")) {
                ctx = "";
            }
            this.dispatcher.registerEndpoint(ctx, this.adapter, (ApplicationContainer)this);
        }
        catch (EndpointRegistrationException e) {
            this.logger.log(Level.SEVERE, Messages.format("railsdeployer.adapter.registry.err", startupContext.getAppProps().getProperty(((DeployCommandParameters)this.deploymentContext.getCommandParameters(DeployCommandParameters.class)).name)), e);
            return false;
        }
        System.out.println("Ready to serve the request");
        StatsProviderManager.register("jruby-runtime-pool", PluginPoint.SERVER, "containers/jruby/runtime-pool/" + this.appName, this.jRubyRuntimePoolStatsProvider);
        StatsProviderManager.register("jruby-http-stats", PluginPoint.SERVER, "containers/jruby/http-stats/" + this.appName, this.jRubyHttpStatsProvider);
        return true;
    }

    public String getContextRoot() {
        return this.config.contextRoot();
    }

    public void service(Request request, Response response) throws Exception {
        this.adapter.service(request, response);
    }

    public void afterService(Request request, Response response) throws Exception {
        this.adapter.afterService(request, response);
    }

    private URL[] findJRubyJars() throws MalformedURLException, ClassNotFoundException {
        ArrayList<URL> urls = new ArrayList<URL>();
        File jrubyLibDir = new File(this.config.jrubyHome(), "lib");
        if (!jrubyLibDir.exists()) {
            this.logger.severe("Invalid JRuby instalation, no 'lib' directory present inside JRuby installation at: " + this.config.jrubyHome());
            return urls.toArray(new URL[0]);
        }
        for (File lib : jrubyLibDir.listFiles()) {
            if (!lib.isFile() || !lib.toString().endsWith(".jar")) continue;
            urls.add(lib.toURI().toURL());
        }
        File grizzlyjruby = this.serverEnvironment.getStartupContext().getRootDirectory();
        File[] grizzlyjrubyJars = grizzlyjruby.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !name.startsWith("grizzly-jruby-module") && name.startsWith("grizzly-jruby");
            }
        });
        if (grizzlyjrubyJars.length > 0) {
            urls.add(grizzlyjrubyJars[0].toURI().toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

